/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.SingleChildProcessNode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ExplainAnalyzeNode
extends SingleChildProcessNode {
    private final boolean verbose;
    private final long queryId;
    private final long timeout;

    public ExplainAnalyzeNode(PlanNodeId id, PlanNode child, boolean verbose, long queryId, long timeout) {
        super(id, child);
        this.verbose = verbose;
        this.queryId = queryId;
        this.timeout = timeout;
    }

    @Override
    public PlanNode clone() {
        return new ExplainAnalyzeNode(this.getPlanNodeId(), this.child, this.verbose, this.queryId, this.timeout);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitExplainAnalyze(this, context);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.singletonList("Explain Analyze");
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.EXPLAIN_ANALYZE.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.verbose, (ByteBuffer)byteBuffer);
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.EXPLAIN_ANALYZE.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.verbose, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.queryId, (OutputStream)stream);
        ReadWriteIOUtils.write((long)this.timeout, (OutputStream)stream);
    }

    public static ExplainAnalyzeNode deserialize(ByteBuffer byteBuffer) {
        boolean verbose = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        long queryId = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        PlanNodeId planNodeId = PlanNodeId.deserialize(byteBuffer);
        long timeout = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        return new ExplainAnalyzeNode(planNodeId, null, verbose, queryId, timeout);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public long getQueryId() {
        return this.queryId;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExplainAnalyzeNode)) {
            return false;
        }
        ExplainAnalyzeNode that = (ExplainAnalyzeNode)o;
        return this.verbose == that.verbose && this.queryId == that.queryId && this.timeout == that.timeout;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + Boolean.hashCode(this.verbose) + Long.hashCode(this.queryId) + Long.hashCode(this.timeout);
    }
}

