/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.queryengine.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeSchemaCache;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.AutoCreateSchemaExecutor;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetchExecutor;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaComputationWithAutoCreation;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.NormalSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.TemplateSchemaFetcher;
import org.apache.iotdb.db.schemaengine.template.ClusterTemplateManager;
import org.apache.iotdb.db.schemaengine.template.ITemplateManager;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class ClusterSchemaFetcher
implements ISchemaFetcher {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final Coordinator coordinator = Coordinator.getInstance();
    private final DataNodeSchemaCache schemaCache = DataNodeSchemaCache.getInstance();
    private final ITemplateManager templateManager = ClusterTemplateManager.getInstance();
    private final AutoCreateSchemaExecutor autoCreateSchemaExecutor = new AutoCreateSchemaExecutor(this.coordinator, this.templateManager, this);
    private final ClusterSchemaFetchExecutor clusterSchemaFetchExecutor = new ClusterSchemaFetchExecutor(this.coordinator, this.templateManager, this, this.schemaCache::put);
    private final NormalSchemaFetcher normalSchemaFetcher = new NormalSchemaFetcher(this.schemaCache, this.autoCreateSchemaExecutor, this.clusterSchemaFetchExecutor);
    private final TemplateSchemaFetcher templateSchemaFetcher = new TemplateSchemaFetcher(this.schemaCache, this.autoCreateSchemaExecutor, this.clusterSchemaFetchExecutor);

    public static ClusterSchemaFetcher getInstance() {
        return ClusterSchemaFetcherHolder.INSTANCE;
    }

    private ClusterSchemaFetcher() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterSchemaTree fetchSchema(PathPatternTree patternTree, boolean withTemplate, MPPQueryContext context) {
        patternTree.constructTree();
        List pathPatternList = patternTree.getAllPathPatterns();
        ArrayList<PartialPath> explicitPathList = new ArrayList<PartialPath>();
        HashSet<PartialPath> explicitDevicePatternList = new HashSet<PartialPath>();
        int explicitDevicePatternCount = 0;
        for (PartialPath pattern : pathPatternList) {
            if (pattern.hasExplicitDevice() && this.templateManager.checkTemplateSetInfo(pattern) != null) {
                explicitDevicePatternList.add(pattern.getDevicePath());
                ++explicitDevicePatternCount;
                continue;
            }
            if (pattern.hasWildcard()) continue;
            explicitPathList.add(pattern);
        }
        if (explicitPathList.size() + explicitDevicePatternCount < pathPatternList.size()) {
            return this.clusterSchemaFetchExecutor.fetchSchemaOfFuzzyMatch(patternTree, false, withTemplate, context);
        }
        this.schemaCache.takeReadLock();
        try {
            Object object;
            ClusterSchemaTree cachedSchema;
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            boolean isAllCached = true;
            HashSet<String> storageGroupSet = new HashSet<String>();
            if (!explicitDevicePatternList.isEmpty()) {
                for (PartialPath explicitDevicePattern : explicitDevicePatternList) {
                    cachedSchema = this.schemaCache.getMatchedSchemaWithTemplate(explicitDevicePattern);
                    if (cachedSchema.isEmpty()) {
                        isAllCached = false;
                        break;
                    }
                    schemaTree.mergeSchemaTree(cachedSchema);
                    storageGroupSet.addAll(cachedSchema.getDatabases());
                }
            }
            if (isAllCached && !explicitPathList.isEmpty()) {
                for (PartialPath fullPath : explicitPathList) {
                    cachedSchema = this.schemaCache.getMatchedSchemaWithoutTemplate(fullPath);
                    if (cachedSchema.isEmpty()) {
                        isAllCached = false;
                        break;
                    }
                    schemaTree.mergeSchemaTree(cachedSchema);
                    storageGroupSet.addAll(cachedSchema.getDatabases());
                }
            }
            if (isAllCached) {
                schemaTree.setDatabases(storageGroupSet);
                object = schemaTree;
                return object;
            }
            object = this.clusterSchemaFetchExecutor.fetchSchemaOfPreciseMatchOrPreciseDeviceUsingTemplate(pathPatternList, patternTree, withTemplate, context);
            return object;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public ClusterSchemaTree fetchSchemaWithTags(PathPatternTree patternTree, boolean withTemplate, MPPQueryContext context) {
        patternTree.constructTree();
        return this.clusterSchemaFetchExecutor.fetchSchemaOfFuzzyMatch(patternTree, true, withTemplate, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndComputeSchemaWithAutoCreate(ISchemaComputationWithAutoCreation schemaComputationWithAutoCreation, MPPQueryContext context) {
        this.schemaCache.takeInsertLock();
        context.addAcquiredLockNum();
        this.schemaCache.takeReadLock();
        try {
            Pair<Template, PartialPath> templateSetInfo = this.templateManager.checkTemplateSetInfo(schemaComputationWithAutoCreation.getDevicePath());
            List<Integer> indexOfMissingMeasurements = templateSetInfo == null ? this.normalSchemaFetcher.processNormalTimeSeries(schemaComputationWithAutoCreation, context) : this.templateSchemaFetcher.processTemplateTimeSeries(templateSetInfo, schemaComputationWithAutoCreation, context);
            if (indexOfMissingMeasurements.isEmpty()) {
                return;
            }
            for (int index : indexOfMissingMeasurements) {
                schemaComputationWithAutoCreation.computeMeasurement(index, null);
            }
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fetchAndComputeSchemaWithAutoCreate(List<? extends ISchemaComputationWithAutoCreation> schemaComputationWithAutoCreationList, MPPQueryContext context) {
        this.schemaCache.takeInsertLock();
        context.addAcquiredLockNum();
        this.schemaCache.takeReadLock();
        try {
            ArrayList<ISchemaComputationWithAutoCreation> normalTimeSeriesRequestList = new ArrayList<ISchemaComputationWithAutoCreation>();
            ArrayList<ISchemaComputationWithAutoCreation> templateTimeSeriesRequestList = new ArrayList<ISchemaComputationWithAutoCreation>();
            ArrayList<Pair<Template, PartialPath>> templateSetInfoList = new ArrayList<Pair<Template, PartialPath>>();
            for (ISchemaComputationWithAutoCreation iSchemaComputationWithAutoCreation : schemaComputationWithAutoCreationList) {
                Pair<Template, PartialPath> templateSetInfo = this.templateManager.checkTemplateSetInfo(iSchemaComputationWithAutoCreation.getDevicePath());
                if (templateSetInfo == null) {
                    normalTimeSeriesRequestList.add(iSchemaComputationWithAutoCreation);
                    continue;
                }
                templateTimeSeriesRequestList.add(iSchemaComputationWithAutoCreation);
                templateSetInfoList.add(templateSetInfo);
            }
            if (!normalTimeSeriesRequestList.isEmpty()) {
                this.normalSchemaFetcher.processNormalTimeSeries(normalTimeSeriesRequestList, context);
            }
            if (!templateTimeSeriesRequestList.isEmpty()) {
                this.templateSchemaFetcher.processTemplateTimeSeries(templateSetInfoList, templateTimeSeriesRequestList, context);
            }
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ISchemaTree fetchSchemaListWithAutoCreate(List<PartialPath> devicePathList, List<String[]> measurementsList, List<TSDataType[]> tsDataTypesList, List<TSEncoding[]> encodingsList, List<CompressionType[]> compressionTypesList, List<Boolean> isAlignedList, MPPQueryContext context) {
        this.schemaCache.takeInsertLock();
        context.addAcquiredLockNum();
        this.schemaCache.takeReadLock();
        try {
            Object indexOfMissingMeasurements;
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            ArrayList<List<Integer>> indexOfMissingMeasurementsList = new ArrayList<List<Integer>>(devicePathList.size());
            ArrayList<Integer> indexOfDevicesWithMissingMeasurements = new ArrayList<Integer>();
            for (int i = 0; i < devicePathList.size(); ++i) {
                schemaTree.mergeSchemaTree(this.schemaCache.get(devicePathList.get(i), measurementsList.get(i)));
                indexOfMissingMeasurements = this.checkMissingMeasurements(schemaTree, devicePathList.get(i), measurementsList.get(i));
                if (indexOfMissingMeasurements.isEmpty()) continue;
                indexOfDevicesWithMissingMeasurements.add(i);
                indexOfMissingMeasurementsList.add((List<Integer>)indexOfMissingMeasurements);
            }
            if (indexOfDevicesWithMissingMeasurements.isEmpty()) {
                ClusterSchemaTree i = schemaTree;
                return i;
            }
            ClusterSchemaTree remoteSchemaTree = this.clusterSchemaFetchExecutor.fetchSchemaOfMultiDevices(devicePathList, measurementsList, indexOfDevicesWithMissingMeasurements, indexOfMissingMeasurementsList, context);
            if (!remoteSchemaTree.isEmpty()) {
                schemaTree.mergeSchemaTree(remoteSchemaTree);
            }
            if (!this.config.isAutoCreateSchemaEnabled()) {
                indexOfMissingMeasurements = schemaTree;
                return indexOfMissingMeasurements;
            }
            ArrayList<Integer> indexOfDevicesNeedAutoCreateSchema = new ArrayList<Integer>();
            ArrayList<List<Integer>> indexOfMeasurementsNeedAutoCreate = new ArrayList<List<Integer>>();
            int size = indexOfDevicesWithMissingMeasurements.size();
            for (int i = 0; i < size; ++i) {
                int deviceIndex = (Integer)indexOfDevicesWithMissingMeasurements.get(i);
                List<Integer> indexOfMissingMeasurements2 = (List<Integer>)indexOfMissingMeasurementsList.get(i);
                indexOfMissingMeasurements2 = this.checkMissingMeasurementsAfterSchemaFetch(schemaTree, devicePathList.get(deviceIndex), indexOfMissingMeasurements2, measurementsList.get(deviceIndex));
                if (indexOfMissingMeasurements2.isEmpty()) continue;
                indexOfDevicesNeedAutoCreateSchema.add(deviceIndex);
                indexOfMeasurementsNeedAutoCreate.add(indexOfMissingMeasurements2);
            }
            if (!indexOfDevicesNeedAutoCreateSchema.isEmpty()) {
                this.autoCreateSchemaExecutor.autoCreateMissingMeasurements(schemaTree, devicePathList, indexOfDevicesNeedAutoCreateSchema, indexOfMeasurementsNeedAutoCreate, measurementsList, tsDataTypesList, encodingsList, compressionTypesList, isAlignedList, context);
            }
            ClusterSchemaTree clusterSchemaTree = schemaTree;
            return clusterSchemaTree;
        }
        finally {
            this.schemaCache.releaseReadLock();
        }
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetInfo(PartialPath devicePath) {
        return this.templateManager.checkTemplateSetInfo(devicePath);
    }

    @Override
    public Pair<Template, PartialPath> checkTemplateSetAndPreSetInfo(PartialPath timeSeriesPath, String alias) {
        return this.templateManager.checkTemplateSetAndPreSetInfo(timeSeriesPath, alias);
    }

    @Override
    public Map<Integer, Template> checkAllRelatedTemplate(PartialPath pathPattern) {
        return this.templateManager.checkAllRelatedTemplate(pathPattern);
    }

    @Override
    public Pair<Template, List<PartialPath>> getAllPathsSetTemplate(String templateName) {
        return this.templateManager.getAllPathsSetTemplate(templateName);
    }

    private List<Integer> checkMissingMeasurements(ISchemaTree schemaTree, PartialPath devicePath, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, Arrays.asList(measurements));
        if (deviceSchemaInfo == null) {
            return IntStream.range(0, measurements.length).boxed().collect(Collectors.toList());
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        for (int i = 0; i < measurements.length; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(i);
        }
        return indexOfMissingMeasurements;
    }

    private List<Integer> checkMissingMeasurementsAfterSchemaFetch(ClusterSchemaTree schemaTree, PartialPath devicePath, List<Integer> indexOfTargetMeasurements, String[] measurements) {
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, indexOfTargetMeasurements.stream().map(index -> measurements[index]).collect(Collectors.toList()));
        if (deviceSchemaInfo == null) {
            return indexOfTargetMeasurements;
        }
        ArrayList<Integer> indexOfMissingMeasurements = new ArrayList<Integer>();
        List<MeasurementSchema> schemaList = deviceSchemaInfo.getMeasurementSchemaList();
        int size = schemaList.size();
        for (int i = 0; i < size; ++i) {
            if (schemaList.get(i) != null) continue;
            indexOfMissingMeasurements.add(indexOfTargetMeasurements.get(i));
        }
        return indexOfMissingMeasurements;
    }

    private static final class ClusterSchemaFetcherHolder {
        private static final ClusterSchemaFetcher INSTANCE = new ClusterSchemaFetcher();

        private ClusterSchemaFetcherHolder() {
        }
    }
}

