/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.common.MPPQueryContext;
import org.apache.iotdb.db.queryengine.common.NodeRef;
import org.apache.iotdb.db.queryengine.common.header.DatasetHeader;
import org.apache.iotdb.db.queryengine.common.schematree.ISchemaTree;
import org.apache.iotdb.db.queryengine.plan.analyze.IAnalysis;
import org.apache.iotdb.db.queryengine.plan.analyze.QueryType;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySource;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySourceContext;
import org.apache.iotdb.db.queryengine.plan.execution.memory.StatementMemorySourceVisitor;
import org.apache.iotdb.db.queryengine.plan.expression.Expression;
import org.apache.iotdb.db.queryengine.plan.expression.ExpressionType;
import org.apache.iotdb.db.queryengine.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.DeviceViewIntoPathDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.IntoPathDescriptor;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementType;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.db.queryengine.plan.statement.component.SortItem;
import org.apache.iotdb.db.queryengine.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ExplainAnalyzeStatement;
import org.apache.iotdb.db.queryengine.plan.statement.sys.ShowQueriesStatement;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;

public class Analysis
implements IAnalysis {
    private Statement statement;
    private DataPartition dataPartition;
    private SchemaPartition schemaPartition;
    private ISchemaTree schemaTree;
    private List<TEndPoint> redirectNodeList;
    private final Map<NodeRef<Expression>, TSDataType> expressionTypes = new LinkedHashMap<NodeRef<Expression>, TSDataType>();
    private boolean finishQueryAfterAnalyze = false;
    private TSStatus failStatus;
    private Set<Expression> sourceExpressions;
    private Set<Expression> sourceTransformExpressions = new HashSet<Expression>();
    private Expression whereExpression;
    private Expression groupByExpression;
    private Set<Expression> aggregationExpressions;
    private Map<Expression, Set<Expression>> crossGroupByExpressions;
    private List<String> tagKeys;
    private Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands;
    private List<PartialPath> deviceList;
    private Map<String, Set<Expression>> deviceToSourceExpressions;
    private Map<String, Set<Expression>> deviceToSourceTransformExpressions = new HashMap<String, Set<Expression>>();
    private Map<String, Expression> deviceToWhereExpression;
    private Map<String, Set<Expression>> deviceToAggregationExpressions = new HashMap<String, Set<Expression>>();
    private Map<String, Set<Expression>> deviceToSelectExpressions;
    private Map<String, Expression> deviceToGroupByExpression;
    private Map<String, Set<Expression>> deviceToOrderByExpressions;
    private Map<String, List<SortItem>> deviceToSortItems;
    private Map<String, List<Integer>> deviceViewInputIndexesMap;
    private Set<Expression> deviceViewOutputExpressions;
    private Map<String, Set<Expression>> deviceToOutputExpressions = new HashMap<String, Set<Expression>>();
    private Map<String, String> outputDeviceToQueriedDevicesMap;
    private boolean deviceViewSpecialProcess;
    private boolean hasValueFilter = false;
    private Expression globalTimePredicate;
    private Set<Expression> selectExpressions;
    private Expression havingExpression;
    private Set<Expression> orderByExpressions;
    private boolean hasSortNode = false;
    private FillDescriptor fillDescriptor;
    private GroupByTimeParameter groupByTimeParameter;
    private GroupByParameter groupByParameter;
    private OrderByParameter mergeOrderParameter;
    private Ordering timeseriesOrderingForLastQuery = null;
    private Map<Expression, List<Expression>> lastQueryNonWritableViewSourceExpressionMap;
    private Set<Expression> lastQueryBaseExpressions;
    private DatasetHeader respDatasetHeader;
    private boolean isVirtualSource = false;
    private DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor;
    private IntoPathDescriptor intoPathDescriptor;
    private Set<TSchemaNode> matchedNodes;
    private Pair<Template, List<PartialPath>> templateSetInfo;
    private Map<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap;
    private Map<Integer, Template> relatedTemplateInfo;
    private List<PartialPath> specifiedTemplateRelatedPathPatternList;
    private boolean useLogicalView = false;
    private List<Pair<Expression, String>> outputExpressions = null;
    private List<TDataNodeLocation> runningDataNodeLocations;
    private boolean lastLevelUseWildcard = false;
    private boolean useTopKNode = false;
    private Template deviceTemplate;
    private boolean onlyQueryTemplateMeasurements = true;
    private boolean templateWildCardQuery;
    private List<String> measurementList;
    private List<IMeasurementSchema> measurementSchemaList;
    private final Set<NodeRef<FilterNode>> fromWhereFilterNodes = new HashSet<NodeRef<FilterNode>>();

    public List<TRegionReplicaSet> getPartitionInfo(PartialPath seriesPath, Filter timefilter) {
        return this.dataPartition.getDataRegionReplicaSetWithTimeFilter(seriesPath.getDevice(), timefilter);
    }

    public TRegionReplicaSet getPartitionInfo(PartialPath seriesPath, TTimePartitionSlot tTimePartitionSlot) {
        return (TRegionReplicaSet)this.dataPartition.getDataRegionReplicaSet(seriesPath.getDevice(), tTimePartitionSlot).get(0);
    }

    public List<List<TTimePartitionSlot>> getTimePartitionRange(PartialPath seriesPath, Filter timefilter) {
        return this.dataPartition.getTimePartitionRange(seriesPath.getDevice(), timefilter);
    }

    public List<TRegionReplicaSet> getPartitionInfo(String deviceName, Filter globalTimeFilter) {
        return this.dataPartition.getDataRegionReplicaSetWithTimeFilter(deviceName, globalTimeFilter);
    }

    public QueryStatement getQueryStatement() {
        if (this.statement instanceof ExplainAnalyzeStatement) {
            return ((ExplainAnalyzeStatement)this.statement).getQueryStatement();
        }
        return (QueryStatement)this.statement;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public DataPartition getDataPartitionInfo() {
        return this.dataPartition;
    }

    public void setDataPartitionInfo(DataPartition dataPartition) {
        this.dataPartition = dataPartition;
    }

    public SchemaPartition getSchemaPartitionInfo() {
        return this.schemaPartition;
    }

    public void setSchemaPartitionInfo(SchemaPartition schemaPartition) {
        this.schemaPartition = schemaPartition;
    }

    public ISchemaTree getSchemaTree() {
        return this.schemaTree;
    }

    public void setSchemaTree(ISchemaTree schemaTree) {
        this.schemaTree = schemaTree;
    }

    public List<TEndPoint> getRedirectNodeList() {
        return this.redirectNodeList;
    }

    public void setRedirectNodeList(List<TEndPoint> redirectNodeList) {
        this.redirectNodeList = redirectNodeList;
    }

    public void addEndPointToRedirectNodeList(TEndPoint endPoint) {
        if (this.redirectNodeList == null) {
            this.redirectNodeList = new ArrayList<TEndPoint>();
        }
        this.redirectNodeList.add(endPoint);
    }

    public Expression getGlobalTimePredicate() {
        return this.globalTimePredicate;
    }

    public void setGlobalTimePredicate(Expression timeFilter) {
        this.globalTimePredicate = timeFilter;
    }

    @Override
    public DatasetHeader getRespDatasetHeader() {
        return this.respDatasetHeader;
    }

    public void setRespDatasetHeader(DatasetHeader respDatasetHeader) {
        this.respDatasetHeader = respDatasetHeader;
    }

    public TSDataType getType(Expression expression) {
        if (expression.getExpressionType().equals((Object)ExpressionType.NULL)) {
            return null;
        }
        if (this.isAllDevicesInOneTemplate() && (this.isOnlyQueryTemplateMeasurements() || expression instanceof TimeSeriesOperand)) {
            TimeSeriesOperand seriesOperand = (TimeSeriesOperand)expression;
            return this.deviceTemplate.getSchemaMap().get(seriesOperand.getPath().getMeasurement()).getType();
        }
        TSDataType type = this.expressionTypes.get(NodeRef.of(expression));
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (String)"Expression is not analyzed: %s", (Object)expression);
        return type;
    }

    @Override
    public boolean canSkipExecute(MPPQueryContext context) {
        return this.isFinishQueryAfterAnalyze() || context.getQueryType() == QueryType.READ && !this.hasDataSource();
    }

    private boolean hasDataSource() {
        return this.dataPartition != null && !this.dataPartition.isEmpty() || this.schemaPartition != null && !this.schemaPartition.isEmpty() || this.statement instanceof ShowQueriesStatement || this.statement instanceof QueryStatement && ((QueryStatement)this.statement).isAggregationQuery();
    }

    @Override
    public TsBlock constructResultForMemorySource(MPPQueryContext context) {
        StatementMemorySource memorySource = (StatementMemorySource)new StatementMemorySourceVisitor().process(this.getStatement(), new StatementMemorySourceContext(context, this));
        this.setRespDatasetHeader(memorySource.getDatasetHeader());
        return memorySource.getTsBlock();
    }

    @Override
    public boolean isQuery() {
        return this.statement.isQuery();
    }

    @Override
    public boolean needSetHighestPriority() {
        return StatementType.SHOW_QUERIES.equals((Object)this.statement.getType());
    }

    @Override
    public String getStatementType() {
        return this.statement.getType().name();
    }

    public Map<Expression, Set<Expression>> getCrossGroupByExpressions() {
        return this.crossGroupByExpressions;
    }

    public void setCrossGroupByExpressions(Map<Expression, Set<Expression>> crossGroupByExpressions) {
        this.crossGroupByExpressions = crossGroupByExpressions;
    }

    public FillDescriptor getFillDescriptor() {
        return this.fillDescriptor;
    }

    public void setFillDescriptor(FillDescriptor fillDescriptor) {
        this.fillDescriptor = fillDescriptor;
    }

    public boolean hasValueFilter() {
        return this.hasValueFilter;
    }

    public void setHasValueFilter(boolean hasValueFilter) {
        this.hasValueFilter = hasValueFilter;
    }

    public Expression getWhereExpression() {
        return this.whereExpression;
    }

    public void setWhereExpression(Expression whereExpression) {
        this.whereExpression = whereExpression;
    }

    public Map<String, Expression> getDeviceToWhereExpression() {
        return this.deviceToWhereExpression;
    }

    public void setDeviceToWhereExpression(Map<String, Expression> deviceToWhereExpression) {
        this.deviceToWhereExpression = deviceToWhereExpression;
    }

    public GroupByTimeParameter getGroupByTimeParameter() {
        return this.groupByTimeParameter;
    }

    public Expression getHavingExpression() {
        return this.havingExpression;
    }

    public void setHavingExpression(Expression havingExpression) {
        this.havingExpression = havingExpression;
    }

    public void setGroupByTimeParameter(GroupByTimeParameter groupByTimeParameter) {
        this.groupByTimeParameter = groupByTimeParameter;
    }

    public void setGroupByParameter(GroupByParameter groupByParameter) {
        this.groupByParameter = groupByParameter;
    }

    public GroupByParameter getGroupByParameter() {
        return this.groupByParameter;
    }

    public boolean hasGroupByParameter() {
        return this.groupByParameter != null;
    }

    public boolean isFinishQueryAfterAnalyze() {
        return this.finishQueryAfterAnalyze;
    }

    public void setFinishQueryAfterAnalyze(boolean finishQueryAfterAnalyze) {
        this.finishQueryAfterAnalyze = finishQueryAfterAnalyze;
    }

    @Override
    public boolean isFailed() {
        return this.failStatus != null;
    }

    @Override
    public TSStatus getFailStatus() {
        return this.failStatus;
    }

    public void setFailStatus(TSStatus status) {
        this.failStatus = status;
    }

    public void setDeviceViewInputIndexesMap(Map<String, List<Integer>> deviceViewInputIndexesMap) {
        this.deviceViewInputIndexesMap = deviceViewInputIndexesMap;
    }

    public Map<String, List<Integer>> getDeviceViewInputIndexesMap() {
        return this.deviceViewInputIndexesMap;
    }

    public Set<Expression> getSourceExpressions() {
        return this.sourceExpressions;
    }

    public void setSourceExpressions(Set<Expression> sourceExpressions) {
        this.sourceExpressions = sourceExpressions;
    }

    public Set<Expression> getSourceTransformExpressions() {
        return this.sourceTransformExpressions;
    }

    public void setSourceTransformExpressions(Set<Expression> sourceTransformExpressions) {
        this.sourceTransformExpressions = sourceTransformExpressions;
    }

    public Set<Expression> getAggregationExpressions() {
        return this.aggregationExpressions;
    }

    public void setAggregationExpressions(Set<Expression> aggregationExpressions) {
        this.aggregationExpressions = aggregationExpressions;
    }

    public Set<Expression> getSelectExpressions() {
        return this.selectExpressions;
    }

    public void setSelectExpressions(Set<Expression> selectExpressions) {
        this.selectExpressions = selectExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSourceExpressions() {
        return this.deviceToSourceExpressions;
    }

    public void setDeviceToSourceExpressions(Map<String, Set<Expression>> deviceToSourceExpressions) {
        this.deviceToSourceExpressions = deviceToSourceExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSourceTransformExpressions() {
        return this.deviceToSourceTransformExpressions;
    }

    public void setDeviceToSourceTransformExpressions(Map<String, Set<Expression>> deviceToSourceTransformExpressions) {
        this.deviceToSourceTransformExpressions = deviceToSourceTransformExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToAggregationExpressions() {
        return this.deviceToAggregationExpressions;
    }

    public void setDeviceToAggregationExpressions(Map<String, Set<Expression>> deviceToAggregationExpressions) {
        this.deviceToAggregationExpressions = deviceToAggregationExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToSelectExpressions() {
        return this.deviceToSelectExpressions;
    }

    public void setDeviceToSelectExpressions(Map<String, Set<Expression>> deviceToSelectExpressions) {
        this.deviceToSelectExpressions = deviceToSelectExpressions;
    }

    public Expression getGroupByExpression() {
        return this.groupByExpression;
    }

    public void setGroupByExpression(Expression groupByExpression) {
        this.groupByExpression = groupByExpression;
    }

    public Map<String, Expression> getDeviceToGroupByExpression() {
        return this.deviceToGroupByExpression;
    }

    public void setDeviceToGroupByExpression(Map<String, Expression> deviceToGroupByExpression) {
        this.deviceToGroupByExpression = deviceToGroupByExpression;
    }

    public Set<TSchemaNode> getMatchedNodes() {
        return this.matchedNodes;
    }

    public void setMatchedNodes(Set<TSchemaNode> matchedNodes) {
        this.matchedNodes = matchedNodes;
    }

    public OrderByParameter getMergeOrderParameter() {
        return this.mergeOrderParameter;
    }

    public void setMergeOrderParameter(OrderByParameter mergeOrderParameter) {
        this.mergeOrderParameter = mergeOrderParameter;
    }

    public Pair<Template, List<PartialPath>> getTemplateSetInfo() {
        return this.templateSetInfo;
    }

    public void setTemplateSetInfo(Pair<Template, List<PartialPath>> templateSetInfo) {
        this.templateSetInfo = templateSetInfo;
    }

    public Map<PartialPath, Pair<Template, PartialPath>> getDeviceTemplateSetInfoMap() {
        return this.deviceTemplateSetInfoMap;
    }

    public void setDeviceTemplateSetInfoMap(Map<PartialPath, Pair<Template, PartialPath>> deviceTemplateSetInfoMap) {
        this.deviceTemplateSetInfoMap = deviceTemplateSetInfoMap;
    }

    public Map<Integer, Template> getRelatedTemplateInfo() {
        return this.relatedTemplateInfo;
    }

    public void setRelatedTemplateInfo(Map<Integer, Template> relatedTemplateInfo) {
        this.relatedTemplateInfo = relatedTemplateInfo;
    }

    public List<PartialPath> getSpecifiedTemplateRelatedPathPatternList() {
        return this.specifiedTemplateRelatedPathPatternList;
    }

    public void setSpecifiedTemplateRelatedPathPatternList(List<PartialPath> specifiedTemplateRelatedPathPatternList) {
        this.specifiedTemplateRelatedPathPatternList = specifiedTemplateRelatedPathPatternList;
    }

    public void addTypes(Map<NodeRef<Expression>, TSDataType> types) {
        this.expressionTypes.putAll(types);
    }

    public void setExpressionType(Expression expression, TSDataType type) {
        this.expressionTypes.put(NodeRef.of(expression), type);
    }

    public Set<Expression> getDeviceViewOutputExpressions() {
        return this.deviceViewOutputExpressions;
    }

    public void setDeviceViewOutputExpressions(Set<Expression> deviceViewOutputExpressions) {
        this.deviceViewOutputExpressions = deviceViewOutputExpressions;
    }

    public boolean isDeviceViewSpecialProcess() {
        return this.deviceViewSpecialProcess;
    }

    public void setDeviceViewSpecialProcess(boolean deviceViewSpecialProcess) {
        this.deviceViewSpecialProcess = deviceViewSpecialProcess;
    }

    public DeviceViewIntoPathDescriptor getDeviceViewIntoPathDescriptor() {
        return this.deviceViewIntoPathDescriptor;
    }

    public void setDeviceViewIntoPathDescriptor(DeviceViewIntoPathDescriptor deviceViewIntoPathDescriptor) {
        this.deviceViewIntoPathDescriptor = deviceViewIntoPathDescriptor;
    }

    public IntoPathDescriptor getIntoPathDescriptor() {
        return this.intoPathDescriptor;
    }

    public void setIntoPathDescriptor(IntoPathDescriptor intoPathDescriptor) {
        this.intoPathDescriptor = intoPathDescriptor;
    }

    public List<String> getTagKeys() {
        return this.tagKeys;
    }

    public void setTagKeys(List<String> tagKeys) {
        this.tagKeys = tagKeys;
    }

    public Map<List<String>, LinkedHashMap<Expression, List<Expression>>> getTagValuesToGroupedTimeseriesOperands() {
        return this.tagValuesToGroupedTimeseriesOperands;
    }

    public void setTagValuesToGroupedTimeseriesOperands(Map<List<String>, LinkedHashMap<Expression, List<Expression>>> tagValuesToGroupedTimeseriesOperands) {
        this.tagValuesToGroupedTimeseriesOperands = tagValuesToGroupedTimeseriesOperands;
    }

    public List<TDataNodeLocation> getRunningDataNodeLocations() {
        return this.runningDataNodeLocations;
    }

    public void setRunningDataNodeLocations(List<TDataNodeLocation> runningDataNodeLocations) {
        this.runningDataNodeLocations = runningDataNodeLocations;
    }

    public boolean isVirtualSource() {
        return this.isVirtualSource;
    }

    public void setVirtualSource(boolean virtualSource) {
        this.isVirtualSource = virtualSource;
    }

    public Map<NodeRef<Expression>, TSDataType> getExpressionTypes() {
        return this.expressionTypes;
    }

    public void setOrderByExpressions(Set<Expression> orderByExpressions) {
        this.orderByExpressions = orderByExpressions;
    }

    public Set<Expression> getOrderByExpressions() {
        return this.orderByExpressions;
    }

    public Map<String, Set<Expression>> getDeviceToOrderByExpressions() {
        return this.deviceToOrderByExpressions;
    }

    public void setDeviceToOrderByExpressions(Map<String, Set<Expression>> deviceToOrderByExpressions) {
        this.deviceToOrderByExpressions = deviceToOrderByExpressions;
    }

    public void setHasSortNode(boolean hasSortNode) {
        this.hasSortNode = hasSortNode;
    }

    public boolean isHasSortNode() {
        return this.hasSortNode;
    }

    public Map<String, List<SortItem>> getDeviceToSortItems() {
        return this.deviceToSortItems;
    }

    public void setDeviceToSortItems(Map<String, List<SortItem>> deviceToSortItems) {
        this.deviceToSortItems = deviceToSortItems;
    }

    public void setUseLogicalView(boolean useLogicalView) {
        this.useLogicalView = useLogicalView;
    }

    public boolean useLogicalView() {
        return this.useLogicalView;
    }

    public void setOutputExpressions(List<Pair<Expression, String>> outputExpressions) {
        this.outputExpressions = outputExpressions;
    }

    public List<Pair<Expression, String>> getOutputExpressions() {
        return this.outputExpressions;
    }

    public Ordering getTimeseriesOrderingForLastQuery() {
        return this.timeseriesOrderingForLastQuery;
    }

    public void setTimeseriesOrderingForLastQuery(Ordering timeseriesOrderingForLastQuery) {
        this.timeseriesOrderingForLastQuery = timeseriesOrderingForLastQuery;
    }

    public Set<Expression> getLastQueryBaseExpressions() {
        return this.lastQueryBaseExpressions;
    }

    public void setLastQueryBaseExpressions(Set<Expression> lastQueryBaseExpressions) {
        this.lastQueryBaseExpressions = lastQueryBaseExpressions;
    }

    public Map<Expression, List<Expression>> getLastQueryNonWritableViewSourceExpressionMap() {
        return this.lastQueryNonWritableViewSourceExpressionMap;
    }

    public void setLastQueryNonWritableViewSourceExpressionMap(Map<Expression, List<Expression>> lastQueryNonWritableViewSourceExpressionMap) {
        this.lastQueryNonWritableViewSourceExpressionMap = lastQueryNonWritableViewSourceExpressionMap;
    }

    public Map<String, String> getOutputDeviceToQueriedDevicesMap() {
        return this.outputDeviceToQueriedDevicesMap;
    }

    public void setOutputDeviceToQueriedDevicesMap(Map<String, String> outputDeviceToQueriedDevicesMap) {
        this.outputDeviceToQueriedDevicesMap = outputDeviceToQueriedDevicesMap;
    }

    public Map<String, Set<Expression>> getDeviceToOutputExpressions() {
        return this.deviceToOutputExpressions;
    }

    public void setDeviceToOutputExpressions(Map<String, Set<Expression>> deviceToOutputExpressions) {
        this.deviceToOutputExpressions = deviceToOutputExpressions;
    }

    public boolean isLastLevelUseWildcard() {
        return this.lastLevelUseWildcard;
    }

    public void setLastLevelUseWildcard(boolean lastLevelUseWildcard) {
        this.lastLevelUseWildcard = lastLevelUseWildcard;
    }

    public boolean isUseTopKNode() {
        return this.useTopKNode;
    }

    public void setUseTopKNode() {
        this.useTopKNode = true;
    }

    public void setDeviceList(List<PartialPath> deviceList) {
        this.deviceList = deviceList;
    }

    public List<PartialPath> getDeviceList() {
        return this.deviceList;
    }

    public boolean isAllDevicesInOneTemplate() {
        return this.deviceTemplate != null;
    }

    public Template getDeviceTemplate() {
        return this.deviceTemplate;
    }

    public void setDeviceTemplate(Template template) {
        this.deviceTemplate = template;
    }

    public boolean isOnlyQueryTemplateMeasurements() {
        return this.onlyQueryTemplateMeasurements;
    }

    public void setOnlyQueryTemplateMeasurements(boolean onlyQueryTemplateMeasurements) {
        this.onlyQueryTemplateMeasurements = onlyQueryTemplateMeasurements;
    }

    public List<String> getMeasurementList() {
        return this.measurementList;
    }

    public void setMeasurementList(List<String> measurementList) {
        this.measurementList = measurementList;
    }

    public List<IMeasurementSchema> getMeasurementSchemaList() {
        return this.measurementSchemaList;
    }

    public void setMeasurementSchemaList(List<IMeasurementSchema> measurementSchemaList) {
        this.measurementSchemaList = measurementSchemaList;
    }

    public void setTemplateWildCardQuery() {
        this.templateWildCardQuery = true;
    }

    public boolean isTemplateWildCardQuery() {
        return this.templateWildCardQuery;
    }

    public void setFromWhere(FilterNode filterNode) {
        this.fromWhereFilterNodes.add(NodeRef.of(filterNode));
    }

    public boolean fromWhere(FilterNode filterNode) {
        return this.fromWhereFilterNodes.contains(NodeRef.of(filterNode));
    }
}

