/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.aggregation.Accumulator;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.utils.BitMap;

public class SumAccumulator
implements Accumulator {
    private final TSDataType seriesDataType;
    private double sumValue = 0.0;
    private boolean initResult = false;

    public SumAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
    }

    @Override
    public void addInput(Column[] columns, BitMap bitMap) {
        switch (this.seriesDataType) {
            case INT32: {
                this.addIntInput(columns, bitMap);
                return;
            }
            case INT64: {
                this.addLongInput(columns, bitMap);
                return;
            }
            case FLOAT: {
                this.addFloatInput(columns, bitMap);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(columns, bitMap);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Sum should be 1");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.initResult = true;
        this.sumValue += partialResult[0].getDouble(0);
    }

    @Override
    public void removeIntermediate(Column[] input) {
        Preconditions.checkArgument((input.length == 1 ? 1 : 0) != 0, (Object)"input of Sum should be 1");
        if (input[0].isNull(0)) {
            return;
        }
        this.sumValue -= input[0].getDouble(0);
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.initResult = true;
        this.sumValue = statistics instanceof IntegerStatistics ? (this.sumValue += (double)statistics.getSumLongValue()) : (this.sumValue += statistics.getSumDoubleValue());
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        this.sumValue = finalResult.getDouble(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 1 ? 1 : 0) != 0, (Object)"partialResult of Sum should be 1");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
        } else {
            columnBuilders[0].writeDouble(this.sumValue);
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue);
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.sumValue = 0.0;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.DOUBLE};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.DOUBLE;
    }

    private void addIntInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column[1].getInt(i);
        }
    }

    private void addLongInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column[1].getLong(i);
        }
    }

    private void addFloatInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += (double)column[1].getFloat(i);
        }
    }

    private void addDoubleInput(Column[] column, BitMap bitMap) {
        int count = column[0].getPositionCount();
        for (int i = 0; i < count; ++i) {
            if (bitMap != null && !bitMap.isMarked(i) || column[1].isNull(i)) continue;
            this.initResult = true;
            this.sumValue += column[1].getDouble(i);
        }
    }
}

