/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.v1.impl;

import java.time.ZoneId;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.handler.AuthorizationHandler;
import org.apache.iotdb.db.protocol.rest.model.ExecutionStatus;
import org.apache.iotdb.db.protocol.rest.utils.InsertTabletSortDataUtils;
import org.apache.iotdb.db.protocol.rest.v1.RestApiService;
import org.apache.iotdb.db.protocol.rest.v1.handler.ExceptionHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.ExecuteStatementHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.QueryDataSetHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.RequestValidationHandler;
import org.apache.iotdb.db.protocol.rest.v1.handler.StatementConstructionHandler;
import org.apache.iotdb.db.protocol.rest.v1.model.InsertTabletRequest;
import org.apache.iotdb.db.protocol.rest.v1.model.SQL;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.db.queryengine.plan.Coordinator;
import org.apache.iotdb.db.queryengine.plan.analyze.ClusterPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ClusterSchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.analyze.schema.ISchemaFetcher;
import org.apache.iotdb.db.queryengine.plan.execution.ExecutionResult;
import org.apache.iotdb.db.queryengine.plan.execution.IQueryExecution;
import org.apache.iotdb.db.queryengine.plan.parser.StatementGenerator;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.utils.SetThreadName;
import org.apache.iotdb.rpc.TSStatusCode;

public class RestApiServiceImpl
extends RestApiService {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final Coordinator COORDINATOR = Coordinator.getInstance();
    private static final SessionManager SESSION_MANAGER = SessionManager.getInstance();
    private final IPartitionFetcher partitionFetcher = ClusterPartitionFetcher.getInstance();
    private final ISchemaFetcher schemaFetcher = ClusterSchemaFetcher.getInstance();
    private final AuthorizationHandler authorizationHandler = new AuthorizationHandler();
    private final Integer defaultQueryRowLimit = IoTDBRestServiceDescriptor.getInstance().getConfig().getRestQueryDefaultRowSizeLimit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeNonQueryStatement(SQL sql, SecurityContext securityContext) {
        Response response;
        block12: {
            Long queryId = null;
            try {
                RequestValidationHandler.validateSQL(sql);
                Statement statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                if (!ExecuteStatementHandler.validateStatement(statement)) {
                    Response response2 = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response2;
                }
                Response response3 = this.authorizationHandler.checkAuthority(securityContext, statement);
                if (response3 != null) {
                    Response response4 = response3;
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response4;
                }
                queryId = SESSION_MANAGER.requestQueryId();
                ExecutionResult result = COORDINATOR.executeForTreeModel(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
                response = Response.ok().entity((Object)(result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() ? new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage()))).build();
                if (queryId == null) break block12;
            }
            catch (Exception e) {
                Response response5 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                return response5;
            }
            finally {
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
            }
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response executeQueryStatement(SQL sql, SecurityContext securityContext) {
        ExecutionResult result;
        Statement statement;
        Long queryId;
        block20: {
            block19: {
                block18: {
                    queryId = null;
                    RequestValidationHandler.validateSQL(sql);
                    statement = StatementGenerator.createStatement(sql.getSql(), ZoneId.systemDefault());
                    if (!ExecuteStatementHandler.validateStatement(statement)) break block18;
                    Response response = Response.ok().entity((Object)new ExecutionStatus().code(Integer.valueOf(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode())).message(TSStatusCode.EXECUTE_STATEMENT_ERROR.name())).build();
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response;
                }
                Response response = this.authorizationHandler.checkAuthority(securityContext, statement);
                if (response == null) break block19;
                Response response2 = response;
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
                return response2;
            }
            queryId = SESSION_MANAGER.requestQueryId();
            result = COORDINATOR.executeForTreeModel(statement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), sql.getSql(), this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
            if (result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode()) break block20;
            Response response = Response.ok().entity((Object)new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage())).build();
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        IQueryExecution queryExecution = COORDINATOR.getQueryExecution(queryId);
        SetThreadName threadName = new SetThreadName(result.queryId.getId());
        try {
            Response response = QueryDataSetHandler.fillQueryDataSet(queryExecution, statement, sql.getRowLimit() == null ? this.defaultQueryRowLimit : sql.getRowLimit());
            threadName.close();
            if (queryId != null) {
                COORDINATOR.cleanupQueryExecution(queryId);
            }
            return response;
        }
        catch (Throwable throwable) {
            try {
                try {
                    try {
                        threadName.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Response response = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                    return response;
                }
            }
            catch (Throwable throwable3) {
                throw throwable3;
            }
            finally {
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response insertTablet(InsertTabletRequest insertTabletRequest, SecurityContext securityContext) {
        Response response;
        block10: {
            Long queryId = null;
            try {
                InsertTabletStatement insertTabletStatement;
                Response response2;
                RequestValidationHandler.validateInsertTabletRequest(insertTabletRequest);
                if (!InsertTabletSortDataUtils.checkSorted(insertTabletRequest.getTimestamps())) {
                    int[] index = InsertTabletSortDataUtils.sortTimeStampList(insertTabletRequest.getTimestamps());
                    insertTabletRequest.getTimestamps().sort(Long::compareTo);
                    insertTabletRequest.setValues(InsertTabletSortDataUtils.sortList(insertTabletRequest.getValues(), index, insertTabletRequest.getDataTypes().size()));
                }
                if ((response2 = this.authorizationHandler.checkAuthority(securityContext, insertTabletStatement = StatementConstructionHandler.constructInsertTabletStatement(insertTabletRequest))) != null) {
                    Response response3 = response2;
                    if (queryId != null) {
                        COORDINATOR.cleanupQueryExecution(queryId);
                    }
                    return response3;
                }
                queryId = SESSION_MANAGER.requestQueryId();
                ExecutionResult result = COORDINATOR.executeForTreeModel(insertTabletStatement, queryId, SESSION_MANAGER.getSessionInfo(SESSION_MANAGER.getCurrSession()), "", this.partitionFetcher, this.schemaFetcher, config.getQueryTimeoutThreshold());
                response = Response.ok().entity((Object)(result.status.code == TSStatusCode.SUCCESS_STATUS.getStatusCode() || result.status.code == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() ? new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(TSStatusCode.SUCCESS_STATUS.getStatusCode())).message(TSStatusCode.SUCCESS_STATUS.name()) : new org.apache.iotdb.db.protocol.rest.v1.model.ExecutionStatus().code(Integer.valueOf(result.status.getCode())).message(result.status.getMessage()))).build();
                if (queryId == null) break block10;
            }
            catch (Exception e) {
                Response response4 = Response.ok().entity((Object)ExceptionHandler.tryCatchException(e)).build();
                return response4;
            }
            finally {
                if (queryId != null) {
                    COORDINATOR.cleanupQueryExecution(queryId);
                }
            }
            COORDINATOR.cleanupQueryExecution(queryId);
        }
        return response;
    }
}

