/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest.utils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.rpc.IoTDBConnectionException;
import org.apache.iotdb.rpc.NoValidValueException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class InsertRowDataUtils {
    private static final String ALL_INSERT_DATA_IS_NULL = "All inserted data is null.";

    public static void filterNullValueAndMeasurement(List<String> deviceIds, List<Long> times, List<List<String>> measurementsList, List<List<Object>> valuesList, List<List<TSDataType>> typesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            List<TSDataType> types;
            List<Object> values = valuesList.get(i);
            List<String> measurements = measurementsList.get(i);
            boolean isAllValuesNull = InsertRowDataUtils.getValuesIsEmpty(measurements, types = typesList.get(i), values);
            if (!isAllValuesNull) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            deviceIds.remove(i);
            times.remove(i);
            typesList.remove(i);
        }
        if (valuesList.isEmpty()) {
            throw new NoValidValueException(ALL_INSERT_DATA_IS_NULL);
        }
    }

    private static boolean getValuesIsEmpty(List<String> measurementsList, List<TSDataType> types, List<Object> valuesList) {
        for (int i = valuesList.size() - 1; i >= 0; --i) {
            if (valuesList.get(i) != null) continue;
            valuesList.remove(i);
            measurementsList.remove(i);
            types.remove(i);
        }
        return valuesList.isEmpty();
    }

    public static List<Object> reGenValues(List<TSDataType> types, List<Object> values, Map<Integer, Object> mismatchedInfo) throws IoTDBConnectionException {
        block8: for (int i = 0; i < values.size(); ++i) {
            if (values.get(i) == null) continue;
            Object val = values.get(i);
            switch (types.get(i)) {
                case BOOLEAN: {
                    if (val instanceof Boolean) continue block8;
                    mismatchedInfo.put(i, val);
                    continue block8;
                }
                case INT32: {
                    if (val instanceof Number) {
                        values.set(i, ((Number)val).intValue());
                        continue block8;
                    }
                    mismatchedInfo.put(i, val);
                    continue block8;
                }
                case INT64: {
                    if (val instanceof Number) {
                        values.set(i, ((Number)val).longValue());
                        continue block8;
                    }
                    mismatchedInfo.put(i, val);
                    continue block8;
                }
                case FLOAT: {
                    if (val instanceof Number) {
                        values.set(i, Float.valueOf(((Number)val).floatValue()));
                        continue block8;
                    }
                    mismatchedInfo.put(i, val);
                    continue block8;
                }
                case DOUBLE: {
                    if (val instanceof Number) {
                        values.set(i, ((Number)val).doubleValue());
                        continue block8;
                    }
                    mismatchedInfo.put(i, val);
                    continue block8;
                }
                case TEXT: {
                    values.set(i, new Binary(val.toString().getBytes(StandardCharsets.UTF_8)));
                    continue block8;
                }
                default: {
                    throw new IoTDBConnectionException("Unsupported data type:" + types.get(i));
                }
            }
        }
        return values;
    }
}

