/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task.connection;

import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.progress.PipeEventCommitManager;
import org.apache.iotdb.commons.pipe.task.connection.BoundedBlockingPendingQueue;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.pipe.task.connection.EnrichedDeque;
import org.apache.iotdb.pipe.api.collector.EventCollector;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeEventCollector
implements EventCollector,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeEventCollector.class);
    private final BoundedBlockingPendingQueue<Event> pendingQueue;
    private final EnrichedDeque<Event> bufferQueue;
    private final long creationTime;
    private final int regionId;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private final AtomicInteger collectInvocationCount = new AtomicInteger(0);

    public PipeEventCollector(BoundedBlockingPendingQueue<Event> pendingQueue, long creationTime, int regionId) {
        this.pendingQueue = pendingQueue;
        this.creationTime = creationTime;
        this.regionId = regionId;
        this.bufferQueue = new EnrichedDeque(new LinkedList());
    }

    public void collect(Event event) {
        try {
            if (event instanceof PipeInsertNodeTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeInsertNodeTabletInsertionEvent)event);
            } else if (event instanceof PipeRawTabletInsertionEvent) {
                this.parseAndCollectEvent((PipeRawTabletInsertionEvent)event);
            } else if (event instanceof PipeTsFileInsertionEvent) {
                this.parseAndCollectEvent((PipeTsFileInsertionEvent)event);
            } else {
                this.collectEvent(event);
            }
        }
        catch (PipeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PipeException("Error occurred when collecting events from processor.", (Throwable)e);
        }
    }

    private void parseAndCollectEvent(PipeInsertNodeTabletInsertionEvent sourceEvent) {
        if (sourceEvent.shouldParseTimeOrPattern()) {
            for (PipeRawTabletInsertionEvent parsedEvent : sourceEvent.toRawTabletInsertionEvents()) {
                this.collectEvent((Event)parsedEvent);
            }
        } else {
            this.collectEvent((Event)sourceEvent);
        }
    }

    private void parseAndCollectEvent(PipeRawTabletInsertionEvent sourceEvent) {
        if (sourceEvent.shouldParseTimeOrPattern()) {
            PipeRawTabletInsertionEvent parsedEvent = sourceEvent.parseEventWithPatternOrTime();
            if (!parsedEvent.hasNoNeedParsingAndIsEmpty()) {
                this.collectEvent((Event)parsedEvent);
            }
        } else {
            this.collectEvent((Event)sourceEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAndCollectEvent(PipeTsFileInsertionEvent sourceEvent) throws Exception {
        if (!sourceEvent.waitForTsFileClose()) {
            LOGGER.warn("Pipe skipping temporary TsFile which shouldn't be transferred: {}", (Object)sourceEvent.getTsFile());
            return;
        }
        if (!sourceEvent.shouldParseTimeOrPattern()) {
            this.collectEvent((Event)sourceEvent);
            return;
        }
        try {
            for (TabletInsertionEvent parsedEvent : sourceEvent.toTabletInsertionEvents()) {
                this.collectEvent((Event)parsedEvent);
            }
        }
        finally {
            sourceEvent.close();
        }
    }

    private synchronized void collectEvent(Event event) {
        this.collectInvocationCount.incrementAndGet();
        if (event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).increaseReferenceCount(PipeEventCollector.class.getName());
            PipeEventCommitManager.getInstance().enrichWithCommitterKeyAndCommitId((EnrichedEvent)event, this.creationTime, this.regionId);
        }
        if (event instanceof PipeHeartbeatEvent) {
            ((PipeHeartbeatEvent)event).recordBufferQueueSize(this.bufferQueue);
            ((PipeHeartbeatEvent)event).recordConnectorQueueSize(this.pendingQueue);
        }
        while (!this.isClosed.get() && !this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            if (event instanceof PipeHeartbeatEvent && this.bufferQueue.peekLast() instanceof PipeHeartbeatEvent) {
                ((EnrichedEvent)event).decreaseReferenceCount(PipeEventCollector.class.getName(), false);
            } else {
                this.bufferQueue.offer(event);
            }
            return;
        }
        if (!this.pendingQueue.waitedOffer(event)) {
            this.bufferQueue.offer(event);
        }
    }

    public void resetCollectInvocationCount() {
        this.collectInvocationCount.set(0);
    }

    public boolean hasNoCollectInvocationAfterReset() {
        return this.collectInvocationCount.get() == 0;
    }

    public boolean isBufferQueueEmpty() {
        return this.bufferQueue.isEmpty();
    }

    public synchronized boolean tryCollectBufferedEvents() {
        while (!this.isClosed.get() && !this.bufferQueue.isEmpty()) {
            Event bufferedEvent = this.bufferQueue.peek();
            if (this.pendingQueue.waitedOffer(bufferedEvent)) {
                this.bufferQueue.poll();
                continue;
            }
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.doClose();
    }

    private synchronized void doClose() {
        this.bufferQueue.forEach(event -> {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(PipeEventCollector.class.getName());
            }
        });
        this.bufferQueue.clear();
    }

    public int getTabletInsertionEventCount() {
        return this.bufferQueue.getTabletInsertionEventCount();
    }

    public int getTsFileInsertionEventCount() {
        return this.bufferQueue.getTsFileInsertionEventCount();
    }

    public int getPipeHeartbeatEventCount() {
        return this.bufferQueue.getPipeHeartbeatEventCount();
    }
}

