/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.task;

import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.stage.PipeTaskStage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeTask
implements PipeTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeTask.class);
    private final String pipeName;
    private final int regionId;
    private final PipeTaskStage extractorStage;
    private final PipeTaskStage processorStage;
    private final PipeTaskStage connectorStage;

    public PipeDataNodeTask(String pipeName, int regionId, PipeTaskStage extractorStage, PipeTaskStage processorStage, PipeTaskStage connectorStage) {
        this.pipeName = pipeName;
        this.regionId = regionId;
        this.extractorStage = extractorStage;
        this.processorStage = processorStage;
        this.connectorStage = connectorStage;
    }

    public void create() {
        long startTime = System.currentTimeMillis();
        this.extractorStage.create();
        this.processorStage.create();
        this.connectorStage.create();
        LOGGER.info("Create pipe DN task {} successfully within {} ms", (Object)this, (Object)(System.currentTimeMillis() - startTime));
    }

    public void drop() {
        long startTime = System.currentTimeMillis();
        this.extractorStage.drop();
        this.processorStage.drop();
        this.connectorStage.drop();
        LOGGER.info("Drop pipe DN task {} successfully within {} ms", (Object)this, (Object)(System.currentTimeMillis() - startTime));
    }

    public void start() {
        long startTime = System.currentTimeMillis();
        this.extractorStage.start();
        this.processorStage.start();
        this.connectorStage.start();
        LOGGER.info("Start pipe DN task {} successfully within {} ms", (Object)this, (Object)(System.currentTimeMillis() - startTime));
    }

    public void stop() {
        long startTime = System.currentTimeMillis();
        this.extractorStage.stop();
        this.processorStage.stop();
        this.connectorStage.stop();
        LOGGER.info("Stop pipe DN task {} successfully within {} ms", (Object)this, (Object)(System.currentTimeMillis() - startTime));
    }

    public int getRegionId() {
        return this.regionId;
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public String toString() {
        return this.pipeName + "@" + this.regionId;
    }
}

