/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.visitor;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.queryengine.plan.statement.Statement;
import org.apache.iotdb.db.queryengine.plan.statement.StatementNode;
import org.apache.iotdb.db.queryengine.plan.statement.StatementVisitor;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertBaseStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.template.BatchActivateTemplateStatement;
import org.apache.iotdb.db.queryengine.plan.statement.metadata.view.CreateLogicalViewStatement;
import org.apache.iotdb.rpc.TSStatusCode;

public class PipeStatementTSStatusVisitor
extends StatementVisitor<TSStatus, TSStatus> {
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();

    @Override
    public TSStatus visitNode(StatementNode node, TSStatus context) {
        return context;
    }

    @Override
    public TSStatus visitInsertTablet(InsertTabletStatement insertTabletStatement, TSStatus context) {
        return this.visitInsertBase(insertTabletStatement, context);
    }

    @Override
    public TSStatus visitInsertRow(InsertRowStatement insertRowStatement, TSStatus context) {
        return this.visitInsertBase(insertRowStatement, context);
    }

    @Override
    public TSStatus visitInsertRows(InsertRowsStatement insertRowsStatement, TSStatus context) {
        return this.visitInsertBase(insertRowsStatement, context);
    }

    @Override
    public TSStatus visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, TSStatus context) {
        return this.visitInsertBase(insertMultiTabletsStatement, context);
    }

    private TSStatus visitInsertBase(InsertBaseStatement insertBaseStatement, TSStatus context) {
        if (context.getCode() == TSStatusCode.OUT_OF_TTL.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            if (context.getMessage().contains("registered type") && this.config.isEnablePartialInsert()) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(insertBaseStatement, context);
    }

    @Override
    public TSStatus visitCreateTimeseries(CreateTimeSeriesStatement statement, TSStatus context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    @Override
    public TSStatus visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement statement, TSStatus context) {
        return this.visitGeneralCreateTimeSeries(statement, context);
    }

    private TSStatus visitGeneralCreateTimeSeries(Statement statement, TSStatus context) {
        if (context.getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode() || context.getCode() == TSStatusCode.ALIAS_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.PATH_ALREADY_EXIST.getStatusCode() || context.getCode() == TSStatusCode.ALIGNED_TIMESERIES_ERROR.getStatusCode() || context.getCode() == TSStatusCode.SCHEMA_QUOTA_EXCEEDED.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(statement, context);
    }

    @Override
    public TSStatus visitCreateMultiTimeseries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, TSStatus context) {
        return this.visitGeneralCreateMultiTimeseries(createMultiTimeSeriesStatement, context);
    }

    @Override
    public TSStatus visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, TSStatus context) {
        return this.visitGeneralCreateMultiTimeseries(internalCreateTimeSeriesStatement, context);
    }

    @Override
    public TSStatus visitInternalCreateMultiTimeSeries(InternalCreateMultiTimeSeriesStatement internalCreateMultiTimeSeriesStatement, TSStatus context) {
        return this.visitGeneralCreateMultiTimeseries(internalCreateMultiTimeSeriesStatement, context);
    }

    private TSStatus visitGeneralCreateMultiTimeseries(Statement statement, TSStatus context) {
        if (context.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            for (TSStatus status : context.getSubStatus()) {
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode() || status.getCode() == TSStatusCode.ALIAS_ALREADY_EXIST.getStatusCode()) continue;
                if (status.getCode() == TSStatusCode.ALIGNED_TIMESERIES_ERROR.getStatusCode()) {
                    return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
                }
                return (TSStatus)this.visitStatement(statement, context);
            }
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.SCHEMA_QUOTA_EXCEEDED.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(statement, context);
    }

    @Override
    public TSStatus visitAlterTimeseries(AlterTimeSeriesStatement alterTimeSeriesStatement, TSStatus context) {
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            if (context.getMessage().contains("already")) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
            if (context.getMessage().contains("does not")) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
        } else if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(alterTimeSeriesStatement, context);
    }

    @Override
    public TSStatus visitCreateLogicalView(CreateLogicalViewStatement createLogicalViewStatement, TSStatus context) {
        if (context.getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.MULTIPLE_ERROR.getStatusCode()) {
            for (TSStatus status : context.getSubStatus()) {
                if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || status.getCode() == TSStatusCode.TIMESERIES_ALREADY_EXIST.getStatusCode()) continue;
                return (TSStatus)this.visitStatement(createLogicalViewStatement, context);
            }
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateLogicalView(createLogicalViewStatement, context);
    }

    @Override
    public TSStatus visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, TSStatus context) {
        return this.visitGeneralActivateTemplate(activateTemplateStatement, context);
    }

    @Override
    public TSStatus visitBatchActivateTemplate(BatchActivateTemplateStatement batchActivateTemplateStatement, TSStatus context) {
        return this.visitGeneralActivateTemplate(batchActivateTemplateStatement, context);
    }

    private TSStatus visitGeneralActivateTemplate(Statement activateTemplateStatement, TSStatus context) {
        if (context.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)this.visitStatement(activateTemplateStatement, context);
    }
}

