/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.task;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.consensus.ConsensusGroupId;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MetaProgressIndex;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.pipe.agent.task.PipeTaskAgent;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.task.PipeTask;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.extractor.dataregion.DataRegionListeningFilter;
import org.apache.iotdb.db.pipe.extractor.dataregion.IoTDBDataRegionExtractor;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.pipe.extractor.schemaregion.SchemaRegionListeningFilter;
import org.apache.iotdb.db.pipe.metric.PipeExtractorMetrics;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.task.PipeDataNodeTask;
import org.apache.iotdb.db.pipe.task.builder.PipeDataNodeBuilder;
import org.apache.iotdb.db.pipe.task.builder.PipeDataNodeTaskBuilder;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.pipe.PipeOperateSchemaQueueNode;
import org.apache.iotdb.db.schemaengine.SchemaEngine;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.mpp.rpc.thrift.TDataNodeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatReq;
import org.apache.iotdb.mpp.rpc.thrift.TPipeHeartbeatResp;
import org.apache.iotdb.mpp.rpc.thrift.TPushPipeMetaRespExceptionMessage;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeDataNodeTaskAgent
extends PipeTaskAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipeDataNodeTaskAgent.class);
    protected static final IoTDBConfig CONFIG = IoTDBDescriptor.getInstance().getConfig();

    protected boolean isShutdown() {
        return PipeAgent.runtime().isShutdown();
    }

    protected Map<Integer, PipeTask> buildPipeTasks(PipeMeta pipeMetaFromConfigNode) throws IllegalPathException {
        return new PipeDataNodeBuilder(pipeMetaFromConfigNode).build();
    }

    protected void createPipeTask(int consensusGroupId, PipeStaticMeta pipeStaticMeta, PipeTaskMeta pipeTaskMeta) throws IllegalPathException {
        if (pipeTaskMeta.getLeaderNodeId() == CONFIG.getDataNodeId()) {
            boolean needConstructSchemaRegionTask;
            PipeParameters extractorParameters = pipeStaticMeta.getExtractorParameters();
            boolean needConstructDataRegionTask = StorageEngine.getInstance().getAllDataRegionIds().contains(new DataRegionId(consensusGroupId)) && DataRegionListeningFilter.shouldDataRegionBeListened(extractorParameters);
            boolean bl = needConstructSchemaRegionTask = SchemaEngine.getInstance().getAllSchemaRegionIds().contains(new SchemaRegionId(consensusGroupId)) && !SchemaRegionListeningFilter.parseListeningPlanTypeSet(extractorParameters).isEmpty();
            if (needConstructDataRegionTask || needConstructSchemaRegionTask) {
                PipeDataNodeTask pipeTask = new PipeDataNodeTaskBuilder(pipeStaticMeta, consensusGroupId, pipeTaskMeta).build();
                pipeTask.create();
                this.pipeTaskManager.addPipeTask(pipeStaticMeta, consensusGroupId, (PipeTask)pipeTask);
            }
        }
        this.pipeMetaKeeper.getPipeMeta(pipeStaticMeta.getPipeName()).getRuntimeMeta().getConsensusGroupId2TaskMetaMap().put(consensusGroupId, pipeTaskMeta);
    }

    public List<TPushPipeMetaRespExceptionMessage> handlePipeMetaChangesInternal(List<PipeMeta> pipeMetaListFromCoordinator) {
        if (this.isShutdown()) {
            return Collections.emptyList();
        }
        List exceptionMessages = super.handlePipeMetaChangesInternal(pipeMetaListFromCoordinator);
        try {
            Set<Integer> validSchemaRegionIds = this.clearSchemaRegionListeningQueueIfNecessary(pipeMetaListFromCoordinator);
            this.closeSchemaRegionListeningQueueIfNecessary(validSchemaRegionIds, exceptionMessages);
        }
        catch (Exception e) {
            throw new PipeException("Failed to clear/close schema region listening queue.", (Throwable)e);
        }
        return exceptionMessages;
    }

    private Set<Integer> clearSchemaRegionListeningQueueIfNecessary(List<PipeMeta> pipeMetaListFromCoordinator) throws IllegalPathException {
        HashMap<Integer, Long> schemaRegionId2ListeningQueueNewFirstIndex = new HashMap<Integer, Long>();
        for (PipeMeta pipeMetaFromCoordinator : pipeMetaListFromCoordinator) {
            if (SchemaRegionListeningFilter.parseListeningPlanTypeSet(pipeMetaFromCoordinator.getStaticMeta().getExtractorParameters()).isEmpty()) continue;
            ConcurrentMap groupId2TaskMetaMap = pipeMetaFromCoordinator.getRuntimeMeta().getConsensusGroupId2TaskMetaMap();
            for (SchemaRegionId regionId : SchemaEngine.getInstance().getAllSchemaRegionIds()) {
                int id = regionId.getId();
                PipeTaskMeta pipeTaskMeta = (PipeTaskMeta)groupId2TaskMetaMap.get(id);
                if (pipeTaskMeta == null) continue;
                ProgressIndex progressIndex = pipeTaskMeta.getProgressIndex();
                if (progressIndex instanceof MetaProgressIndex) {
                    if (((MetaProgressIndex)progressIndex).getIndex() + 1L >= schemaRegionId2ListeningQueueNewFirstIndex.getOrDefault(id, Long.MAX_VALUE)) continue;
                    schemaRegionId2ListeningQueueNewFirstIndex.put(id, ((MetaProgressIndex)progressIndex).getIndex() + 1L);
                    continue;
                }
                schemaRegionId2ListeningQueueNewFirstIndex.put(id, 0L);
            }
        }
        schemaRegionId2ListeningQueueNewFirstIndex.forEach((schemaRegionId, listeningQueueNewFirstIndex) -> PipeAgent.runtime().schemaListener(new SchemaRegionId(schemaRegionId.intValue())).removeBefore((long)listeningQueueNewFirstIndex));
        return schemaRegionId2ListeningQueueNewFirstIndex.keySet();
    }

    private void closeSchemaRegionListeningQueueIfNecessary(Set<Integer> validSchemaRegionIds, List<TPushPipeMetaRespExceptionMessage> exceptionMessages) {
        if (!exceptionMessages.isEmpty()) {
            return;
        }
        PipeAgent.runtime().listeningSchemaRegionIds().forEach(schemaRegionId -> {
            if (!validSchemaRegionIds.contains(schemaRegionId.getId()) && PipeAgent.runtime().isSchemaLeaderReady((SchemaRegionId)schemaRegionId)) {
                try {
                    SchemaRegionConsensusImpl.getInstance().write((ConsensusGroupId)schemaRegionId, (IConsensusRequest)new PipeOperateSchemaQueueNode(new PlanNodeId(""), false));
                }
                catch (ConsensusException e) {
                    throw new PipeException("Failed to close listening queue for SchemaRegion " + schemaRegionId, (Throwable)e);
                }
            }
        });
    }

    public void stopAllPipesWithCriticalException() {
        super.stopAllPipesWithCriticalException(IoTDBDescriptor.getInstance().getConfig().getDataNodeId());
    }

    public void collectPipeMetaList(TDataNodeHeartbeatResp resp) throws TException {
        if (!this.tryReadLockWithTimeOut(10L)) {
            return;
        }
        try {
            this.collectPipeMetaListInternal(resp);
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void collectPipeMetaListInternal(TDataNodeHeartbeatResp resp) throws TException {
        if (PipeAgent.runtime().isShutdown()) {
            return;
        }
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        try {
            Optional<Logger> logger = PipeResourceManager.log().schedule(PipeDataNodeTaskAgent.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), this.pipeMetaKeeper.getPipeMetaCount());
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                logger.ifPresent(l -> l.info("Reporting pipe meta: {}", (Object)pipeMeta.coreReportMessage()));
            }
            LOGGER.info("Reported {} pipe metas.", (Object)pipeMetaBinaryList.size());
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
    }

    protected void collectPipeMetaListInternal(TPipeHeartbeatReq req, TPipeHeartbeatResp resp) throws TException {
        if (PipeAgent.runtime().isShutdown()) {
            return;
        }
        LOGGER.info("Received pipe heartbeat request {} from config node.", (Object)req.heartbeatId);
        ArrayList<ByteBuffer> pipeMetaBinaryList = new ArrayList<ByteBuffer>();
        try {
            Optional<Logger> logger = PipeResourceManager.log().schedule(PipeDataNodeTaskAgent.class, PipeConfig.getInstance().getPipeMetaReportMaxLogNumPerRound(), PipeConfig.getInstance().getPipeMetaReportMaxLogIntervalRounds(), this.pipeMetaKeeper.getPipeMetaCount());
            for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
                pipeMetaBinaryList.add(pipeMeta.serialize());
                logger.ifPresent(l -> l.info("Reporting pipe meta: {}", (Object)pipeMeta.coreReportMessage()));
            }
            LOGGER.info("Reported {} pipe metas.", (Object)pipeMetaBinaryList.size());
        }
        catch (IOException e) {
            throw new TException((Throwable)e);
        }
        resp.setPipeMetaList(pipeMetaBinaryList);
        PipeInsertionDataNodeListener.getInstance().listenToHeartbeat(true);
    }

    public void restartAllStuckPipes() {
        if (!this.tryWriteLockWithTimeOut(5L)) {
            return;
        }
        try {
            this.restartAllStuckPipesInternal();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void restartAllStuckPipesInternal() {
        Map<String, IoTDBDataRegionExtractor> taskId2ExtractorMap = PipeExtractorMetrics.getInstance().getExtractorMap();
        HashSet<PipeMeta> stuckPipes = new HashSet<PipeMeta>();
        for (PipeMeta pipeMeta : this.pipeMetaKeeper.getPipeMetaList()) {
            String pipeName = pipeMeta.getStaticMeta().getPipeName();
            List extractors = taskId2ExtractorMap.values().stream().filter(e -> e.getPipeName().equals(pipeName)).collect(Collectors.toList());
            if (extractors.isEmpty() || !((IoTDBDataRegionExtractor)((Object)extractors.get(0))).isStreamMode() || extractors.stream().noneMatch(IoTDBDataRegionExtractor::hasConsumedAllHistoricalTsFiles) || !this.mayMemTablePinnedCountReachDangerousThreshold() && !this.mayWalSizeReachThrottleThreshold()) continue;
            LOGGER.warn("Pipe {} may be stuck.", (Object)pipeMeta.getStaticMeta());
            stuckPipes.add(pipeMeta);
        }
        stuckPipes.parallelStream().forEach(this::restartStuckPipe);
    }

    private boolean mayMemTablePinnedCountReachDangerousThreshold() {
        return PipeResourceManager.wal().getPinnedWalCount() >= 10 * PipeConfig.getInstance().getPipeMaxAllowedPinnedMemTableCount();
    }

    private boolean mayWalSizeReachThrottleThreshold() {
        return 3L * WALManager.getInstance().getTotalDiskUsage() > 2L * IoTDBDescriptor.getInstance().getConfig().getThrottleThreshold();
    }

    private void restartStuckPipe(PipeMeta pipeMeta) {
        LOGGER.warn("Pipe {} will be restarted because of stuck.", (Object)pipeMeta.getStaticMeta());
        long startTime = System.currentTimeMillis();
        this.changePipeStatusBeforeRestart(pipeMeta.getStaticMeta().getPipeName());
        this.handleSinglePipeMetaChangesInternal(pipeMeta);
        LOGGER.warn("Pipe {} was restarted because of stuck, time cost: {} ms.", (Object)pipeMeta.getStaticMeta(), (Object)(System.currentTimeMillis() - startTime));
    }

    private void changePipeStatusBeforeRestart(String pipeName) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        Map pipeTasks = this.pipeTaskManager.getPipeTasks(pipeMeta.getStaticMeta());
        HashSet taskRegionIds = new HashSet(pipeTasks.keySet());
        Set dataRegionIds = StorageEngine.getInstance().getAllDataRegionIds().stream().map(ConsensusGroupId::getId).collect(Collectors.toSet());
        Set dataRegionPipeTasks = taskRegionIds.stream().filter(dataRegionIds::contains).map(regionId -> this.pipeTaskManager.removePipeTask(pipeMeta.getStaticMeta(), regionId.intValue())).filter(Objects::nonNull).collect(Collectors.toSet());
        dataRegionPipeTasks.parallelStream().forEach(PipeTask::drop);
        this.pipeTaskManager.getPipeTasks(pipeMeta.getStaticMeta()).values().parallelStream().forEach(PipeTask::stop);
        dataRegionPipeTasks.parallelStream().forEach(pipeTask -> {
            PipeDataNodeTask newPipeTask = new PipeDataNodeTaskBuilder(pipeMeta.getStaticMeta(), ((PipeDataNodeTask)pipeTask).getRegionId(), (PipeTaskMeta)pipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap().get(((PipeDataNodeTask)pipeTask).getRegionId())).build();
            newPipeTask.create();
            this.pipeTaskManager.addPipeTask(pipeMeta.getStaticMeta(), ((PipeDataNodeTask)pipeTask).getRegionId(), (PipeTask)newPipeTask);
        });
        pipeMeta.getRuntimeMeta().getStatus().set(PipeStatus.STOPPED);
    }

    public Set<Integer> getPipeTaskRegionIdSet(String pipeName, long creationTime) {
        PipeMeta pipeMeta = this.pipeMetaKeeper.getPipeMeta(pipeName);
        return pipeMeta == null || pipeMeta.getStaticMeta().getCreationTime() != creationTime ? Collections.emptySet() : pipeMeta.getRuntimeMeta().getConsensusGroupId2TaskMetaMap().keySet();
    }
}

