/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.basic;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.iotdb.tsfile.file.metadata.IMetadata;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.filter.basic.OperatorType;
import org.apache.iotdb.tsfile.read.filter.operator.And;
import org.apache.iotdb.tsfile.read.filter.operator.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.operator.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.operator.Not;
import org.apache.iotdb.tsfile.read.filter.operator.Or;
import org.apache.iotdb.tsfile.read.filter.operator.TimeFilterOperators;
import org.apache.iotdb.tsfile.read.filter.operator.ValueFilterOperators;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public abstract class Filter {
    public abstract boolean satisfy(long var1, Object var3);

    public abstract boolean satisfyRow(long var1, Object[] var3);

    public abstract boolean[] satisfyTsBlock(TsBlock var1);

    public abstract boolean canSkip(IMetadata var1);

    public abstract boolean allSatisfy(IMetadata var1);

    public abstract boolean satisfyStartEndTime(long var1, long var3);

    public abstract boolean containStartEndTime(long var1, long var3);

    public abstract List<TimeRange> getTimeRanges();

    public abstract Filter reverse();

    public Filter copy() {
        return this;
    }

    public abstract OperatorType getOperatorType();

    public void serialize(DataOutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write(this.getOperatorType().ordinal(), (OutputStream)outputStream);
    }

    public void serialize(ByteBuffer buffer) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        this.serialize(dataOutputStream);
        buffer.put(byteArrayOutputStream.toByteArray());
    }

    public static Filter deserialize(ByteBuffer buffer) {
        OperatorType type = OperatorType.values()[ReadWriteIOUtils.readInt(buffer)];
        switch (type) {
            case TIME_EQ: {
                return new TimeFilterOperators.TimeEq(buffer);
            }
            case TIME_NEQ: {
                return new TimeFilterOperators.TimeNotEq(buffer);
            }
            case TIME_GT: {
                return new TimeFilterOperators.TimeGt(buffer);
            }
            case TIME_GTEQ: {
                return new TimeFilterOperators.TimeGtEq(buffer);
            }
            case TIME_LT: {
                return new TimeFilterOperators.TimeLt(buffer);
            }
            case TIME_LTEQ: {
                return new TimeFilterOperators.TimeLtEq(buffer);
            }
            case TIME_IN: {
                return new TimeFilterOperators.TimeIn(buffer);
            }
            case TIME_NOT_IN: {
                return new TimeFilterOperators.TimeNotIn(buffer);
            }
            case TIME_BETWEEN_AND: {
                return new TimeFilterOperators.TimeBetweenAnd(buffer);
            }
            case TIME_NOT_BETWEEN_AND: {
                return new TimeFilterOperators.TimeNotBetweenAnd(buffer);
            }
            case VALUE_EQ: {
                return new ValueFilterOperators.ValueEq(buffer);
            }
            case VALUE_NEQ: {
                return new ValueFilterOperators.ValueNotEq(buffer);
            }
            case VALUE_GT: {
                return new ValueFilterOperators.ValueGt(buffer);
            }
            case VALUE_GTEQ: {
                return new ValueFilterOperators.ValueGtEq(buffer);
            }
            case VALUE_LT: {
                return new ValueFilterOperators.ValueLt(buffer);
            }
            case VALUE_LTEQ: {
                return new ValueFilterOperators.ValueLtEq(buffer);
            }
            case VALUE_IN: {
                return new ValueFilterOperators.ValueIn(buffer);
            }
            case VALUE_NOT_IN: {
                return new ValueFilterOperators.ValueNotIn(buffer);
            }
            case VALUE_BETWEEN_AND: {
                return new ValueFilterOperators.ValueBetweenAnd(buffer);
            }
            case VALUE_NOT_BETWEEN_AND: {
                return new ValueFilterOperators.ValueNotBetweenAnd(buffer);
            }
            case VALUE_REGEXP: {
                return new ValueFilterOperators.ValueRegexp(buffer);
            }
            case VALUE_NOT_REGEXP: {
                return new ValueFilterOperators.ValueNotRegexp(buffer);
            }
            case GROUP_BY_TIME: {
                return new GroupByFilter(buffer);
            }
            case GROUP_BY_MONTH: {
                return new GroupByMonthFilter(buffer);
            }
            case AND: {
                return new And(buffer);
            }
            case OR: {
                return new Or(buffer);
            }
            case NOT: {
                return new Not(buffer);
            }
            case VALUE_IS_NULL: {
                return new ValueFilterOperators.ValueIsNull(buffer);
            }
            case VALUE_IS_NOT_NULL: {
                return new ValueFilterOperators.ValueIsNotNull(buffer);
            }
        }
        throw new UnsupportedOperationException("Unsupported operator type:" + (Object)((Object)type));
    }
}

