/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.encoding.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.encoding.bitpacking.LongPacker;
import org.apache.iotdb.tsfile.encoding.decoder.DoublePrecisionDecoderV2;
import org.apache.iotdb.tsfile.encoding.decoder.SprintzDecoder;
import org.apache.iotdb.tsfile.encoding.fire.LongFire;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;

public class DoubleSprintzDecoder
extends SprintzDecoder {
    LongPacker packer;
    LongFire firePred;
    private double preValue;
    private final double[] currentBuffer;
    private final long[] convertBuffer;
    private double currentValue;
    private final String predictScheme = TSFileDescriptor.getInstance().getConfig().getSprintzPredictScheme();

    public DoubleSprintzDecoder() {
        this.currentBuffer = new double[this.Block_size + 1];
        this.convertBuffer = new long[this.Block_size];
        this.firePred = new LongFire(3);
        this.reset();
    }

    @Override
    public boolean hasNext(ByteBuffer buffer) throws IOException {
        return this.isBlockReaded && this.currentCount < this.Block_size || buffer.remaining() > 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.preValue = 0.0;
        this.currentValue = 0.0;
        this.currentCount = 0;
        Arrays.fill(this.currentBuffer, 0.0);
        Arrays.fill(this.convertBuffer, 0L);
    }

    @Override
    protected void decodeBlock(ByteBuffer in) throws IOException {
        this.bitWidth = ReadWriteForEncodingUtils.readIntLittleEndianPaddedOnBitWidth(in, 1);
        if ((this.bitWidth & 0x80) != 0) {
            this.decodeSize = this.bitWidth & 0xFFFFFF7F;
            DoublePrecisionDecoderV2 decoder = new DoublePrecisionDecoderV2();
            for (int i = 0; i < this.decodeSize; ++i) {
                this.currentBuffer[i] = decoder.readDouble(in);
            }
        } else {
            int i;
            this.decodeSize = this.Block_size + 1;
            this.currentBuffer[0] = this.preValue = in.getDouble();
            long[] tmpBuffer = new long[8];
            this.packer = new LongPacker(this.bitWidth);
            byte[] packcle = new byte[this.bitWidth];
            for (i = 0; i < this.bitWidth; ++i) {
                packcle[i] = in.get();
            }
            this.packer.unpack8Values(packcle, 0, tmpBuffer);
            for (i = 0; i < 8; ++i) {
                this.convertBuffer[i] = tmpBuffer[i];
            }
            this.recalculate();
        }
        this.isBlockReaded = true;
    }

    @Override
    protected void recalculate() {
        int i;
        for (i = 0; i < this.Block_size; ++i) {
            this.convertBuffer[i] = this.convertBuffer[i] % 2L == 0L ? -this.convertBuffer[i] / 2L : (this.convertBuffer[i] + 1L) / 2L;
        }
        if (this.predictScheme.equals("delta")) {
            this.convertBuffer[0] = this.convertBuffer[0] + Double.doubleToLongBits(this.preValue);
            this.currentBuffer[1] = Double.longBitsToDouble(this.convertBuffer[0]);
            for (i = 1; i < this.Block_size; ++i) {
                int n = i;
                this.convertBuffer[n] = this.convertBuffer[n] + this.convertBuffer[i - 1];
                this.currentBuffer[i + 1] = Double.longBitsToDouble(this.convertBuffer[i]);
            }
        } else if (this.predictScheme.equals("fire")) {
            this.firePred.reset();
            long p = this.firePred.predict(Double.doubleToLongBits(this.preValue));
            long e = this.convertBuffer[0];
            this.convertBuffer[0] = this.convertBuffer[0] + p;
            this.currentBuffer[1] = Double.longBitsToDouble(this.convertBuffer[0]);
            this.firePred.train(Double.doubleToLongBits(this.preValue), this.convertBuffer[0], e);
            for (int i2 = 1; i2 < this.Block_size; ++i2) {
                long pred = this.firePred.predict(this.convertBuffer[i2 - 1]);
                long err = this.convertBuffer[i2];
                int n = i2;
                this.convertBuffer[n] = this.convertBuffer[n] + pred;
                this.currentBuffer[i2 + 1] = Double.longBitsToDouble(this.convertBuffer[i2]);
                this.firePred.train(this.convertBuffer[i2 - 1], this.convertBuffer[i2], err);
            }
        } else {
            throw new UnsupportedOperationException("Sprintz predictive method {} is not supported.");
        }
    }

    @Override
    public double readDouble(ByteBuffer buffer) {
        if (!this.isBlockReaded) {
            try {
                this.decodeBlock(buffer);
            }
            catch (IOException e) {
                logger.error("Error occured when readInt with Sprintz Decoder.", (Throwable)e);
            }
        }
        this.currentValue = this.currentBuffer[this.currentCount++];
        if (this.currentCount == this.decodeSize) {
            this.isBlockReaded = false;
            this.currentCount = 0;
        }
        return this.currentValue;
    }
}

