/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.task.meta;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.iotdb.commons.pipe.task.meta.PipeType;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PipeStaticMeta {
    private String pipeName;
    private long creationTime;
    private PipeParameters extractorParameters;
    private PipeParameters processorParameters;
    private PipeParameters connectorParameters;
    public static final String SYSTEM_PIPE_PREFIX = "__";
    public static final String SUBSCRIPTION_PIPE_PREFIX = "__subscription.";

    private PipeStaticMeta() {
    }

    public PipeStaticMeta(String pipeName, long creationTime, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) {
        this.pipeName = pipeName;
        this.creationTime = creationTime;
        this.extractorParameters = new PipeParameters(extractorAttributes);
        this.processorParameters = new PipeParameters(processorAttributes);
        this.connectorParameters = new PipeParameters(connectorAttributes);
    }

    public String getPipeName() {
        return this.pipeName;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public PipeParameters getExtractorParameters() {
        return this.extractorParameters;
    }

    public PipeParameters getProcessorParameters() {
        return this.processorParameters;
    }

    public PipeParameters getConnectorParameters() {
        return this.connectorParameters;
    }

    public PipeType getPipeType() {
        return PipeType.getPipeType(this.pipeName);
    }

    public ByteBuffer serialize() throws IOException {
        PublicBAOS byteArrayOutputStream = new PublicBAOS();
        DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);
        this.serialize(outputStream);
        return ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
    }

    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((String)this.pipeName, (OutputStream)outputStream);
        ReadWriteIOUtils.write((long)this.creationTime, (OutputStream)outputStream);
        ReadWriteIOUtils.write((int)this.extractorParameters.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.extractorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((int)this.processorParameters.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.processorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
        ReadWriteIOUtils.write((int)this.connectorParameters.getAttribute().size(), (OutputStream)outputStream);
        for (Map.Entry entry : this.connectorParameters.getAttribute().entrySet()) {
            ReadWriteIOUtils.write((String)((String)entry.getKey()), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)((String)entry.getValue()), (OutputStream)outputStream);
        }
    }

    public static PipeStaticMeta deserialize(InputStream inputStream) throws IOException {
        String value;
        String key;
        int i;
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta();
        pipeStaticMeta.pipeName = ReadWriteIOUtils.readString((InputStream)inputStream);
        pipeStaticMeta.creationTime = ReadWriteIOUtils.readLong((InputStream)inputStream);
        pipeStaticMeta.extractorParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.processorParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.connectorParameters = new PipeParameters(new HashMap());
        int size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ReadWriteIOUtils.readString((InputStream)inputStream);
            pipeStaticMeta.extractorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ReadWriteIOUtils.readString((InputStream)inputStream);
            pipeStaticMeta.processorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((InputStream)inputStream);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((InputStream)inputStream);
            value = ReadWriteIOUtils.readString((InputStream)inputStream);
            pipeStaticMeta.connectorParameters.getAttribute().put(key, value);
        }
        return pipeStaticMeta;
    }

    public static PipeStaticMeta deserialize(ByteBuffer byteBuffer) {
        String value;
        String key;
        int i;
        PipeStaticMeta pipeStaticMeta = new PipeStaticMeta();
        pipeStaticMeta.pipeName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        pipeStaticMeta.creationTime = ReadWriteIOUtils.readLong((ByteBuffer)byteBuffer);
        pipeStaticMeta.extractorParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.processorParameters = new PipeParameters(new HashMap());
        pipeStaticMeta.connectorParameters = new PipeParameters(new HashMap());
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            pipeStaticMeta.extractorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            pipeStaticMeta.processorParameters.getAttribute().put(key, value);
        }
        size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        for (i = 0; i < size; ++i) {
            key = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            value = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
            pipeStaticMeta.connectorParameters.getAttribute().put(key, value);
        }
        return pipeStaticMeta;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PipeStaticMeta that = (PipeStaticMeta)obj;
        return this.pipeName.equals(that.pipeName) && this.creationTime == that.creationTime && this.extractorParameters.equals((Object)that.extractorParameters) && this.processorParameters.equals((Object)that.processorParameters) && this.connectorParameters.equals((Object)that.connectorParameters);
    }

    public int hashCode() {
        return Objects.hash(this.pipeName, this.creationTime, this.extractorParameters, this.processorParameters, this.connectorParameters);
    }

    public String toString() {
        return "PipeStaticMeta{pipeName='" + this.pipeName + "', creationTime=" + this.creationTime + ", extractorParameters=" + this.extractorParameters + ", processorParameters=" + this.processorParameters + ", connectorParameters=" + this.connectorParameters + "}";
    }

    public static String generateSubscriptionPipeName(String topicName, String consumerGroupId) {
        return SUBSCRIPTION_PIPE_PREFIX + topicName + "_" + consumerGroupId;
    }
}

