/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.pattern;

import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class IoTDBPipePattern
extends PipePattern {
    private final PartialPath patternPartialPath;

    public IoTDBPipePattern(String pattern) {
        super(pattern);
        try {
            this.patternPartialPath = new PartialPath(this.getPattern());
        }
        catch (IllegalPathException e) {
            throw new PipeException("Illegal IoTDBPipePattern: " + this.getPattern(), (Throwable)e);
        }
    }

    @Override
    public String getDefaultPattern() {
        return "root.**";
    }

    @Override
    public boolean isLegal() {
        if (!this.pattern.startsWith("root")) {
            return false;
        }
        try {
            PathUtils.isLegalPath(this.pattern);
            return true;
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean coversDb(String db) {
        try {
            return this.patternPartialPath.include(new PartialPath(db, "**"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean coversDevice(String device) {
        try {
            return this.patternPartialPath.include(new PartialPath(device, "*"));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean mayOverlapWithDevice(String device) {
        try {
            return this.patternPartialPath.matchPrefixPath(new PartialPath(device));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public boolean matchesMeasurement(String device, String measurement) {
        if (Objects.isNull(measurement) || measurement.isEmpty()) {
            return false;
        }
        try {
            return this.patternPartialPath.matchFullPath(new PartialPath(device, measurement));
        }
        catch (IllegalPathException e) {
            return false;
        }
    }

    @Override
    public String toString() {
        return "IoTDBPipePattern" + super.toString();
    }
}

