/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.path;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.rmi.UnexpectedException;
import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.AlignedPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathDeserializeUtil;
import org.apache.iotdb.commons.path.PathType;
import org.apache.iotdb.commons.schema.view.LogicalViewSchema;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchemaType;
import org.apache.iotdb.tsfile.write.schema.VectorMeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeasurementPath
extends PartialPath {
    private static final Logger logger = LoggerFactory.getLogger(MeasurementPath.class);
    private IMeasurementSchema measurementSchema;
    private Map<String, String> tagMap;
    private Boolean isUnderAlignedEntity = false;
    private String measurementAlias = "";

    public MeasurementPath() {
    }

    public MeasurementPath(String measurementPath) throws IllegalPathException {
        super(measurementPath);
    }

    public MeasurementPath(String measurementPath, TSDataType type) throws IllegalPathException {
        super(measurementPath);
        this.measurementSchema = new MeasurementSchema(this.getMeasurement(), type);
    }

    public MeasurementPath(PartialPath path, TSDataType type) {
        this(path, (IMeasurementSchema)new MeasurementSchema(path.getMeasurement(), type), false);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema) {
        this(measurementPath, measurementSchema, false);
    }

    public MeasurementPath(PartialPath measurementPath, IMeasurementSchema measurementSchema, Boolean isUnderAlignedEntity) {
        super(measurementPath.getNodes());
        this.measurementSchema = measurementSchema;
        this.isUnderAlignedEntity = isUnderAlignedEntity;
    }

    public MeasurementPath(IDeviceID device, String measurement, IMeasurementSchema measurementSchema) throws IllegalPathException {
        this(((PlainDeviceID)device).toStringID(), measurement, measurementSchema);
    }

    public MeasurementPath(String device, String measurement, IMeasurementSchema measurementSchema) throws IllegalPathException {
        super(device, measurement);
        this.measurementSchema = measurementSchema;
    }

    public MeasurementPath(String[] nodes, IMeasurementSchema schema) {
        super(nodes);
        this.measurementSchema = schema;
    }

    @Override
    public IMeasurementSchema getMeasurementSchema() {
        return this.measurementSchema;
    }

    public Map<String, String> getTagMap() {
        return this.tagMap;
    }

    @Override
    public TSDataType getSeriesType() {
        return this.getMeasurementSchema().getType();
    }

    public byte getSeriesTypeInByte() {
        return this.getMeasurementSchema().getTypeInByte();
    }

    public void setMeasurementSchema(IMeasurementSchema measurementSchema) {
        this.measurementSchema = measurementSchema;
    }

    public void setTagMap(Map<String, String> tagMap) {
        this.tagMap = tagMap;
    }

    @Override
    public String getMeasurementAlias() {
        return this.measurementAlias;
    }

    @Override
    public void setMeasurementAlias(String measurementAlias) {
        if (measurementAlias != null) {
            this.measurementAlias = measurementAlias;
        }
    }

    public void removeMeasurementAlias() {
        this.measurementAlias = null;
    }

    @Override
    public boolean isMeasurementAliasExists() {
        return this.measurementAlias != null && !this.measurementAlias.isEmpty();
    }

    @Override
    public String getFullPathWithAlias() {
        if (this.getDevice().isEmpty()) {
            return this.measurementAlias;
        }
        return this.getDevice() + '.' + this.measurementAlias;
    }

    public boolean isUnderAlignedEntity() {
        if (this.isUnderAlignedEntity == null) {
            return false;
        }
        return this.isUnderAlignedEntity;
    }

    public void setUnderAlignedEntity(Boolean underAlignedEntity) {
        this.isUnderAlignedEntity = underAlignedEntity;
    }

    @Override
    public PartialPath copy() {
        MeasurementPath result = new MeasurementPath();
        result.nodes = this.nodes;
        result.fullPath = this.fullPath;
        result.device = this.device;
        result.measurementAlias = this.measurementAlias;
        result.measurementSchema = this.measurementSchema;
        if (this.tagMap != null) {
            result.tagMap = new HashMap<String, String>(this.tagMap);
        }
        result.isUnderAlignedEntity = this.isUnderAlignedEntity;
        return result;
    }

    public PartialPath transformToExactPath() {
        return this.isUnderAlignedEntity != false ? new AlignedPath(this) : this;
    }

    @Override
    public MeasurementPath clone() {
        MeasurementPath newMeasurementPath = null;
        try {
            newMeasurementPath = new MeasurementPath(this.getDevice(), this.getMeasurement(), this.getMeasurementSchema());
            newMeasurementPath.setUnderAlignedEntity(this.isUnderAlignedEntity);
            newMeasurementPath.setMeasurementAlias(this.measurementAlias);
            if (this.tagMap != null) {
                newMeasurementPath.setTagMap(new HashMap<String, String>(this.tagMap));
            }
        }
        catch (IllegalPathException e) {
            logger.warn("path is illegal: {}", (Object)this.getFullPath(), (Object)e);
        }
        return newMeasurementPath;
    }

    @Override
    public void serialize(ByteBuffer byteBuffer) {
        PathType.Measurement.serialize(byteBuffer);
        super.serializeWithoutType(byteBuffer);
        if (this.measurementSchema == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            MeasurementSchemaType measurementSchemaType = this.measurementSchema.getSchemaType();
            ReadWriteIOUtils.write((byte)measurementSchemaType.getMeasurementSchemaTypeInByteEnum(), (ByteBuffer)byteBuffer);
            this.measurementSchema.serializeTo(byteBuffer);
        }
        if (this.tagMap == null) {
            ReadWriteIOUtils.write((byte)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((byte)1, (ByteBuffer)byteBuffer);
            ReadWriteIOUtils.write(this.tagMap, (ByteBuffer)byteBuffer);
        }
        ReadWriteIOUtils.write((Boolean)this.isUnderAlignedEntity, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((String)this.measurementAlias, (ByteBuffer)byteBuffer);
    }

    @Override
    public void serialize(OutputStream stream) throws IOException {
        PathType.Measurement.serialize(stream);
        super.serializeWithoutType(stream);
        if (this.measurementSchema == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            MeasurementSchemaType measurementSchemaType = this.measurementSchema.getSchemaType();
            ReadWriteIOUtils.write((byte)measurementSchemaType.getMeasurementSchemaTypeInByteEnum(), (OutputStream)stream);
            this.measurementSchema.serializeTo(stream);
        }
        if (this.tagMap == null) {
            ReadWriteIOUtils.write((byte)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((byte)1, (OutputStream)stream);
            ReadWriteIOUtils.write(this.tagMap, (OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)this.isUnderAlignedEntity, (OutputStream)stream);
        ReadWriteIOUtils.write((String)this.measurementAlias, (OutputStream)stream);
    }

    public static MeasurementPath deserialize(ByteBuffer byteBuffer) {
        PartialPath partialPath = PartialPath.deserialize(byteBuffer);
        MeasurementPath measurementPath = new MeasurementPath();
        byte isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        if (isNull == 1) {
            byte type = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
            if (type == MeasurementSchemaType.MEASUREMENT_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
                measurementPath.measurementSchema = MeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer);
            } else if (type == MeasurementSchemaType.VECTOR_MEASUREMENT_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
                measurementPath.measurementSchema = VectorMeasurementSchema.deserializeFrom((ByteBuffer)byteBuffer);
            } else if (type == MeasurementSchemaType.LOGICAL_VIEW_SCHEMA.getMeasurementSchemaTypeInByteEnum()) {
                measurementPath.measurementSchema = LogicalViewSchema.deserializeFrom(byteBuffer);
            } else {
                throw new RuntimeException(new UnexpectedException("Type (" + type + ") of measurementSchema is unknown."));
            }
        }
        if ((isNull = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)) == 1) {
            measurementPath.tagMap = ReadWriteIOUtils.readMap((ByteBuffer)byteBuffer);
        }
        measurementPath.isUnderAlignedEntity = ReadWriteIOUtils.readBoolObject((ByteBuffer)byteBuffer);
        measurementPath.measurementAlias = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        measurementPath.nodes = partialPath.getNodes();
        measurementPath.device = partialPath.getDevice();
        measurementPath.fullPath = partialPath.getFullPath();
        return measurementPath;
    }

    @Override
    public PartialPath transformToPartialPath() {
        return this.getDevicePath().concatNode(this.getTailNode());
    }

    public static String transformDataToString(MeasurementPath measurementPath) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            measurementPath.serialize(dataOutputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return new String(bytes, StandardCharsets.ISO_8859_1);
    }

    public static MeasurementPath parseDataFromString(String measurementPathData) {
        return (MeasurementPath)PathDeserializeUtil.deserialize(ByteBuffer.wrap(measurementPathData.getBytes(StandardCharsets.ISO_8859_1)));
    }
}

