/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.rpc.subscription.payload.request;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public enum PipeSubscribeRequestType {
    HANDSHAKE(0),
    HEARTBEAT(1),
    POLL(2),
    COMMIT(3),
    CLOSE(4),
    SUBSCRIBE(5),
    UNSUBSCRIBE(6);

    private final short type;
    private static final Map<Short, PipeSubscribeRequestType> TYPE_MAP;

    private PipeSubscribeRequestType(short type) {
        this.type = type;
    }

    public short getType() {
        return this.type;
    }

    public static boolean isValidatedRequestType(short type) {
        return TYPE_MAP.containsKey(type);
    }

    public static PipeSubscribeRequestType valueOf(short type) {
        return TYPE_MAP.get(type);
    }

    static {
        TYPE_MAP = Arrays.stream(PipeSubscribeRequestType.values()).collect(HashMap::new, (typeMap, pipeRequestType) -> typeMap.put(pipeRequestType.getType(), pipeRequestType), HashMap::putAll);
    }
}

