/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.constant;

import java.io.File;

public class TestConstant {
    public static final String BASE_OUTPUT_PATH = "target".concat(File.separator);
    public static final String OUTPUT_DATA_DIR = BASE_OUTPUT_PATH.concat("data").concat(File.separator);
    public static final String PARTIAL_PATH_STRING = "%s" + File.separator + "%d" + File.separator + "%d" + File.separator;
    public static final String TEST_TSFILE_PATH = BASE_OUTPUT_PATH + "testTsFile".concat(File.separator) + PARTIAL_PATH_STRING;
    public static final String TIMESTAMP_STR = "Time";

    public static String firstValue(String path) {
        return String.format("first_value(%s)", path);
    }

    public static String lastValue(String path) {
        return String.format("last_value(%s)", path);
    }

    public static String sum(String path) {
        return String.format("sum(%s)", path);
    }

    public static String avg(String path) {
        return String.format("avg(%s)", path);
    }

    public static String count(String path) {
        return String.format("count(%s)", path);
    }

    public static String maxTime(String path) {
        return String.format("max_time(%s)", path);
    }

    public static String minTime(String path) {
        return String.format("min_time(%s)", path);
    }

    public static String maxValue(String path) {
        return String.format("max_value(%s)", path);
    }

    public static String extreme(String path) {
        return String.format("extreme(%s)", path);
    }

    public static String minValue(String path) {
        return String.format("min_value(%s)", path);
    }

    public static String maxBy(String x, String y) {
        return String.format("max_by(%s, %s)", x, y);
    }

    public static String minBy(String x, String y) {
        return String.format("min_by(%s, %s)", x, y);
    }

    private TestConstant() {
    }

    public static String getTestTsFilePath(String logicalStorageGroupName, long virtualStorageGroupId, long timePartitionId, long tsFileVersion) {
        String filePath = String.format(TEST_TSFILE_PATH, logicalStorageGroupName, virtualStorageGroupId, timePartitionId);
        String fileName = System.currentTimeMillis() + "-" + tsFileVersion + "-0-0.tsfile";
        return filePath.concat(fileName);
    }

    public static String getTestTsFileDir(String logicalStorageGroupName, long virtualStorageGroupId, long timePartitionId) {
        return String.format(TEST_TSFILE_PATH, logicalStorageGroupName, virtualStorageGroupId, timePartitionId);
    }
}

