/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.common.rpc.thrift.TAggregationType;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.queryengine.execution.operator.AggregationUtil;
import org.apache.iotdb.db.queryengine.plan.statement.component.Ordering;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class SchemaUtils {
    private static final Map<TSDataType, Set<TSEncoding>> schemaChecker = new EnumMap<TSDataType, Set<TSEncoding>>(TSDataType.class);

    private SchemaUtils() {
    }

    public static List<TSDataType> getAggregatedDataTypes(List<TSDataType> measurementDataType, String aggregation) {
        TSDataType dataType = SchemaUtils.getBuiltinAggregationTypeByFuncName(aggregation);
        if (dataType != null) {
            return Collections.nCopies(measurementDataType.size(), dataType);
        }
        return measurementDataType;
    }

    public static TSDataType getSeriesTypeByPath(PartialPath path, String aggregation) {
        TSDataType dataType = SchemaUtils.getBuiltinAggregationTypeByFuncName(aggregation);
        if (dataType != null) {
            return dataType;
        }
        return path.getSeriesType();
    }

    public static TSDataType getBuiltinAggregationTypeByFuncName(String aggregation) {
        if (aggregation == null) {
            return null;
        }
        switch (aggregation.toLowerCase()) {
            case "min_time": 
            case "max_time": 
            case "count": 
            case "time_duration": 
            case "count_time": {
                return TSDataType.INT64;
            }
            case "avg": 
            case "sum": 
            case "stddev": 
            case "stddev_pop": 
            case "stddev_samp": 
            case "variance": 
            case "var_pop": 
            case "var_samp": {
                return TSDataType.DOUBLE;
            }
            case "stddev_partial": 
            case "stddev_pop_partial": 
            case "stddev_samp_partial": 
            case "variance_partial": 
            case "var_pop_partial": 
            case "var_samp_partial": 
            case "max_by_partial": 
            case "min_by_partial": {
                return TSDataType.TEXT;
            }
        }
        return null;
    }

    public static String getBuiltinAggregationName(TAggregationType aggregationType) {
        if (aggregationType == null) {
            return null;
        }
        switch (aggregationType) {
            case COUNT: {
                return "count";
            }
            case AVG: {
                return "avg";
            }
            case SUM: {
                return "sum";
            }
            case FIRST_VALUE: {
                return "first_value";
            }
            case LAST_VALUE: {
                return "last_value";
            }
            case MAX_TIME: {
                return "max_time";
            }
            case MIN_TIME: {
                return "min_time";
            }
            case MAX_VALUE: {
                return "max_value";
            }
            case MIN_VALUE: {
                return "min_value";
            }
            case EXTREME: {
                return "extreme";
            }
            case COUNT_IF: {
                return "count_if";
            }
            case TIME_DURATION: {
                return "time_duration";
            }
            case MODE: {
                return "mode";
            }
            case COUNT_TIME: {
                return "count_time";
            }
            case STDDEV: {
                return "stddev";
            }
            case STDDEV_POP: {
                return "stddev_pop";
            }
            case STDDEV_SAMP: {
                return "stddev_samp";
            }
            case VARIANCE: {
                return "variance";
            }
            case VAR_POP: {
                return "var_pop";
            }
            case VAR_SAMP: {
                return "var_samp";
            }
        }
        return null;
    }

    public static boolean isConsistentWithScanOrder(TAggregationType aggregationFunction, Ordering scanOrder) {
        boolean ascending = scanOrder == Ordering.ASC;
        switch (aggregationFunction) {
            case FIRST_VALUE: 
            case MIN_TIME: {
                return ascending;
            }
            case LAST_VALUE: 
            case MAX_TIME: {
                return !ascending;
            }
            case COUNT: 
            case AVG: 
            case SUM: 
            case MAX_VALUE: 
            case MIN_VALUE: 
            case EXTREME: 
            case TIME_DURATION: 
            case COUNT_TIME: 
            case STDDEV: 
            case STDDEV_POP: 
            case STDDEV_SAMP: 
            case VARIANCE: 
            case VAR_POP: 
            case VAR_SAMP: 
            case MAX_BY: 
            case MIN_BY: 
            case UDAF: {
                return true;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", aggregationFunction));
    }

    public static void checkDataTypeWithEncoding(TSDataType dataType, TSEncoding encoding) throws MetadataException {
        if (!schemaChecker.get(dataType).contains(encoding)) {
            throw new MetadataException(String.format("encoding %s does not support %s", encoding, dataType), true);
        }
    }

    public static List<String> splitPartialBuiltinAggregation(TAggregationType aggregationType) {
        switch (aggregationType) {
            case FIRST_VALUE: {
                return Collections.singletonList("min_time");
            }
            case LAST_VALUE: {
                return Collections.singletonList("max_time");
            }
            case STDDEV: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("stddev"));
            }
            case STDDEV_POP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("stddev_pop"));
            }
            case STDDEV_SAMP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("stddev_samp"));
            }
            case VARIANCE: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("variance"));
            }
            case VAR_POP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("var_pop"));
            }
            case VAR_SAMP: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("var_samp"));
            }
            case MAX_BY: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("max_by"));
            }
            case MIN_BY: {
                return Collections.singletonList(AggregationUtil.addPartialSuffix("min_by"));
            }
            case AVG: {
                return Arrays.asList("count", "sum");
            }
            case TIME_DURATION: {
                return Arrays.asList("max_time", "min_time");
            }
            case COUNT: 
            case SUM: 
            case MAX_TIME: 
            case MIN_TIME: 
            case MAX_VALUE: 
            case MIN_VALUE: 
            case EXTREME: 
            case COUNT_IF: 
            case MODE: 
            case COUNT_TIME: {
                return Collections.emptyList();
            }
        }
        throw new IllegalArgumentException(String.format("Invalid Aggregation function: %s", aggregationType));
    }

    static {
        HashSet<TSEncoding> booleanSet = new HashSet<TSEncoding>();
        booleanSet.add(TSEncoding.PLAIN);
        booleanSet.add(TSEncoding.RLE);
        schemaChecker.put(TSDataType.BOOLEAN, booleanSet);
        HashSet<TSEncoding> intSet = new HashSet<TSEncoding>();
        intSet.add(TSEncoding.PLAIN);
        intSet.add(TSEncoding.RLE);
        intSet.add(TSEncoding.TS_2DIFF);
        intSet.add(TSEncoding.GORILLA);
        intSet.add(TSEncoding.ZIGZAG);
        intSet.add(TSEncoding.CHIMP);
        intSet.add(TSEncoding.SPRINTZ);
        intSet.add(TSEncoding.RLBE);
        schemaChecker.put(TSDataType.INT32, intSet);
        schemaChecker.put(TSDataType.INT64, intSet);
        HashSet<TSEncoding> floatSet = new HashSet<TSEncoding>();
        floatSet.add(TSEncoding.PLAIN);
        floatSet.add(TSEncoding.RLE);
        floatSet.add(TSEncoding.TS_2DIFF);
        floatSet.add(TSEncoding.GORILLA_V1);
        floatSet.add(TSEncoding.GORILLA);
        floatSet.add(TSEncoding.CHIMP);
        floatSet.add(TSEncoding.SPRINTZ);
        floatSet.add(TSEncoding.RLBE);
        schemaChecker.put(TSDataType.FLOAT, floatSet);
        schemaChecker.put(TSDataType.DOUBLE, floatSet);
        HashSet<TSEncoding> textSet = new HashSet<TSEncoding>();
        textSet.add(TSEncoding.PLAIN);
        textSet.add(TSEncoding.DICTIONARY);
        schemaChecker.put(TSDataType.TEXT, textSet);
    }
}

