/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.subscription.receiver;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.consensus.ConfigRegionId;
import org.apache.iotdb.commons.subscription.config.SubscriptionConfig;
import org.apache.iotdb.confignode.rpc.thrift.TCloseConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TCreateConsumerReq;
import org.apache.iotdb.confignode.rpc.thrift.TSubscribeReq;
import org.apache.iotdb.confignode.rpc.thrift.TUnsubscribeReq;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.plan.parser.ASTVisitor;
import org.apache.iotdb.db.subscription.agent.SubscriptionAgent;
import org.apache.iotdb.db.subscription.broker.SerializedEnrichedEvent;
import org.apache.iotdb.db.subscription.receiver.SubscriptionReceiver;
import org.apache.iotdb.db.subscription.timer.SubscriptionPollTimer;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.rpc.subscription.config.ConsumerConfig;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeCloseReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeCommitReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeHandshakeReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeHeartbeatReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribePollReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestType;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeRequestVersion;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeSubscribeReq;
import org.apache.iotdb.rpc.subscription.payload.request.PipeSubscribeUnsubscribeReq;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeCloseResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeCommitResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeHandshakeResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeHeartbeatResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribePollResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseType;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeResponseVersion;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeSubscribeResp;
import org.apache.iotdb.rpc.subscription.payload.response.PipeSubscribeUnsubscribeResp;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeReq;
import org.apache.iotdb.service.rpc.thrift.TPipeSubscribeResp;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionReceiverV1
implements SubscriptionReceiver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionReceiverV1.class);
    private static final IClientManager<ConfigRegionId, ConfigNodeClient> CONFIG_NODE_CLIENT_MANAGER = ConfigNodeClientManager.getInstance();
    private static final TPipeSubscribeResp SUBSCRIPTION_MISSING_CUSTOMER_RESP = new TPipeSubscribeResp(RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_MISSING_CUSTOMER, (String)"Missing consumer config, please handshake first."), PipeSubscribeResponseVersion.VERSION_1.getVersion(), PipeSubscribeResponseType.ACK.getType());
    private final ThreadLocal<ConsumerConfig> consumerConfigThreadLocal = new ThreadLocal();

    @Override
    public PipeSubscribeRequestVersion getVersion() {
        return PipeSubscribeRequestVersion.VERSION_1;
    }

    @Override
    public void handleExit() {
        LOGGER.info("Subscription: remove consumer config {} when handling exit", (Object)this.consumerConfigThreadLocal.get());
        this.consumerConfigThreadLocal.remove();
    }

    @Override
    public final TPipeSubscribeResp handle(TPipeSubscribeReq req) {
        short reqType = req.getType();
        if (PipeSubscribeRequestType.isValidatedRequestType((short)reqType)) {
            switch (PipeSubscribeRequestType.valueOf((short)reqType)) {
                case HANDSHAKE: {
                    return this.handlePipeSubscribeHandshake(PipeSubscribeHandshakeReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case HEARTBEAT: {
                    return this.handlePipeSubscribeHeartbeat(PipeSubscribeHeartbeatReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case SUBSCRIBE: {
                    return this.handlePipeSubscribeSubscribe(PipeSubscribeSubscribeReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case UNSUBSCRIBE: {
                    return this.handlePipeSubscribeUnsubscribe(PipeSubscribeUnsubscribeReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case POLL: {
                    return this.handlePipeSubscribePoll(PipeSubscribePollReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case COMMIT: {
                    return this.handlePipeSubscribeCommit(PipeSubscribeCommitReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
                case CLOSE: {
                    return this.handlePipeSubscribeClose(PipeSubscribeCloseReq.fromTPipeSubscribeReq((TPipeSubscribeReq)req));
                }
            }
        }
        TSStatus status = RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_TYPE_ERROR, (String)String.format("Unknown PipeSubscribeRequestType %s.", reqType));
        LOGGER.warn("Subscription: Unknown PipeSubscribeRequestType, response status = {}.", (Object)status);
        return new TPipeSubscribeResp(status, PipeSubscribeResponseVersion.VERSION_1.getVersion(), PipeSubscribeResponseType.ACK.getType());
    }

    private TPipeSubscribeResp handlePipeSubscribeHandshake(PipeSubscribeHandshakeReq req) {
        try {
            return this.handlePipeSubscribeHandshakeInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when handshaking: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribeHandshakeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_HANDSHAKE_ERROR, (String)exceptionMessage), (int)-1, (String)"", (String)"");
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeHandshakeInternal(PipeSubscribeHandshakeReq req) throws SubscriptionException {
        String consumerGroupId;
        ConsumerConfig existedConsumerConfig = this.consumerConfigThreadLocal.get();
        ConsumerConfig consumerConfig = req.getConsumerConfig();
        String consumerId = consumerConfig.getConsumerId();
        if (Objects.isNull(consumerId)) {
            consumerId = UUID.randomUUID().toString();
            consumerConfig.setConsumerId(consumerId);
        }
        if (Objects.isNull(consumerGroupId = consumerConfig.getConsumerGroupId())) {
            consumerGroupId = UUID.randomUUID().toString();
            consumerConfig.setConsumerGroupId(consumerGroupId);
        }
        if (Objects.isNull(existedConsumerConfig)) {
            this.consumerConfigThreadLocal.set(consumerConfig);
        } else if (!existedConsumerConfig.equals((Object)consumerConfig)) {
            LOGGER.warn("Subscription: Detect stale consumer config when handshaking, stale consumer config {} will be cleared, consumer config will set to the incoming consumer config {}.", (Object)existedConsumerConfig, (Object)consumerConfig);
            this.dropConsumer(existedConsumerConfig);
            this.consumerConfigThreadLocal.set(consumerConfig);
        }
        if (!SubscriptionAgent.consumer().isConsumerExisted(consumerGroupId, consumerId)) {
            this.createConsumer(consumerConfig);
        } else {
            LOGGER.info("Subscription: The consumer {} has already existed when handshaking, skip creating consumer.", (Object)consumerConfig);
        }
        int dataNodeId = IoTDBDescriptor.getInstance().getConfig().getDataNodeId();
        LOGGER.info("Subscription: consumer {} handshake successfully, data node id: {}", (Object)req.getConsumerConfig(), (Object)dataNodeId);
        return PipeSubscribeHandshakeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, (int)dataNodeId, (String)consumerId, (String)consumerGroupId);
    }

    private TPipeSubscribeResp handlePipeSubscribeHeartbeat(PipeSubscribeHeartbeatReq req) {
        try {
            return this.handlePipeSubscribeHeartbeatInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when heartbeat: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribeHeartbeatResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_HEARTBEAT_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeHeartbeatInternal(PipeSubscribeHeartbeatReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeHeartbeatReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        LOGGER.info("Subscription: consumer {} heartbeat successfully", (Object)consumerConfig);
        return PipeSubscribeHeartbeatResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private TPipeSubscribeResp handlePipeSubscribeSubscribe(PipeSubscribeSubscribeReq req) {
        try {
            return this.handlePipeSubscribeSubscribeInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when subscribing: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribeSubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_SUBSCRIBE_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeSubscribeInternal(PipeSubscribeSubscribeReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeSubscribeReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Set<String> topicNames = req.getTopicNames();
        topicNames = topicNames.stream().map(ASTVisitor::parseIdentifier).collect(Collectors.toSet());
        this.subscribe(consumerConfig, topicNames);
        LOGGER.info("Subscription: consumer {} subscribe {} successfully", (Object)consumerConfig, topicNames);
        return PipeSubscribeSubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private TPipeSubscribeResp handlePipeSubscribeUnsubscribe(PipeSubscribeUnsubscribeReq req) {
        try {
            return this.handlePipeSubscribeUnsubscribeInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when unsubscribing: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribeUnsubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_UNSUBSCRIBE_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeUnsubscribeInternal(PipeSubscribeUnsubscribeReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeUnsubscribeReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Set<String> topicNames = req.getTopicNames();
        topicNames = topicNames.stream().map(ASTVisitor::parseIdentifier).collect(Collectors.toSet());
        this.unsubscribe(consumerConfig, topicNames);
        LOGGER.info("Subscription: consumer {} unsubscribe {} successfully", (Object)consumerConfig, topicNames);
        return PipeSubscribeUnsubscribeResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private TPipeSubscribeResp handlePipeSubscribePoll(PipeSubscribePollReq req) {
        try {
            return this.handlePipeSubscribePollInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when polling: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribePollResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_POLL_ERROR, (String)exceptionMessage), Collections.emptyList());
        }
    }

    private TPipeSubscribeResp handlePipeSubscribePollInternal(PipeSubscribePollReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribePollReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Set<String> topicNames = req.getTopicNames();
        topicNames = topicNames.isEmpty() ? SubscriptionAgent.consumer().getTopicsSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId()) : topicNames.stream().map(ASTVisitor::parseIdentifier).collect(Collectors.toSet());
        SubscriptionPollTimer timer = new SubscriptionPollTimer(System.currentTimeMillis(), req.getTimeoutMs() == 0L ? SubscriptionConfig.getInstance().getSubscriptionDefaultPollTimeoutMs() : Math.max(req.getTimeoutMs(), SubscriptionConfig.getInstance().getSubscriptionMinPollTimeoutMs()));
        List<SerializedEnrichedEvent> events = SubscriptionAgent.broker().poll(consumerConfig, topicNames, timer);
        List subscriptionCommitIds = events.stream().map(SerializedEnrichedEvent::getSubscriptionCommitId).collect(Collectors.toList());
        if (timer.isExpired()) {
            LOGGER.warn("Subscription: timeout happened when consumer {} poll topics {}", (Object)consumerConfig, topicNames);
        }
        LOGGER.info("Subscription: consumer {} poll topics {} successfully, commit ids: {}", new Object[]{consumerConfig, topicNames, subscriptionCommitIds});
        List enrichedTabletsWithByteBufferList = events.stream().map(event -> new Pair((Object)event.getByteBuffer(), (Object)event.getEnrichedTablets())).collect(Collectors.toList());
        PipeSubscribePollResp resp = PipeSubscribePollResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS, enrichedTabletsWithByteBufferList);
        events.forEach(SerializedEnrichedEvent::resetByteBuffer);
        return resp;
    }

    private TPipeSubscribeResp handlePipeSubscribeCommit(PipeSubscribeCommitReq req) {
        try {
            return this.handlePipeSubscribeCommitInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when committing: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribeCommitResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_COMMIT_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeCommitInternal(PipeSubscribeCommitReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeCommitReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Map topicNameToSubscriptionCommitIds = req.getTopicNameToSubscriptionCommitIds();
        SubscriptionAgent.broker().commit(consumerConfig, topicNameToSubscriptionCommitIds);
        LOGGER.info("Subscription: consumer commit {} successfully, commit ids: {}", (Object)consumerConfig, (Object)topicNameToSubscriptionCommitIds);
        return PipeSubscribeCommitResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private TPipeSubscribeResp handlePipeSubscribeClose(PipeSubscribeCloseReq req) {
        try {
            return this.handlePipeSubscribeCloseInternal(req);
        }
        catch (SubscriptionException e) {
            String exceptionMessage = String.format("Subscription: something unexpected happened when closing: %s, req: %s", e.getMessage(), req);
            LOGGER.warn(exceptionMessage);
            return PipeSubscribeCloseResp.toTPipeSubscribeResp((TSStatus)RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUBSCRIPTION_COMMIT_ERROR, (String)exceptionMessage));
        }
    }

    private TPipeSubscribeResp handlePipeSubscribeCloseInternal(PipeSubscribeCloseReq req) {
        ConsumerConfig consumerConfig = this.consumerConfigThreadLocal.get();
        if (Objects.isNull(consumerConfig)) {
            LOGGER.warn("Subscription: missing consumer config when handling PipeSubscribeCloseReq: {}", (Object)req);
            return SUBSCRIPTION_MISSING_CUSTOMER_RESP;
        }
        Set<String> topics = SubscriptionAgent.consumer().getTopicsSubscribedByConsumer(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId());
        if (!topics.isEmpty()) {
            LOGGER.info("Subscription: unsubscribe all subscribed topics {} before close consumer {}", topics, (Object)consumerConfig);
            this.unsubscribe(consumerConfig, topics);
        }
        if (SubscriptionAgent.consumer().isConsumerExisted(consumerConfig.getConsumerGroupId(), consumerConfig.getConsumerId())) {
            this.dropConsumer(consumerConfig);
        } else {
            LOGGER.info("Subscription: The consumer {} does not existed when closing, skip dropping consumer.", (Object)consumerConfig);
        }
        LOGGER.info("Subscription: consumer {} close successfully", (Object)consumerConfig);
        return PipeSubscribeCloseResp.toTPipeSubscribeResp((TSStatus)RpcUtils.SUCCESS_STATUS);
    }

    private void createConsumer(ConsumerConfig consumerConfig) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCreateConsumerReq req = new TCreateConsumerReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId()).setConsumerAttributes(consumerConfig.getAttribute());
            TSStatus tsStatus = configNodeClient.createConsumer(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                String exceptionMessage = String.format("Subscription: Failed to create consumer %s in config node, status is %s.", consumerConfig, tsStatus);
                LOGGER.warn(exceptionMessage);
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            String exceptionMessage = String.format("Subscription: Failed to create consumer %s in config node, exception is %s.", consumerConfig, e.getMessage());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    private void dropConsumer(ConsumerConfig consumerConfig) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TCloseConsumerReq req = new TCloseConsumerReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId());
            TSStatus tsStatus = configNodeClient.closeConsumer(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                String exceptionMessage = String.format("Subscription: Failed to close consumer %s in config node, status is %s.", consumerConfig, tsStatus);
                LOGGER.warn(exceptionMessage);
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            String exceptionMessage = String.format("Subscription: Failed to close consumer %s in config node, exception is %s.", consumerConfig, e.getMessage());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    private void subscribe(ConsumerConfig consumerConfig, Set<String> topicNames) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TSubscribeReq req = new TSubscribeReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId()).setTopicNames(topicNames);
            TSStatus tsStatus = configNodeClient.createSubscription(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                String exceptionMessage = String.format("Subscription: Failed to subscribe topics %s for consumer %s in config node, status is %s.", topicNames, consumerConfig, tsStatus);
                LOGGER.warn(exceptionMessage);
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            String exceptionMessage = String.format("Subscription: Failed to subscribe topics %s for consumer %s in config node, exception is %s.", topicNames, consumerConfig, e.getMessage());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }

    private void unsubscribe(ConsumerConfig consumerConfig, Set<String> topicNames) throws SubscriptionException {
        try (ConfigNodeClient configNodeClient = (ConfigNodeClient)CONFIG_NODE_CLIENT_MANAGER.borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);){
            TUnsubscribeReq req = new TUnsubscribeReq().setConsumerId(consumerConfig.getConsumerId()).setConsumerGroupId(consumerConfig.getConsumerGroupId()).setTopicNames(topicNames);
            TSStatus tsStatus = configNodeClient.dropSubscription(req);
            if (TSStatusCode.SUCCESS_STATUS.getStatusCode() != tsStatus.getCode()) {
                String exceptionMessage = String.format("Subscription: Failed to unsubscribe topics %s for consumer %s in config node, status is %s.", topicNames, consumerConfig, tsStatus);
                LOGGER.warn(exceptionMessage);
                throw new SubscriptionException(exceptionMessage);
            }
        }
        catch (ClientManagerException | TException e) {
            String exceptionMessage = String.format("Subscription: Failed to unsubscribe topics %s for consumer %s in config node, exception is %s.", topicNames, consumerConfig, e.getMessage());
            LOGGER.warn(exceptionMessage);
            throw new SubscriptionException(exceptionMessage);
        }
    }
}

