/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.wal.buffer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.buffer.IWALBuffer;
import org.apache.iotdb.db.storageengine.dataregion.wal.io.WALWriter;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileStatus;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.WALFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWALBuffer
implements IWALBuffer {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWALBuffer.class);
    protected final String identifier;
    protected final String logDirectory;
    protected long diskUsage = 0L;
    protected long fileNum = 0L;
    protected volatile long currentWALFileVersion;
    protected volatile long currentSearchIndex;
    protected volatile WALWriter currentWALFileWriter;

    protected AbstractWALBuffer(String identifier, String logDirectory, long startFileVersion, long startSearchIndex) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = logDirectory;
        File logDirFile = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!logDirFile.exists() && logDirFile.mkdirs()) {
            logger.info("Create folder {} for wal node-{}'s buffer.", (Object)logDirectory, (Object)identifier);
        }
        File[] walFiles = WALFileUtils.listAllWALFiles(logDirFile);
        this.addDiskUsage(Arrays.stream(walFiles).mapToLong(File::length).sum());
        this.addFileNum(walFiles.length);
        this.currentSearchIndex = startSearchIndex;
        this.currentWALFileWriter = new WALWriter(SystemFileFactory.INSTANCE.getFile(logDirectory, WALFileUtils.getLogFileName(startFileVersion, this.currentSearchIndex, WALFileStatus.CONTAINS_SEARCH_INDEX)));
        this.currentWALFileVersion = startFileVersion;
    }

    @Override
    public long getCurrentWALFileVersion() {
        return this.currentWALFileVersion;
    }

    @Override
    public long getCurrentWALFileSize() {
        return this.currentWALFileWriter.size();
    }

    protected File rollLogWriter(long searchIndex, WALFileStatus fileStatus) throws IOException {
        this.currentWALFileWriter.close();
        this.addDiskUsage(this.currentWALFileWriter.size());
        this.addFileNum(1L);
        File lastFile = this.currentWALFileWriter.getLogFile();
        String lastName = lastFile.getName();
        if (WALFileUtils.parseStatusCode(lastName) != fileStatus) {
            String targetName = WALFileUtils.getLogFileName(WALFileUtils.parseVersionId(lastName), WALFileUtils.parseStartSearchIndex(lastName), fileStatus);
            File targetFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, targetName);
            Files.move(lastFile.toPath(), targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            lastFile = targetFile;
        }
        long nextFileVersion = this.currentWALFileVersion + 1L;
        File nextLogFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, WALFileUtils.getLogFileName(nextFileVersion, searchIndex, WALFileStatus.CONTAINS_SEARCH_INDEX));
        this.currentWALFileWriter = new WALWriter(nextLogFile);
        this.currentWALFileVersion = nextFileVersion;
        logger.debug("Open new wal file {} for wal node-{}'s buffer.", (Object)nextLogFile, (Object)this.identifier);
        return lastFile;
    }

    public long getDiskUsage() {
        return this.diskUsage;
    }

    public void addDiskUsage(long size) {
        this.diskUsage += size;
        WALManager.getInstance().addTotalDiskUsage(size);
    }

    public void subtractDiskUsage(long size) {
        this.diskUsage -= size;
        WALManager.getInstance().subtractTotalDiskUsage(size);
    }

    public long getFileNum() {
        return this.fileNum;
    }

    public void addFileNum(long num) {
        this.fileNum += num;
        WALManager.getInstance().addTotalFileNum(num);
    }

    public void subtractFileNum(long num) {
        this.fileNum -= num;
        WALManager.getInstance().subtractTotalFileNum(num);
    }

    @Override
    public long getCurrentSearchIndex() {
        return this.currentSearchIndex;
    }
}

