/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.TimePartitionUtils;
import org.apache.iotdb.db.exception.PartitionViolationException;
import org.apache.iotdb.db.queryengine.plan.analyze.cache.schema.DataNodeDevicePathCache;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.FileTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.RamUsageEstimator;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTimeIndex
implements ITimeIndex {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(DeviceTimeIndex.class);
    private static final Logger logger = LoggerFactory.getLogger(DeviceTimeIndex.class);
    public static final int INIT_ARRAY_SIZE = 64;
    protected long[] startTimes;
    protected long[] endTimes;
    private long minStartTime = Long.MAX_VALUE;
    private long maxEndTime = Long.MIN_VALUE;
    protected Map<IDeviceID, Integer> deviceToIndex;

    public DeviceTimeIndex() {
        this.deviceToIndex = new ConcurrentHashMap<IDeviceID, Integer>();
        this.startTimes = new long[64];
        this.endTimes = new long[64];
        this.initTimes(this.startTimes, Long.MAX_VALUE);
        this.initTimes(this.endTimes, Long.MIN_VALUE);
    }

    public DeviceTimeIndex(Map<IDeviceID, Integer> deviceToIndex, long[] startTimes, long[] endTimes) {
        this.startTimes = startTimes;
        this.endTimes = endTimes;
        this.deviceToIndex = deviceToIndex;
    }

    @Override
    public void serialize(OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)this.getTimeIndexType(), (OutputStream)outputStream);
        int deviceNum = this.deviceToIndex.size();
        ReadWriteIOUtils.write((int)deviceNum, (OutputStream)outputStream);
        for (int i = 0; i < deviceNum; ++i) {
            ReadWriteIOUtils.write((long)this.startTimes[i], (OutputStream)outputStream);
            ReadWriteIOUtils.write((long)this.endTimes[i], (OutputStream)outputStream);
        }
        for (Map.Entry<IDeviceID, Integer> stringIntegerEntry : this.deviceToIndex.entrySet()) {
            IDeviceID device = stringIntegerEntry.getKey();
            int index = stringIntegerEntry.getValue();
            ReadWriteIOUtils.write((String)((PlainDeviceID)device).toStringID(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)index, (OutputStream)outputStream);
        }
    }

    @Override
    public DeviceTimeIndex deserialize(InputStream inputStream) throws IOException {
        int i;
        int deviceNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        this.startTimes = new long[deviceNum];
        this.endTimes = new long[deviceNum];
        for (i = 0; i < deviceNum; ++i) {
            this.startTimes[i] = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.endTimes[i] = ReadWriteIOUtils.readLong((InputStream)inputStream);
            this.minStartTime = Math.min(this.minStartTime, this.startTimes[i]);
            this.maxEndTime = Math.max(this.maxEndTime, this.endTimes[i]);
        }
        for (i = 0; i < deviceNum; ++i) {
            String path = DataNodeDevicePathCache.getInstance().getDeviceId(ReadWriteIOUtils.readString((InputStream)inputStream));
            int index = ReadWriteIOUtils.readInt((InputStream)inputStream);
            this.deviceToIndex.put((IDeviceID)new PlainDeviceID(path), index);
        }
        return this;
    }

    @Override
    public DeviceTimeIndex deserialize(ByteBuffer buffer) {
        int i;
        int deviceNum = buffer.getInt();
        this.startTimes = new long[deviceNum];
        this.endTimes = new long[deviceNum];
        for (i = 0; i < deviceNum; ++i) {
            this.startTimes[i] = buffer.getLong();
            this.endTimes[i] = buffer.getLong();
            this.minStartTime = Math.min(this.minStartTime, this.startTimes[i]);
            this.maxEndTime = Math.max(this.maxEndTime, this.endTimes[i]);
        }
        for (i = 0; i < deviceNum; ++i) {
            String path = DataNodeDevicePathCache.getInstance().getDeviceId(ReadWriteIOUtils.readString((ByteBuffer)buffer));
            int index = buffer.getInt();
            this.deviceToIndex.put((IDeviceID)new PlainDeviceID(path), index);
        }
        return this;
    }

    @Override
    public void close() {
        this.startTimes = Arrays.copyOfRange(this.startTimes, 0, this.deviceToIndex.size());
        this.endTimes = Arrays.copyOfRange(this.endTimes, 0, this.deviceToIndex.size());
    }

    public Set<IDeviceID> getDevices() {
        return this.deviceToIndex.keySet();
    }

    @Override
    public Set<IDeviceID> getDevices(String tsFilePath, TsFileResource tsFileResource) {
        return this.deviceToIndex.keySet();
    }

    public static Set<IDeviceID> getDevices(InputStream inputStream) throws IOException {
        int deviceNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
        ReadWriteIOUtils.skip((InputStream)inputStream, (long)(2L * (long)deviceNum * 8L));
        HashSet<IDeviceID> devices = new HashSet<IDeviceID>();
        for (int i = 0; i < deviceNum; ++i) {
            String path = DataNodeDevicePathCache.getInstance().getDeviceId(ReadWriteIOUtils.readString((InputStream)inputStream));
            ReadWriteIOUtils.skip((InputStream)inputStream, (long)4L);
            devices.add((IDeviceID)new PlainDeviceID(path));
        }
        return devices;
    }

    @Override
    public boolean endTimeEmpty() {
        for (long endTime : this.endTimes) {
            if (endTime == Long.MIN_VALUE) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean stillLives(long ttlLowerBound) {
        if (ttlLowerBound == Long.MAX_VALUE) {
            return true;
        }
        for (long endTime : this.endTimes) {
            if (endTime < ttlLowerBound) continue;
            return true;
        }
        return false;
    }

    @Override
    public long calculateRamSize() {
        return INSTANCE_SIZE + RamUsageEstimator.sizeOfMap(this.deviceToIndex, (long)RamUsageEstimator.shallowSizeOfInstance(Integer.class)) + RamUsageEstimator.sizeOf((long[])this.startTimes) + RamUsageEstimator.sizeOf((long[])this.endTimes);
    }

    private int getDeviceIndex(IDeviceID deviceId) {
        int index;
        if (this.deviceToIndex.containsKey(deviceId)) {
            index = this.deviceToIndex.get(deviceId);
        } else {
            index = this.deviceToIndex.size();
            this.deviceToIndex.put(deviceId, index);
            if (this.startTimes.length <= index) {
                this.startTimes = this.enLargeArray(this.startTimes, Long.MAX_VALUE);
                this.endTimes = this.enLargeArray(this.endTimes, Long.MIN_VALUE);
            }
        }
        return index;
    }

    private void initTimes(long[] times, long defaultTime) {
        Arrays.fill(times, defaultTime);
    }

    private long[] enLargeArray(long[] array, long defaultValue) {
        long[] tmp = new long[array.length * 2];
        this.initTimes(tmp, defaultValue);
        System.arraycopy(array, 0, tmp, 0, array.length);
        return tmp;
    }

    @Override
    public long getTimePartition(String tsFilePath) {
        try {
            if (this.deviceToIndex != null && !this.deviceToIndex.isEmpty()) {
                return TimePartitionUtils.getTimePartitionId((long)this.startTimes[this.deviceToIndex.values().iterator().next()]);
            }
            String[] filePathSplits = FilePathUtils.splitTsFilePath((String)tsFilePath);
            return Long.parseLong(filePathSplits[filePathSplits.length - 2]);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    @Override
    public long getTimePartitionWithCheck(String tsFilePath) throws PartitionViolationException {
        try {
            return this.getTimePartitionWithCheck();
        }
        catch (PartitionViolationException e) {
            throw new PartitionViolationException(tsFilePath);
        }
    }

    @Override
    public boolean isSpanMultiTimePartitions() {
        try {
            this.getTimePartitionWithCheck();
            return false;
        }
        catch (PartitionViolationException e) {
            return true;
        }
    }

    private long getTimePartitionWithCheck() throws PartitionViolationException {
        Long partitionId = null;
        for (int index : this.deviceToIndex.values()) {
            long endTimePartitionId;
            long startTimePartitionId = TimePartitionUtils.getTimePartitionId((long)this.startTimes[index]);
            if (startTimePartitionId != (endTimePartitionId = TimePartitionUtils.getTimePartitionId((long)this.endTimes[index]))) {
                throw new PartitionViolationException();
            }
            if (partitionId == null) {
                partitionId = startTimePartitionId;
                continue;
            }
            if (partitionId == startTimePartitionId) continue;
            throw new PartitionViolationException();
        }
        if (partitionId == null) {
            throw new PartitionViolationException();
        }
        return partitionId;
    }

    @Override
    public void updateStartTime(IDeviceID deviceId, long time) {
        long startTime = this.getStartTime(deviceId);
        if (time < startTime) {
            int index = this.getDeviceIndex(deviceId);
            this.startTimes[index] = time;
        }
        this.minStartTime = Math.min(this.minStartTime, time);
    }

    @Override
    public void updateEndTime(IDeviceID deviceId, long time) {
        long endTime = this.getEndTime(deviceId);
        if (time > endTime) {
            int index = this.getDeviceIndex(deviceId);
            this.endTimes[index] = time;
        }
        this.maxEndTime = Math.max(this.maxEndTime, time);
    }

    @Override
    public void putStartTime(IDeviceID deviceId, long time) {
        int index = this.getDeviceIndex(deviceId);
        this.startTimes[index] = time;
        this.minStartTime = Math.min(this.minStartTime, time);
    }

    @Override
    public void putEndTime(IDeviceID deviceId, long time) {
        int index = this.getDeviceIndex(deviceId);
        this.endTimes[index] = time;
        this.maxEndTime = Math.max(this.maxEndTime, time);
    }

    @Override
    public long getStartTime(IDeviceID deviceId) {
        if (!this.deviceToIndex.containsKey(deviceId)) {
            return Long.MAX_VALUE;
        }
        return this.startTimes[this.deviceToIndex.get(deviceId)];
    }

    @Override
    public long getEndTime(IDeviceID deviceId) {
        if (!this.deviceToIndex.containsKey(deviceId)) {
            return Long.MIN_VALUE;
        }
        return this.endTimes[this.deviceToIndex.get(deviceId)];
    }

    @Override
    public boolean checkDeviceIdExist(IDeviceID deviceId) {
        return this.deviceToIndex.containsKey(deviceId);
    }

    @Override
    public long getMinStartTime() {
        return this.minStartTime;
    }

    @Override
    public long getMaxEndTime() {
        return this.maxEndTime;
    }

    @Override
    public int compareDegradePriority(ITimeIndex timeIndex) {
        if (timeIndex instanceof DeviceTimeIndex) {
            return Long.compare(this.getMinStartTime(), timeIndex.getMinStartTime());
        }
        if (timeIndex instanceof FileTimeIndex) {
            return -1;
        }
        logger.error("Wrong timeIndex type {}", (Object)timeIndex.getClass().getName());
        throw new RuntimeException("Wrong timeIndex type " + timeIndex.getClass().getName());
    }

    @Override
    public boolean definitelyNotContains(IDeviceID device) {
        return !this.deviceToIndex.containsKey(device);
    }

    @Override
    public long[] getStartAndEndTime(IDeviceID deviceId) {
        Integer index = this.deviceToIndex.get(deviceId);
        if (index == null) {
            return null;
        }
        int i = index;
        return new long[]{this.startTimes[i], this.endTimes[i]};
    }

    @Override
    public Pair<Long, Long> getPossibleStartTimeAndEndTime(PartialPath devicePattern, Set<IDeviceID> deviceMatchInfo) {
        boolean hasMatchedDevice = false;
        long startTime = Long.MAX_VALUE;
        long endTime = Long.MIN_VALUE;
        for (Map.Entry<IDeviceID, Integer> entry : this.deviceToIndex.entrySet()) {
            try {
                if (deviceMatchInfo.contains(entry.getKey())) {
                    hasMatchedDevice = true;
                    if (this.startTimes[entry.getValue()] < startTime) {
                        startTime = this.startTimes[entry.getValue()];
                    }
                    if (this.endTimes[entry.getValue()] <= endTime) continue;
                    endTime = this.endTimes[entry.getValue()];
                    continue;
                }
                if (!devicePattern.matchFullPath(DataNodeDevicePathCache.getInstance().getPartialPath(((PlainDeviceID)entry.getKey()).toStringID()))) continue;
                deviceMatchInfo.add(entry.getKey());
                hasMatchedDevice = true;
                if (this.startTimes[entry.getValue()] < startTime) {
                    startTime = this.startTimes[entry.getValue()];
                }
                if (this.endTimes[entry.getValue()] <= endTime) continue;
                endTime = this.endTimes[entry.getValue()];
            }
            catch (IllegalPathException illegalPathException) {}
        }
        return hasMatchedDevice ? new Pair((Object)startTime, (Object)endTime) : null;
    }

    @Override
    public byte getTimeIndexType() {
        return 1;
    }
}

