/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.read.reader.chunk.MemPageReader;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPageReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;

public class MemChunkReader
implements IChunkReader,
IPointReader {
    private final IPointReader timeValuePairIterator;
    private final Filter globalTimeFilter;
    private final List<IPageReader> pageReaderList;
    private boolean hasCachedTimeValuePair;
    private TimeValuePair cachedTimeValuePair;

    public MemChunkReader(ReadOnlyMemChunk readableChunk, Filter globalTimeFilter) {
        this.timeValuePairIterator = readableChunk.getPointReader();
        this.globalTimeFilter = globalTimeFilter;
        this.pageReaderList = Collections.singletonList(new MemPageReader(readableChunk.getTsBlock(), readableChunk.getChunkMetaData(), globalTimeFilter));
    }

    public boolean hasNextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            return true;
        }
        while (this.timeValuePairIterator.hasNextTimeValuePair()) {
            TimeValuePair timeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            if (this.globalTimeFilter != null && !this.globalTimeFilter.satisfy(timeValuePair.getTimestamp(), timeValuePair.getValue().getValue())) continue;
            this.hasCachedTimeValuePair = true;
            this.cachedTimeValuePair = timeValuePair;
            break;
        }
        return this.hasCachedTimeValuePair;
    }

    public TimeValuePair nextTimeValuePair() throws IOException {
        if (this.hasCachedTimeValuePair) {
            this.hasCachedTimeValuePair = false;
            return this.cachedTimeValuePair;
        }
        return this.timeValuePairIterator.nextTimeValuePair();
    }

    public TimeValuePair currentTimeValuePair() throws IOException {
        if (!this.hasCachedTimeValuePair) {
            this.cachedTimeValuePair = this.timeValuePairIterator.nextTimeValuePair();
            this.hasCachedTimeValuePair = true;
        }
        return this.cachedTimeValuePair;
    }

    public boolean hasNextSatisfiedPage() throws IOException {
        return this.hasNextTimeValuePair();
    }

    public BatchData nextPageData() throws IOException {
        return this.pageReaderList.remove(0).getAllSatisfiedPageData();
    }

    public long getUsedMemorySize() {
        return this.timeValuePairIterator.getUsedMemorySize();
    }

    public void close() {
    }

    public List<IPageReader> loadPageReaderList() {
        return this.pageReaderList;
    }
}

