/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.memtable;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.service.metric.PerformanceOverviewMetrics;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.pipe.agent.PipeAgent;
import org.apache.iotdb.db.pipe.extractor.dataregion.realtime.listener.PipeInsertionDataNodeListener;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.QueryExecutionMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryResourceMetricSet;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.DeleteDataNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.ResourceByPathUtils;
import org.apache.iotdb.db.service.metrics.WritingMetrics;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.DataRegionInfo;
import org.apache.iotdb.db.storageengine.dataregion.flush.CloseFileListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.CompressionRatio;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushListener;
import org.apache.iotdb.db.storageengine.dataregion.flush.FlushManager;
import org.apache.iotdb.db.storageengine.dataregion.flush.MemTableFlushTask;
import org.apache.iotdb.db.storageengine.dataregion.flush.NotifyFlushMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.AlignedWritableMemChunkGroup;
import org.apache.iotdb.db.storageengine.dataregion.memtable.IMemTable;
import org.apache.iotdb.db.storageengine.dataregion.memtable.ReadOnlyMemChunk;
import org.apache.iotdb.db.storageengine.dataregion.memtable.TsFileProcessorInfo;
import org.apache.iotdb.db.storageengine.dataregion.modification.Deletion;
import org.apache.iotdb.db.storageengine.dataregion.modification.Modification;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.wal.WALManager;
import org.apache.iotdb.db.storageengine.dataregion.wal.node.IWALNode;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.AbstractResultListener;
import org.apache.iotdb.db.storageengine.dataregion.wal.utils.listener.WALFlushListener;
import org.apache.iotdb.db.storageengine.rescon.memory.MemTableManager;
import org.apache.iotdb.db.storageengine.rescon.memory.PrimitiveArrayManager;
import org.apache.iotdb.db.storageengine.rescon.memory.SystemInfo;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessor {
    private static final Logger logger = LoggerFactory.getLogger(TsFileProcessor.class);
    private final String storageGroupName;
    private final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final DataRegionInfo dataRegionInfo;
    private TsFileProcessorInfo tsFileProcessorInfo;
    private final ConcurrentLinkedDeque<IMemTable> flushingMemTables = new ConcurrentLinkedDeque();
    private final List<Pair<Modification, IMemTable>> modsToMemtable = new ArrayList<Pair<Modification, IMemTable>>();
    private RestorableTsFileIOWriter writer;
    private final TsFileResource tsFileResource;
    private long timeRangeId;
    private volatile boolean managedByFlushManager;
    private final ReadWriteLock flushQueryLock = new ReentrantReadWriteLock();
    private volatile boolean shouldClose;
    private IMemTable workMemTable;
    private long lastWorkMemtableFlushTime;
    private final DataRegion.UpdateEndTimeCallBack updateLatestFlushTimeCallback;
    private final IWALNode walNode;
    private final boolean sequence;
    private long totalMemTableSize;
    private static final String FLUSH_QUERY_WRITE_LOCKED = "{}: {} get flushQueryLock write lock";
    private static final String FLUSH_QUERY_WRITE_RELEASE = "{}: {} get flushQueryLock write lock released";
    private final List<CloseFileListener> closeFileListeners = new CopyOnWriteArrayList<CloseFileListener>();
    private final List<FlushListener> flushListeners = new ArrayList<FlushListener>();
    private final QueryExecutionMetricSet QUERY_EXECUTION_METRICS = QueryExecutionMetricSet.getInstance();
    private final QueryResourceMetricSet QUERY_RESOURCE_METRICS = QueryResourceMetricSet.getInstance();
    private static final PerformanceOverviewMetrics PERFORMANCE_OVERVIEW_METRICS = PerformanceOverviewMetrics.getInstance();

    public TsFileProcessor(String storageGroupName, File tsfile, DataRegionInfo dataRegionInfo, CloseFileListener closeTsFileCallback, DataRegion.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence) throws IOException {
        this.storageGroupName = storageGroupName;
        this.sequence = sequence;
        this.tsFileResource = new TsFileResource(tsfile, this);
        this.dataRegionInfo = dataRegionInfo;
        this.writer = new RestorableTsFileIOWriter(tsfile);
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.walNode = WALManager.getInstance().applyForWALNode(WALManager.getApplicantUniqueId(storageGroupName, sequence));
        this.flushListeners.add(FlushListener.DefaultMemTableFLushListener.INSTANCE);
        this.flushListeners.add(this.walNode);
        this.closeFileListeners.add(closeTsFileCallback);
        logger.info("create a new tsfile processor {}", (Object)tsfile.getAbsolutePath());
    }

    public TsFileProcessor(String storageGroupName, DataRegionInfo dataRegionInfo, TsFileResource tsFileResource, CloseFileListener closeUnsealedTsFileProcessor, DataRegion.UpdateEndTimeCallBack updateLatestFlushTimeCallback, boolean sequence, RestorableTsFileIOWriter writer) {
        this.storageGroupName = storageGroupName;
        this.tsFileResource = tsFileResource;
        this.dataRegionInfo = dataRegionInfo;
        this.writer = writer;
        this.updateLatestFlushTimeCallback = updateLatestFlushTimeCallback;
        this.sequence = sequence;
        this.walNode = WALManager.getInstance().applyForWALNode(WALManager.getApplicantUniqueId(storageGroupName, sequence));
        this.flushListeners.add(FlushListener.DefaultMemTableFLushListener.INSTANCE);
        this.flushListeners.add(this.walNode);
        this.closeFileListeners.add(closeUnsealedTsFileProcessor);
        logger.info("reopen a tsfile processor {}", (Object)tsFileResource.getTsFile());
    }

    public void insert(InsertRowNode insertRowNode, long[] costsForMetrics) throws WriteProcessException {
        WALFlushListener walFlushListener;
        if (this.workMemTable == null) {
            long startTime = System.nanoTime();
            this.createNewWorkingMemTable();
            costsForMetrics[0] = costsForMetrics[0] + (System.nanoTime() - startTime);
            WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionId(), 1);
        }
        long memControlStartTime = System.nanoTime();
        long[] memIncrements = insertRowNode.isAligned() ? this.checkAlignedMemCostAndAddToTspInfoForRow(insertRowNode.getDeviceID(), insertRowNode.getMeasurements(), insertRowNode.getDataTypes(), insertRowNode.getValues()) : this.checkMemCostAndAddToTspInfoForRow(insertRowNode.getDeviceID(), insertRowNode.getMeasurements(), insertRowNode.getDataTypes(), insertRowNode.getValues());
        costsForMetrics[1] = costsForMetrics[1] + (System.nanoTime() - memControlStartTime);
        long startTime = System.nanoTime();
        try {
            walFlushListener = this.walNode.log(this.workMemTable.getMemTableId(), insertRowNode);
            if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                throw walFlushListener.getCause();
            }
        }
        catch (Exception e) {
            this.rollbackMemoryInfo(memIncrements);
            throw new WriteProcessException(String.format("%s: %s write WAL failed", this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath()), e);
        }
        finally {
            costsForMetrics[2] = costsForMetrics[2] + (System.nanoTime() - startTime);
        }
        startTime = System.nanoTime();
        PipeAgent.runtime().assignSimpleProgressIndexIfNeeded(insertRowNode);
        if (!insertRowNode.isGeneratedByPipe()) {
            this.workMemTable.markAsNotGeneratedByPipe();
        }
        PipeInsertionDataNodeListener.getInstance().listenToInsertNode(this.dataRegionInfo.getDataRegion().getDataRegionId(), walFlushListener.getWalEntryHandler(), insertRowNode, this.tsFileResource);
        if (insertRowNode.isAligned()) {
            this.workMemTable.insertAlignedRow(insertRowNode);
        } else {
            this.workMemTable.insert(insertRowNode);
        }
        this.tsFileResource.updateStartTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
        }
        this.tsFileResource.updateProgressIndex(insertRowNode.getProgressIndex());
        costsForMetrics[3] = costsForMetrics[3] + (System.nanoTime() - startTime);
    }

    public void insert(InsertRowsNode insertRowsNode, long[] costsForMetrics) throws WriteProcessException {
        WALFlushListener walFlushListener;
        if (this.workMemTable == null) {
            long startTime = System.nanoTime();
            this.createNewWorkingMemTable();
            costsForMetrics[0] = costsForMetrics[0] + (System.nanoTime() - startTime);
            WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionId(), 1);
        }
        long memControlStartTime = System.nanoTime();
        long[] memIncrements = insertRowsNode.isAligned() ? this.checkAlignedMemCostAndAddToTspInfoForRows(insertRowsNode) : this.checkMemCostAndAddToTspInfoForRows(insertRowsNode);
        costsForMetrics[1] = costsForMetrics[1] + (System.nanoTime() - memControlStartTime);
        long startTime = System.nanoTime();
        try {
            walFlushListener = this.walNode.log(this.workMemTable.getMemTableId(), insertRowsNode);
            if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                throw walFlushListener.getCause();
            }
        }
        catch (Exception e) {
            this.rollbackMemoryInfo(memIncrements);
            throw new WriteProcessException(String.format("%s: %s write WAL failed", this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath()), e);
        }
        finally {
            costsForMetrics[2] = costsForMetrics[2] + (System.nanoTime() - startTime);
        }
        startTime = System.nanoTime();
        PipeAgent.runtime().assignSimpleProgressIndexIfNeeded(insertRowsNode);
        if (!insertRowsNode.isGeneratedByPipe()) {
            this.workMemTable.markAsNotGeneratedByPipe();
        }
        PipeInsertionDataNodeListener.getInstance().listenToInsertNode(this.dataRegionInfo.getDataRegion().getDataRegionId(), walFlushListener.getWalEntryHandler(), insertRowsNode, this.tsFileResource);
        for (InsertRowNode insertRowNode : insertRowsNode.getInsertRowNodeList()) {
            if (insertRowNode.isAligned()) {
                this.workMemTable.insertAlignedRow(insertRowNode);
            } else {
                this.workMemTable.insert(insertRowNode);
            }
            this.tsFileResource.updateStartTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
            if (this.sequence) continue;
            this.tsFileResource.updateEndTime(insertRowNode.getDeviceID(), insertRowNode.getTime());
        }
        this.tsFileResource.updateProgressIndex(insertRowsNode.getProgressIndex());
        costsForMetrics[3] = costsForMetrics[3] + (System.nanoTime() - startTime);
    }

    private void createNewWorkingMemTable() {
        this.workMemTable = MemTableManager.getInstance().getAvailableMemTable(this.dataRegionInfo.getDataRegion().getDatabaseName(), this.dataRegionInfo.getDataRegion().getDataRegionId());
        this.walNode.onMemTableCreated(this.workMemTable, this.tsFileResource.getTsFilePath());
    }

    public void insertTablet(InsertTabletNode insertTabletNode, int start, int end, TSStatus[] results) throws WriteProcessException {
        WALFlushListener walFlushListener;
        long[] memIncrements;
        long startTime;
        if (this.workMemTable == null) {
            long startTime2 = System.nanoTime();
            this.createNewWorkingMemTable();
            PERFORMANCE_OVERVIEW_METRICS.recordCreateMemtableBlockCost(System.nanoTime() - startTime2);
            WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionId(), 1);
        }
        try {
            startTime = System.nanoTime();
            memIncrements = insertTabletNode.isAligned() ? this.checkAlignedMemCostAndAddToTspForTablet(insertTabletNode.getDeviceID(), insertTabletNode.getMeasurements(), insertTabletNode.getDataTypes(), insertTabletNode.getColumns(), start, end) : this.checkMemCostAndAddToTspInfoForTablet(insertTabletNode.getDeviceID(), insertTabletNode.getMeasurements(), insertTabletNode.getDataTypes(), insertTabletNode.getColumns(), start, end);
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemoryBlockCost(System.nanoTime() - startTime);
        }
        catch (WriteProcessException e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.WRITE_PROCESS_REJECT, (String)e.getMessage());
            }
            throw new WriteProcessException((Exception)((Object)e));
        }
        startTime = System.nanoTime();
        try {
            walFlushListener = this.walNode.log(this.workMemTable.getMemTableId(), insertTabletNode, start, end);
            if (walFlushListener.waitForResult() == AbstractResultListener.Status.FAILURE) {
                throw walFlushListener.getCause();
            }
        }
        catch (Exception e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            }
            this.rollbackMemoryInfo(memIncrements);
            throw new WriteProcessException(e);
        }
        finally {
            PERFORMANCE_OVERVIEW_METRICS.recordScheduleWalCost(System.nanoTime() - startTime);
        }
        startTime = System.nanoTime();
        PipeAgent.runtime().assignSimpleProgressIndexIfNeeded(insertTabletNode);
        if (!insertTabletNode.isGeneratedByPipe()) {
            this.workMemTable.markAsNotGeneratedByPipe();
        }
        PipeInsertionDataNodeListener.getInstance().listenToInsertNode(this.dataRegionInfo.getDataRegion().getDataRegionId(), walFlushListener.getWalEntryHandler(), insertTabletNode, this.tsFileResource);
        try {
            if (insertTabletNode.isAligned()) {
                this.workMemTable.insertAlignedTablet(insertTabletNode, start, end);
            } else {
                this.workMemTable.insertTablet(insertTabletNode, start, end);
            }
        }
        catch (WriteProcessException e) {
            for (int i = start; i < end; ++i) {
                results[i] = RpcUtils.getStatus((TSStatusCode)TSStatusCode.INTERNAL_SERVER_ERROR, (String)e.getMessage());
            }
            throw new WriteProcessException((Exception)((Object)e));
        }
        for (int i = start; i < end; ++i) {
            results[i] = RpcUtils.SUCCESS_STATUS;
        }
        this.tsFileResource.updateStartTime(insertTabletNode.getDeviceID(), insertTabletNode.getTimes()[start]);
        if (!this.sequence) {
            this.tsFileResource.updateEndTime(insertTabletNode.getDeviceID(), insertTabletNode.getTimes()[end - 1]);
        }
        this.tsFileResource.updateProgressIndex(insertTabletNode.getProgressIndex());
        PERFORMANCE_OVERVIEW_METRICS.recordScheduleMemTableCost(System.nanoTime() - startTime);
    }

    private long[] checkMemCostAndAddToTspInfoForRow(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] values) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        for (int i = 0; i < dataTypes.length; ++i) {
            if (dataTypes[i] == null || measurements[i] == null) continue;
            if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, measurements[i])) {
                chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)measurements[i], (TSDataType)dataTypes[i]);
                memTableIncrement += TVList.tvListArrayMemCost(dataTypes[i]);
            } else {
                long currentChunkPointNum = this.workMemTable.getCurrentTVListSize(deviceId, measurements[i]);
                memTableIncrement += currentChunkPointNum % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L ? TVList.tvListArrayMemCost(dataTypes[i]) : 0L;
            }
            if (dataTypes[i] != TSDataType.TEXT || values[i] == null) continue;
            textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkMemCostAndAddToTspInfoForRows(InsertRowsNode insertRowsNode) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        HashMap<IDeviceID, Map> increasingMemTableInfo = new HashMap<IDeviceID, Map>();
        for (InsertRowNode insertRowNode : insertRowsNode.getInsertRowNodeList()) {
            IDeviceID deviceId = insertRowNode.getDeviceID();
            TSDataType[] dataTypes = insertRowNode.getDataTypes();
            Object[] values = insertRowNode.getValues();
            String[] measurements = insertRowNode.getMeasurements();
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null) continue;
                if (!(!this.workMemTable.checkIfChunkDoesNotExist(deviceId, measurements[i]) || increasingMemTableInfo.containsKey(deviceId) && ((Map)increasingMemTableInfo.get(deviceId)).containsKey(measurements[i]))) {
                    chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)measurements[i], (TSDataType)dataTypes[i]);
                    memTableIncrement += TVList.tvListArrayMemCost(dataTypes[i]);
                    increasingMemTableInfo.computeIfAbsent(deviceId, k -> new HashMap()).putIfAbsent(measurements[i], 1);
                } else {
                    int addingPointNum;
                    long currentChunkPointNum = this.workMemTable.getCurrentTVListSize(deviceId, measurements[i]);
                    memTableIncrement += (currentChunkPointNum + (long)(addingPointNum = increasingMemTableInfo.computeIfAbsent(deviceId, k -> new HashMap()).computeIfAbsent(measurements[i], k -> 0).intValue())) % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L ? TVList.tvListArrayMemCost(dataTypes[i]) : 0L;
                    ((Map)increasingMemTableInfo.get(deviceId)).computeIfPresent(measurements[i], (k, v) -> v + 1);
                }
                if (dataTypes[i] != TSDataType.TEXT || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkAlignedMemCostAndAddToTspInfoForRow(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] values) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, "")) {
            chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)"", (TSDataType)TSDataType.VECTOR) * (long)dataTypes.length;
            memTableIncrement += AlignedTVList.alignedTvListArrayMemCost(dataTypes);
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null || dataTypes[i] != TSDataType.TEXT || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
        } else {
            AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)this.workMemTable.getMemTableMap().get(deviceId)).getAlignedMemChunk();
            ArrayList<TSDataType> dataTypesInTVList = new ArrayList<TSDataType>();
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null) continue;
                if (!alignedMemChunk.containsMeasurement(measurements[i])) {
                    memTableIncrement += (alignedMemChunk.alignedListSize() / (long)PrimitiveArrayManager.ARRAY_SIZE + 1L) * AlignedTVList.valueListArrayMemCost(dataTypes[i]);
                    dataTypesInTVList.add(dataTypes[i]);
                }
                if (dataTypes[i] != TSDataType.TEXT || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
            if (alignedMemChunk.alignedListSize() % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L) {
                dataTypesInTVList.addAll(((AlignedTVList)alignedMemChunk.getTVList()).getTsDataTypes());
                memTableIncrement += AlignedTVList.alignedTvListArrayMemCost(dataTypesInTVList);
            }
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkAlignedMemCostAndAddToTspInfoForRows(InsertRowsNode insertRowsNode) throws WriteProcessException {
        long memTableIncrement = 0L;
        long textDataIncrement = 0L;
        long chunkMetadataIncrement = 0L;
        HashMap<IDeviceID, Pair> increasingMemTableInfo = new HashMap<IDeviceID, Pair>();
        for (InsertRowNode insertRowNode : insertRowsNode.getInsertRowNodeList()) {
            IDeviceID deviceId = insertRowNode.getDeviceID();
            TSDataType[] dataTypes = insertRowNode.getDataTypes();
            Object[] values = insertRowNode.getValues();
            String[] measurements = insertRowNode.getMeasurements();
            if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, "") && !increasingMemTableInfo.containsKey(deviceId)) {
                chunkMetadataIncrement += ChunkMetadata.calculateRamSize((String)"", (TSDataType)TSDataType.VECTOR) * (long)dataTypes.length;
                memTableIncrement += AlignedTVList.alignedTvListArrayMemCost(dataTypes);
                for (int i = 0; i < dataTypes.length; ++i) {
                    if (dataTypes[i] == null || measurements[i] == null) continue;
                    ((Map)increasingMemTableInfo.computeIfAbsent(deviceId, (Function<IDeviceID, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$checkAlignedMemCostAndAddToTspInfoForRows$4(org.apache.iotdb.tsfile.file.metadata.IDeviceID ), (Lorg/apache/iotdb/tsfile/file/metadata/IDeviceID;)Lorg/apache/iotdb/tsfile/utils/Pair;)()).left).put(measurements[i], dataTypes[i]);
                    if (dataTypes[i] != TSDataType.TEXT || values[i] == null) continue;
                    textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
                }
                continue;
            }
            AlignedWritableMemChunkGroup memChunkGroup = (AlignedWritableMemChunkGroup)this.workMemTable.getMemTableMap().get(deviceId);
            AlignedWritableMemChunk alignedMemChunk = memChunkGroup == null ? null : memChunkGroup.getAlignedMemChunk();
            long currentChunkPointNum = alignedMemChunk == null ? 0L : alignedMemChunk.alignedListSize();
            ArrayList<TSDataType> dataTypesInTVList = new ArrayList<TSDataType>();
            Pair addingPointNumInfo = increasingMemTableInfo.computeIfAbsent(deviceId, k -> new Pair(new HashMap(), (Object)0));
            for (int i = 0; i < dataTypes.length; ++i) {
                if (dataTypes[i] == null || measurements[i] == null) continue;
                int addingPointNum = (Integer)addingPointNumInfo.getRight();
                if (alignedMemChunk != null && !alignedMemChunk.containsMeasurement(measurements[i]) && !((Map)((Pair)increasingMemTableInfo.get((Object)deviceId)).left).containsKey(measurements[i])) {
                    memTableIncrement += ((currentChunkPointNum + (long)addingPointNum) / (long)PrimitiveArrayManager.ARRAY_SIZE + 1L) * AlignedTVList.valueListArrayMemCost(dataTypes[i]);
                    ((Map)((Pair)increasingMemTableInfo.get((Object)deviceId)).left).put(measurements[i], dataTypes[i]);
                }
                if (dataTypes[i] != TSDataType.TEXT || values[i] == null) continue;
                textDataIncrement += MemUtils.getBinarySize((Binary)values[i]);
            }
            int addingPointNum = (Integer)((Pair)increasingMemTableInfo.get(deviceId)).getRight();
            if ((currentChunkPointNum + (long)addingPointNum) % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L) {
                if (alignedMemChunk != null) {
                    dataTypesInTVList.addAll(((AlignedTVList)alignedMemChunk.getTVList()).getTsDataTypes());
                }
                dataTypesInTVList.addAll(((Map)((Pair)increasingMemTableInfo.get(deviceId)).getLeft()).values());
                memTableIncrement += AlignedTVList.alignedTvListArrayMemCost(dataTypesInTVList);
            }
            ((Pair)increasingMemTableInfo.get(deviceId)).setRight((Object)(addingPointNum + 1));
        }
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return new long[]{memTableIncrement, textDataIncrement, chunkMetadataIncrement};
    }

    private long[] checkMemCostAndAddToTspInfoForTablet(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] columns, int start, int end) throws WriteProcessException {
        if (start >= end) {
            return new long[]{0L, 0L, 0L};
        }
        long[] memIncrements = new long[3];
        for (int i = 0; i < dataTypes.length; ++i) {
            if (dataTypes[i] == null || columns[i] == null || measurements[i] == null) continue;
            this.updateMemCost(dataTypes[i], measurements[i], deviceId, start, end, memIncrements, columns[i]);
        }
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return memIncrements;
    }

    private long[] checkAlignedMemCostAndAddToTspForTablet(IDeviceID deviceId, String[] measurements, TSDataType[] dataTypes, Object[] columns, int start, int end) throws WriteProcessException {
        if (start >= end) {
            return new long[]{0L, 0L, 0L};
        }
        long[] memIncrements = new long[3];
        this.updateAlignedMemCost(dataTypes, deviceId, measurements, start, end, memIncrements, columns);
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.updateMemoryInfo(memTableIncrement, chunkMetadataIncrement, textDataIncrement);
        return memIncrements;
    }

    private void updateMemCost(TSDataType dataType, String measurement, IDeviceID deviceId, int start, int end, long[] memIncrements, Object column) {
        if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, measurement)) {
            memIncrements[2] = memIncrements[2] + ChunkMetadata.calculateRamSize((String)measurement, (TSDataType)dataType);
            memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * TVList.tvListArrayMemCost(dataType);
        } else {
            long currentChunkPointNum = this.workMemTable.getCurrentTVListSize(deviceId, measurement);
            if (currentChunkPointNum % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L) {
                memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * TVList.tvListArrayMemCost(dataType);
            } else {
                long acquireArray = ((long)(end - start - 1) + currentChunkPointNum % (long)PrimitiveArrayManager.ARRAY_SIZE) / (long)PrimitiveArrayManager.ARRAY_SIZE;
                if (acquireArray != 0L) {
                    memIncrements[0] = memIncrements[0] + acquireArray * TVList.tvListArrayMemCost(dataType);
                }
            }
        }
        if (dataType == TSDataType.TEXT) {
            Binary[] binColumn = (Binary[])column;
            memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
        }
    }

    private void updateAlignedMemCost(TSDataType[] dataTypes, IDeviceID deviceId, String[] measurementIds, int start, int end, long[] memIncrements, Object[] columns) {
        if (this.workMemTable.checkIfChunkDoesNotExist(deviceId, "")) {
            memIncrements[2] = memIncrements[2] + (long)dataTypes.length * ChunkMetadata.calculateRamSize((String)"", (TSDataType)TSDataType.VECTOR);
            memIncrements[0] = memIncrements[0] + (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE + 1) * AlignedTVList.alignedTvListArrayMemCost(dataTypes);
            for (int i = 0; i < dataTypes.length; ++i) {
                TSDataType dataType = dataTypes[i];
                String measurement = measurementIds[i];
                Object column = columns[i];
                if (dataType == null || column == null || measurement == null || dataType != TSDataType.TEXT) continue;
                Binary[] binColumn = (Binary[])columns[i];
                memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
            }
        } else {
            AlignedWritableMemChunk alignedMemChunk = ((AlignedWritableMemChunkGroup)this.workMemTable.getMemTableMap().get(deviceId)).getAlignedMemChunk();
            ArrayList<TSDataType> dataTypesInTVList = new ArrayList<TSDataType>();
            for (int i = 0; i < dataTypes.length; ++i) {
                TSDataType dataType = dataTypes[i];
                String measurement = measurementIds[i];
                Object column = columns[i];
                if (dataType == null || column == null || measurement == null) continue;
                if (!alignedMemChunk.containsMeasurement(measurementIds[i])) {
                    memIncrements[0] = memIncrements[0] + (alignedMemChunk.alignedListSize() / (long)PrimitiveArrayManager.ARRAY_SIZE + 1L) * AlignedTVList.valueListArrayMemCost(dataType);
                    dataTypesInTVList.add(dataType);
                }
                if (dataType != TSDataType.TEXT) continue;
                Binary[] binColumn = (Binary[])columns[i];
                memIncrements[1] = memIncrements[1] + MemUtils.getBinaryColumnSize(binColumn, start, end);
            }
            long acquireArray = alignedMemChunk.alignedListSize() % (long)PrimitiveArrayManager.ARRAY_SIZE == 0L ? (long)((end - start) / PrimitiveArrayManager.ARRAY_SIZE) + 1L : ((long)(end - start - 1) + alignedMemChunk.alignedListSize() % (long)PrimitiveArrayManager.ARRAY_SIZE) / (long)PrimitiveArrayManager.ARRAY_SIZE;
            if (acquireArray != 0L) {
                dataTypesInTVList.addAll(((AlignedTVList)alignedMemChunk.getTVList()).getTsDataTypes());
                memIncrements[0] = memIncrements[0] + acquireArray * AlignedTVList.alignedTvListArrayMemCost(dataTypesInTVList);
            }
        }
    }

    private void updateMemoryInfo(long memTableIncrement, long chunkMetadataIncrement, long textDataIncrement) throws WriteProcessRejectException {
        this.dataRegionInfo.addStorageGroupMemCost(memTableIncrement += textDataIncrement);
        this.tsFileProcessorInfo.addTSPMemCost(chunkMetadataIncrement);
        if (this.dataRegionInfo.needToReportToSystem()) {
            try {
                if (!SystemInfo.getInstance().reportStorageGroupStatus(this.dataRegionInfo, this)) {
                    StorageEngine.blockInsertionIfReject(this);
                }
            }
            catch (WriteProcessRejectException e) {
                this.dataRegionInfo.releaseStorageGroupMemCost(memTableIncrement);
                this.tsFileProcessorInfo.releaseTSPMemCost(chunkMetadataIncrement);
                SystemInfo.getInstance().resetStorageGroupStatus(this.dataRegionInfo);
                throw e;
            }
        }
        this.workMemTable.addTVListRamCost(memTableIncrement);
        this.workMemTable.addTextDataSize(textDataIncrement);
    }

    private void rollbackMemoryInfo(long[] memIncrements) {
        long memTableIncrement = memIncrements[0];
        long textDataIncrement = memIncrements[1];
        long chunkMetadataIncrement = memIncrements[2];
        this.dataRegionInfo.releaseStorageGroupMemCost(memTableIncrement += textDataIncrement);
        this.tsFileProcessorInfo.releaseTSPMemCost(chunkMetadataIncrement);
        SystemInfo.getInstance().resetStorageGroupStatus(this.dataRegionInfo);
        this.workMemTable.releaseTVListRamCost(memTableIncrement);
        this.workMemTable.releaseTextDataSize(textDataIncrement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataInMemory(Deletion deletion, Set<PartialPath> devicePaths) {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            if (this.workMemTable != null) {
                logger.info("[Deletion] Deletion with path: {}, time:{}-{} in workMemTable", new Object[]{deletion.getPath(), deletion.getStartTime(), deletion.getEndTime()});
                for (PartialPath device : devicePaths) {
                    this.workMemTable.delete(deletion.getPath(), device, deletion.getStartTime(), deletion.getEndTime());
                }
            }
            if (!this.flushingMemTables.isEmpty()) {
                this.modsToMemtable.add((Pair<Modification, IMemTable>)new Pair((Object)deletion, (Object)this.flushingMemTables.getLast()));
            }
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    public WALFlushListener logDeleteDataNodeInWAL(DeleteDataNode deleteDataNode) {
        return this.walNode.log(this.workMemTable.getMemTableId(), deleteDataNode);
    }

    public TsFileResource getTsFileResource() {
        return this.tsFileResource;
    }

    public boolean shouldFlush() {
        if (this.workMemTable == null) {
            return false;
        }
        if (this.workMemTable.shouldFlush()) {
            return true;
        }
        if (this.workMemTable.reachTotalPointNumThreshold()) {
            logger.info("The avg series points num {} of tsfile {} reaches the threshold", (Object)(this.workMemTable.getTotalPointsNum() / (long)this.workMemTable.getSeriesNumber()), (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            WritingMetrics.getInstance().recordSeriesFullFlushMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionId(), 1);
            return true;
        }
        return false;
    }

    public boolean shouldClose() {
        long fileSize = this.tsFileResource.getTsFileSize();
        long fileSizeThreshold = this.sequence ? this.config.getSeqTsFileSize() : this.config.getUnSeqTsFileSize();
        return fileSize >= fileSizeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncClose() {
        logger.info("Sync close file: {}, will firstly async close it", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
        if (this.shouldClose) {
            return;
        }
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            try {
                this.asyncClose();
                logger.info("Start to wait until file {} is closed", (Object)this.tsFileResource);
                long startTime = System.currentTimeMillis();
                while (!this.flushingMemTables.isEmpty()) {
                    this.flushingMemTables.wait(60000L);
                    if (System.currentTimeMillis() - startTime <= 60000L || this.flushingMemTables.isEmpty()) continue;
                    logger.warn("{} has spent {}s for waiting flushing one memtable; {} left (first: {}). FlushingManager info: {}", new Object[]{this.tsFileResource.getTsFile().getAbsolutePath(), (System.currentTimeMillis() - startTime) / 1000L, this.flushingMemTables.size(), this.flushingMemTables.getFirst(), FlushManager.getInstance()});
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait close interrupted", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
        logger.info("File {} is closed synchronously", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Future<?> asyncClose() {
        Future<?> future;
        block12: {
            this.flushQueryLock.writeLock().lock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
            if (logger.isDebugEnabled()) {
                if (this.workMemTable != null) {
                    logger.debug("{}: flush a working memtable in async close tsfile {}, memtable size: {}, tsfile size: {}, plan index: [{}, {}], progress index: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), this.workMemTable.memSize(), this.tsFileResource.getTsFileSize(), this.workMemTable.getMinPlanIndex(), this.workMemTable.getMaxPlanIndex(), this.tsFileResource.getMaxProgressIndex()});
                } else {
                    logger.debug("{}: flush a NotifyFlushMemTable in async close tsfile {}, tsfile size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), this.tsFileResource.getTsFileSize()});
                }
            }
            if (!this.shouldClose) break block12;
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            this.flushQueryLock.writeLock().unlock();
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            if (!logger.isDebugEnabled()) return completableFuture;
            logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            return completableFuture;
        }
        IMemTable tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
        try {
            PipeInsertionDataNodeListener.getInstance().listenToTsFile(this.dataRegionInfo.getDataRegion().getDataRegionId(), this.tsFileResource, false, tmpMemTable.isTotallyGeneratedByPipe());
            Future<?> future2 = this.addAMemtableIntoFlushingList(tmpMemTable);
            this.shouldClose = true;
            future = future2;
            this.flushQueryLock.writeLock().unlock();
        }
        catch (Exception e) {
            try {
                logger.error("{}: {} async close failed, because", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                return CompletableFuture.completedFuture(null);
            }
            finally {
                this.flushQueryLock.writeLock().unlock();
                if (logger.isDebugEnabled()) {
                    logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
                }
            }
        }
        if (!logger.isDebugEnabled()) return future;
        logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncFlush() throws IOException {
        IMemTable tmpMemTable;
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            IMemTable iMemTable = tmpMemTable = this.workMemTable == null ? new NotifyFlushMemTable() : this.workMemTable;
            if (logger.isDebugEnabled() && tmpMemTable.isSignalMemTable()) {
                logger.debug("{}: {} add a signal memtable into flushing memtable list when sync flush", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
            this.addAMemtableIntoFlushingList(tmpMemTable);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            try {
                long startWait = System.currentTimeMillis();
                while (this.flushingMemTables.contains(tmpMemTable)) {
                    this.flushingMemTables.wait(1000L);
                    if (System.currentTimeMillis() - startWait <= 60000L) continue;
                    logger.warn("has waited for synced flushing a memtable in {} for 60 seconds.", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                    startWait = System.currentTimeMillis();
                }
            }
            catch (InterruptedException e) {
                logger.error("{}: {} wait flush finished meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncFlush() {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            if (this.workMemTable == null) {
                return;
            }
            logger.info("Async flush a memtable to tsfile: {}", (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            this.addAMemtableIntoFlushingList(this.workMemTable);
        }
        catch (Exception e) {
            logger.error("{}: {} add a memtable into flushing list failed", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    private Future<?> addAMemtableIntoFlushingList(IMemTable tobeFlushed) throws IOException {
        Map<IDeviceID, Long> lastTimeForEachDevice = tobeFlushed.getMaxTime();
        if (lastTimeForEachDevice.size() != this.tsFileResource.getDevices().size()) {
            this.tsFileResource.deleteRemovedDeviceAndUpdateEndTime(lastTimeForEachDevice);
        } else if (this.sequence) {
            this.tsFileResource.updateEndTime(lastTimeForEachDevice);
        }
        for (FlushListener flushListener : this.flushListeners) {
            flushListener.onMemTableFlushStarted(tobeFlushed);
        }
        this.lastWorkMemtableFlushTime = System.currentTimeMillis();
        this.updateLatestFlushTimeCallback.call(this, lastTimeForEachDevice, this.lastWorkMemtableFlushTime);
        SystemInfo.getInstance().addFlushingMemTableCost(tobeFlushed.getTVListsRamCost());
        this.flushingMemTables.addLast(tobeFlushed);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} Memtable (signal = {}) is added into the flushing Memtable, queue size = {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), tobeFlushed.isSignalMemTable(), this.flushingMemTables.size()});
        }
        if (!tobeFlushed.isSignalMemTable() && !tobeFlushed.isEmpty()) {
            this.totalMemTableSize += tobeFlushed.memSize();
        }
        WritingMetrics.getInstance().recordMemTableLiveDuration(System.currentTimeMillis() - this.getWorkMemTableCreatedTime());
        WritingMetrics.getInstance().recordActiveMemTableCount(this.dataRegionInfo.getDataRegion().getDataRegionId(), -1);
        this.workMemTable = null;
        return FlushManager.getInstance().registerTsFileProcessor(this);
    }

    private void releaseFlushedMemTable(IMemTable memTable) {
        this.flushQueryLock.writeLock().lock();
        if (logger.isDebugEnabled()) {
            logger.debug(FLUSH_QUERY_WRITE_LOCKED, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
        }
        try {
            this.writer.makeMetadataVisible();
            if (!this.flushingMemTables.remove(memTable)) {
                logger.warn("{}: {} put the memtable (signal={}) out of flushingMemtables but it is not in the queue.", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable()});
            } else if (logger.isDebugEnabled()) {
                logger.debug("{}: {} memtable (signal={}) is removed from the queue. {} left.", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable(), this.flushingMemTables.size()});
            }
            memTable.release();
            MemTableManager.getInstance().decreaseMemtableNumber();
            this.dataRegionInfo.releaseStorageGroupMemCost(memTable.getTVListsRamCost());
            if (logger.isDebugEnabled()) {
                logger.debug("[mem control] {}: {} flush finished, try to reset system memcost, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), this.flushingMemTables.size()});
            }
            SystemInfo.getInstance().resetStorageGroupStatus(this.dataRegionInfo);
            SystemInfo.getInstance().resetFlushingMemTableCost(memTable.getTVListsRamCost());
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} flush finished, remove a memtable from flushing list, flushing memtable list size: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), this.flushingMemTables.size()});
            }
        }
        catch (Exception e) {
            logger.error("{}: {}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
            if (logger.isDebugEnabled()) {
                logger.debug(FLUSH_QUERY_WRITE_RELEASE, (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncReleaseFlushedMemTable(IMemTable memTable) {
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque = this.flushingMemTables;
        synchronized (concurrentLinkedDeque) {
            this.releaseFlushedMemTable(memTable);
            this.flushingMemTables.notifyAll();
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} released a memtable (signal={}), flushingMemtables size ={}", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), memTable.isSignalMemTable(), this.flushingMemTables.size()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushOneMemTable() {
        ConcurrentLinkedDeque<IMemTable> concurrentLinkedDeque;
        IMemTable memTableToFlush = this.flushingMemTables.getFirst();
        if (!memTableToFlush.isSignalMemTable()) {
            if (memTableToFlush.isEmpty()) {
                logger.info("This normal memtable is empty, skip flush. {}: {}", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
            } else {
                try {
                    this.writer.mark();
                    MemTableFlushTask flushTask = new MemTableFlushTask(memTableToFlush, this.writer, this.storageGroupName, this.dataRegionInfo.getDataRegion().getDataRegionId());
                    flushTask.syncFlushMemTable();
                }
                catch (Throwable e) {
                    if (this.writer == null) {
                        logger.info("{}: {} is closed during flush, abandon flush task", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                        concurrentLinkedDeque = this.flushingMemTables;
                        synchronized (concurrentLinkedDeque) {
                            this.flushingMemTables.notifyAll();
                        }
                    }
                    logger.error("{}: {} meet error when flushing a memtable, change system mode to error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                    CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                    try {
                        logger.error("{}: {} IOTask meets error, truncate the corrupted data", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                        this.writer.reset();
                    }
                    catch (IOException e1) {
                        logger.error("{}: {} Truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e1});
                    }
                    try {
                        this.syncReleaseFlushedMemTable(memTableToFlush);
                        this.tsFileResource.setTimeIndex(this.config.getTimeIndexLevel().getTimeIndex());
                        for (CloseFileListener closeFileListener : this.closeFileListeners) {
                            closeFileListener.onClosed(this);
                        }
                        this.writer.close();
                        this.writer = null;
                        ConcurrentLinkedDeque<IMemTable> e1 = this.flushingMemTables;
                        synchronized (e1) {
                            this.flushingMemTables.notifyAll();
                        }
                    }
                    catch (Exception e1) {
                        logger.error("{}: {} Release resource meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e1});
                    }
                    return;
                }
            }
        }
        try {
            this.flushQueryLock.writeLock().lock();
            Iterator<Pair<Modification, IMemTable>> iterator = this.modsToMemtable.iterator();
            while (iterator.hasNext()) {
                Pair<Modification, IMemTable> entry = iterator.next();
                if (!((IMemTable)entry.right).equals(memTableToFlush)) continue;
                ((Modification)entry.left).setFileOffset(this.tsFileResource.getTsFileSize());
                this.tsFileResource.getModFile().write((Modification)entry.left);
                this.tsFileResource.getModFile().close();
                iterator.remove();
                logger.info("[Deletion] Deletion with path: {}, time:{}-{} written when flush memtable", new Object[]{((Modification)entry.left).getPath(), ((Deletion)entry.left).getStartTime(), ((Deletion)entry.left).getEndTime()});
            }
        }
        catch (IOException e) {
            logger.error("Meet error when writing into ModificationFile file of {} ", (Object)this.tsFileResource.getTsFile().getAbsolutePath(), (Object)e);
        }
        finally {
            this.flushQueryLock.writeLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("{}: {} try get lock to release a memtable (signal={})", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), memTableToFlush.isSignalMemTable()});
        }
        this.syncReleaseFlushedMemTable(memTableToFlush);
        try {
            this.writer.getTsFileOutput().force();
        }
        catch (IOException e) {
            logger.error("fsync memTable data to disk error,", (Throwable)e);
        }
        for (FlushListener flushListener : this.flushListeners) {
            flushListener.onMemTableFlushed(memTableToFlush);
        }
        int retryCnt = 0;
        while (this.shouldClose && this.flushingMemTables.isEmpty() && this.writer != null) {
            block42: {
                try {
                    if (this.isEmpty()) {
                        this.endEmptyFile();
                    } else {
                        this.writer.mark();
                        this.updateCompressionRatio();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: {} flushingMemtables is empty and will close the file", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsolutePath());
                        }
                        this.endFile();
                    }
                    if (!logger.isDebugEnabled()) break block42;
                    logger.debug("{} flushingMemtables is clear", (Object)this.storageGroupName);
                }
                catch (Exception e) {
                    logger.error("{}: {} marking or ending file meet error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                    try {
                        this.writer.reset();
                    }
                    catch (IOException e1) {
                        logger.error("{}: {} truncate corrupted data meets error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e1});
                    }
                    if (retryCnt < 3) {
                        logger.warn("{} meet error when flush FileMetadata to {}, retry it again", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                        ++retryCnt;
                        continue;
                    }
                    logger.error("{} meet error when flush FileMetadata to {}, change system mode to error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getAbsolutePath(), e});
                    CommonDescriptor.getInstance().getConfig().handleUnrecoverableError();
                    break;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("{}: {} try to get flushingMemtables lock.", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsolutePath());
            }
            concurrentLinkedDeque = this.flushingMemTables;
            synchronized (concurrentLinkedDeque) {
                this.flushingMemTables.notifyAll();
            }
        }
    }

    private void updateCompressionRatio() {
        try {
            double compressionRatio = (double)this.totalMemTableSize / (double)this.writer.getPos();
            logger.info("The compression ratio of tsfile {} is {}, totalMemTableSize: {}, the file size: {}", new Object[]{this.writer.getFile().getAbsolutePath(), String.format("%.2f", compressionRatio), this.totalMemTableSize, this.writer.getPos()});
            String dataRegionId = this.dataRegionInfo.getDataRegion().getDataRegionId();
            WritingMetrics.getInstance().recordTsFileCompressionRatioOfFlushingMemTable(dataRegionId, compressionRatio);
            CompressionRatio.getInstance().updateRatio(this.totalMemTableSize, this.writer.getPos());
        }
        catch (IOException e) {
            logger.error("{}: {} update compression ratio failed", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
        }
    }

    private void endFile() throws IOException, TsFileProcessorException {
        if (logger.isDebugEnabled()) {
            logger.debug("Start to end file {}", (Object)this.tsFileResource);
        }
        this.writer.endFile();
        this.tsFileResource.serialize();
        if (logger.isDebugEnabled()) {
            logger.debug("Ended file {}", (Object)this.tsFileResource);
        }
        for (CloseFileListener closeFileListener : this.closeFileListeners) {
            closeFileListener.onClosed(this);
        }
        this.tsFileProcessorInfo.clear();
        this.dataRegionInfo.closeTsFileProcessorAndReportToSystem(this);
        this.writer = null;
    }

    private void endEmptyFile() throws TsFileProcessorException, IOException {
        logger.info("Start to end empty file {}", (Object)this.tsFileResource);
        this.writer.close();
        for (CloseFileListener closeFileListener : this.closeFileListeners) {
            closeFileListener.onClosed(this);
        }
        this.tsFileProcessorInfo.clear();
        this.dataRegionInfo.closeTsFileProcessorAndReportToSystem(this);
        logger.info("Storage group {} close and remove empty file {}", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getAbsoluteFile());
        this.writer = null;
    }

    public boolean isManagedByFlushManager() {
        return this.managedByFlushManager;
    }

    public void setManagedByFlushManager(boolean managedByFlushManager) {
        this.managedByFlushManager = managedByFlushManager;
    }

    public void close() throws TsFileProcessorException {
        try {
            this.tsFileResource.close();
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
    }

    public int getFlushingMemTableSize() {
        return this.flushingMemTables.size();
    }

    RestorableTsFileIOWriter getWriter() {
        return this.writer;
    }

    public String getStorageGroupName() {
        return this.storageGroupName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void query(List<PartialPath> seriesPaths, QueryContext context, List<TsFileResource> tsfileResourcesForQuery) throws IOException {
        long startTime = System.nanoTime();
        try {
            HashMap<PartialPath, List<IChunkMetadata>> pathToChunkMetadataListMap = new HashMap<PartialPath, List<IChunkMetadata>>();
            HashMap<PartialPath, List<ReadOnlyMemChunk>> pathToReadOnlyMemChunkMap = new HashMap<PartialPath, List<ReadOnlyMemChunk>>();
            this.flushQueryLock.readLock().lock();
            try {
                Iterator<PartialPath> iterator = seriesPaths.iterator();
                while (true) {
                    ReadOnlyMemChunk memChunk;
                    if (!iterator.hasNext()) {
                        this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                        this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                        this.flushQueryLock.readLock().unlock();
                        if (logger.isDebugEnabled()) {
                            logger.debug("{}: {} release flushQueryLock", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
                        }
                        break;
                    }
                    PartialPath seriesPath = iterator.next();
                    ArrayList<ReadOnlyMemChunk> readOnlyMemChunks = new ArrayList<ReadOnlyMemChunk>();
                    for (IMemTable flushingMemTable : this.flushingMemTables) {
                        ReadOnlyMemChunk memChunk2;
                        if (flushingMemTable.isSignalMemTable() || (memChunk2 = flushingMemTable.query(context, seriesPath, context.getQueryTimeLowerBound(), this.modsToMemtable)) == null) continue;
                        readOnlyMemChunks.add(memChunk2);
                    }
                    if (this.workMemTable != null && (memChunk = this.workMemTable.query(context, seriesPath, context.getQueryTimeLowerBound(), null)) != null) {
                        readOnlyMemChunks.add(memChunk);
                    }
                    List<IChunkMetadata> chunkMetadataList = ResourceByPathUtils.getResourceInstance(seriesPath).getVisibleMetadataListFromWriter(this.writer, this.tsFileResource, context);
                    if (readOnlyMemChunks.isEmpty() && chunkMetadataList.isEmpty()) continue;
                    pathToReadOnlyMemChunkMap.put(seriesPath, readOnlyMemChunks);
                    pathToChunkMetadataListMap.put(seriesPath, chunkMetadataList);
                }
            }
            catch (MetadataException | QueryProcessException e) {
                try {
                    logger.error("{}: {} get ReadOnlyMemChunk has error", new Object[]{this.storageGroupName, this.tsFileResource.getTsFile().getName(), e});
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                    this.flushQueryLock.readLock().unlock();
                }
                catch (Throwable throwable) {
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("flushing_memtable", this.flushingMemTables.size());
                    this.QUERY_RESOURCE_METRICS.recordQueryResourceNum("working_memtable", this.workMemTable != null ? 1 : 0);
                    this.flushQueryLock.readLock().unlock();
                    if (!logger.isDebugEnabled()) throw throwable;
                    logger.debug("{}: {} release flushQueryLock", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
                    throw throwable;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("{}: {} release flushQueryLock", (Object)this.storageGroupName, (Object)this.tsFileResource.getTsFile().getName());
                }
            }
            if (pathToReadOnlyMemChunkMap.isEmpty()) {
                if (pathToChunkMetadataListMap.isEmpty()) return;
            }
            tsfileResourcesForQuery.add(new TsFileResource(pathToReadOnlyMemChunkMap, pathToChunkMetadataListMap, this.tsFileResource));
            return;
        }
        finally {
            this.QUERY_EXECUTION_METRICS.recordExecutionCost("get_query_resource_from_mem", System.nanoTime() - startTime);
        }
    }

    public long getTimeRangeId() {
        return this.timeRangeId;
    }

    public void setTimeRangeId(long timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    public void putMemTableBackAndClose() throws TsFileProcessorException {
        if (this.workMemTable != null) {
            this.workMemTable.release();
            this.dataRegionInfo.releaseStorageGroupMemCost(this.workMemTable.getTVListsRamCost());
            this.workMemTable = null;
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new TsFileProcessorException(e);
        }
        this.tsFileProcessorInfo.clear();
        this.dataRegionInfo.closeTsFileProcessorAndReportToSystem(this);
    }

    public void setTsFileProcessorInfo(TsFileProcessorInfo tsFileProcessorInfo) {
        this.tsFileProcessorInfo = tsFileProcessorInfo;
    }

    public long getWorkMemTableRamCost() {
        return this.workMemTable != null ? this.workMemTable.getTVListsRamCost() : 0L;
    }

    public long getWorkMemTableCreatedTime() {
        return this.workMemTable != null ? this.workMemTable.getCreatedTime() : Long.MAX_VALUE;
    }

    public long getWorkMemTableUpdateTime() {
        return this.workMemTable != null ? this.workMemTable.getUpdateTime() : Long.MAX_VALUE;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public void setWorkMemTableShouldFlush() {
        this.workMemTable.setShouldFlush();
    }

    public void addCloseFileListener(CloseFileListener listener) {
        this.closeFileListeners.add(listener);
    }

    public void addFlushListeners(Collection<FlushListener> listeners) {
        this.flushListeners.addAll(listeners);
    }

    public void addCloseFileListeners(Collection<CloseFileListener> listeners) {
        this.closeFileListeners.addAll(listeners);
    }

    public void submitAFlushTask() {
        this.dataRegionInfo.getDataRegion().submitAFlushTaskWhenShouldFlush(this);
    }

    public boolean alreadyMarkedClosing() {
        return this.shouldClose;
    }

    public boolean isEmpty() {
        return this.totalMemTableSize == 0L && (this.workMemTable == null || this.workMemTable.getTotalPointsNum() == 0L);
    }

    public IMemTable getWorkMemTable() {
        return this.workMemTable;
    }

    public ConcurrentLinkedDeque<IMemTable> getFlushingMemTable() {
        return this.flushingMemTables;
    }

    private static /* synthetic */ Pair lambda$checkAlignedMemCostAndAddToTspInfoForRows$4(IDeviceID k) {
        return new Pair(new HashMap(), (Object)1);
    }
}

