/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.repair;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionLastTimeCheckFailedException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.fast.reader.CompactionChunkReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.io.CompactionTsFileReader;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.constant.CompactionType;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.DeviceTimeIndex;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.timeindex.ITimeIndex;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.compress.IUnCompressor;
import org.apache.iotdb.tsfile.encoding.decoder.Decoder;
import org.apache.iotdb.tsfile.file.header.ChunkHeader;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.AlignedChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.PlainDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.TsFileDeviceIterator;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteForEncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepairDataFileScanUtil {
    private static final Logger logger = LoggerFactory.getLogger(RepairDataFileScanUtil.class);
    private final TsFileResource resource;
    private boolean hasUnsortedData;
    private boolean isBrokenFile;
    private long previousTime;

    public RepairDataFileScanUtil(TsFileResource resource) {
        this.resource = resource;
        this.hasUnsortedData = false;
        this.previousTime = Long.MIN_VALUE;
    }

    public void scanTsFile() {
        File tsfile = this.resource.getTsFile();
        try (CompactionTsFileReader reader = new CompactionTsFileReader(tsfile.getPath(), this.resource.isSeq() ? CompactionType.INNER_SEQ_COMPACTION : CompactionType.INNER_UNSEQ_COMPACTION);){
            TsFileDeviceIterator deviceIterator = reader.getAllDevicesIteratorWithIsAligned();
            while (deviceIterator.hasNext()) {
                Pair deviceIsAlignedPair = deviceIterator.next();
                IDeviceID device = (IDeviceID)deviceIsAlignedPair.getLeft();
                boolean isAligned = (Boolean)deviceIsAlignedPair.getRight();
                if (isAligned) {
                    this.checkAlignedDeviceSeries(reader, device);
                    continue;
                }
                this.checkNonAlignedDeviceSeries(reader, device);
            }
        }
        catch (CompactionLastTimeCheckFailedException lastTimeCheckFailedException) {
            this.hasUnsortedData = true;
        }
        catch (Exception e) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!this.resource.tsFileExists()) {
                return;
            }
            logger.warn("Meet error when read tsfile {}", (Object)tsfile.getAbsolutePath(), (Object)e);
            this.isBrokenFile = true;
        }
    }

    private void checkAlignedDeviceSeries(TsFileSequenceReader reader, IDeviceID device) throws IOException {
        List chunkMetadataList = reader.getAlignedChunkMetadata(device);
        for (AlignedChunkMetadata alignedChunkMetadata : chunkMetadataList) {
            IChunkMetadata timeChunkMetadata = alignedChunkMetadata.getTimeChunkMetadata();
            Chunk timeChunk = reader.readMemChunk((ChunkMetadata)timeChunkMetadata);
            CompactionChunkReader chunkReader = new CompactionChunkReader(timeChunk);
            ByteBuffer chunkDataBuffer = timeChunk.getData();
            ChunkHeader chunkHeader = timeChunk.getHeader();
            while (chunkDataBuffer.hasRemaining()) {
                PageHeader pageHeader = null;
                pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)timeChunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
                ByteBuffer pageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
                ByteBuffer uncompressedPageData = this.uncompressPageData(chunkHeader.getCompressionType(), pageHeader, pageData);
                Decoder decoder = Decoder.getDecoderByType((TSEncoding)chunkHeader.getEncodingType(), (TSDataType)chunkHeader.getDataType());
                while (decoder.hasNext(uncompressedPageData)) {
                    long currentTime = decoder.readLong(uncompressedPageData);
                    this.checkPreviousTimeAndUpdate(((PlainDeviceID)device).toStringID(), currentTime);
                }
            }
        }
        this.previousTime = Long.MIN_VALUE;
    }

    private void checkNonAlignedDeviceSeries(TsFileSequenceReader reader, IDeviceID device) throws IOException {
        Iterator measurementChunkMetadataListMapIterator = reader.getMeasurementChunkMetadataListMapIterator(device);
        while (measurementChunkMetadataListMapIterator.hasNext()) {
            Map measurementChunkMetadataListMap = (Map)measurementChunkMetadataListMapIterator.next();
            for (Map.Entry measurementChunkMetadataListEntry : measurementChunkMetadataListMap.entrySet()) {
                String measurement = (String)measurementChunkMetadataListEntry.getKey();
                List chunkMetadataList = (List)measurementChunkMetadataListEntry.getValue();
                this.checkSingleNonAlignedSeries(reader, measurement, chunkMetadataList);
                this.previousTime = Long.MIN_VALUE;
            }
        }
    }

    private void checkSingleNonAlignedSeries(TsFileSequenceReader reader, String measurement, List<ChunkMetadata> chunkMetadataList) throws IOException {
        for (ChunkMetadata chunkMetadata : chunkMetadataList) {
            if (chunkMetadata == null || chunkMetadata.getStatistics().getCount() == 0L) continue;
            Chunk chunk = reader.readMemChunk(chunkMetadata);
            ChunkHeader chunkHeader = chunk.getHeader();
            CompactionChunkReader chunkReader = new CompactionChunkReader(chunk);
            ByteBuffer chunkDataBuffer = chunk.getData();
            while (chunkDataBuffer.hasRemaining()) {
                PageHeader pageHeader = null;
                pageHeader = (byte)(chunkHeader.getChunkType() & 0x3F) == 5 ? PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (Statistics)chunk.getChunkStatistic()) : PageHeader.deserializeFrom((ByteBuffer)chunkDataBuffer, (TSDataType)chunkHeader.getDataType());
                ByteBuffer pageData = chunkReader.readPageDataWithoutUncompressing(pageHeader);
                ByteBuffer uncompressedPageData = this.uncompressPageData(chunkHeader.getCompressionType(), pageHeader, pageData);
                ByteBuffer timeBuffer = this.getTimeBufferFromNonAlignedPage(uncompressedPageData);
                Decoder timeDecoder = Decoder.getDecoderByType((TSEncoding)TSEncoding.valueOf((String)TSFileDescriptor.getInstance().getConfig().getTimeEncoder()), (TSDataType)TSDataType.INT64);
                while (timeDecoder.hasNext(timeBuffer)) {
                    long currentTime = timeDecoder.readLong(timeBuffer);
                    this.checkPreviousTimeAndUpdate(measurement, currentTime);
                }
            }
        }
    }

    private ByteBuffer getTimeBufferFromNonAlignedPage(ByteBuffer uncompressedPageData) {
        int timeBufferLength = ReadWriteForEncodingUtils.readUnsignedVarInt((ByteBuffer)uncompressedPageData);
        ByteBuffer timeBuffer = uncompressedPageData.slice();
        timeBuffer.limit(timeBufferLength);
        return timeBuffer;
    }

    private ByteBuffer uncompressPageData(CompressionType compressionType, PageHeader pageHeader, ByteBuffer pageData) throws IOException {
        IUnCompressor unCompressor = IUnCompressor.getUnCompressor((CompressionType)compressionType);
        byte[] uncompressedData = new byte[pageHeader.getUncompressedSize()];
        unCompressor.uncompress(pageData.array(), 0, pageHeader.getCompressedSize(), uncompressedData, 0);
        return ByteBuffer.wrap(uncompressedData);
    }

    private void checkPreviousTimeAndUpdate(String path, long time) {
        if (this.previousTime >= time) {
            throw new CompactionLastTimeCheckFailedException(path, time, this.previousTime);
        }
        this.previousTime = time;
    }

    public boolean hasUnsortedData() {
        return this.hasUnsortedData;
    }

    public boolean isBrokenFile() {
        return this.isBrokenFile;
    }

    public static List<TsFileResource> checkTimePartitionHasOverlap(List<TsFileResource> resources) {
        ArrayList<TsFileResource> overlapResources = new ArrayList<TsFileResource>();
        HashMap<IDeviceID, Long> deviceEndTimeMap = new HashMap<IDeviceID, Long>();
        for (TsFileResource resource : resources) {
            DeviceTimeIndex deviceTimeIndex;
            if (resource.getStatus() == TsFileResourceStatus.UNCLOSED || resource.getStatus() == TsFileResourceStatus.DELETED) continue;
            try {
                deviceTimeIndex = RepairDataFileScanUtil.getDeviceTimeIndex(resource);
            }
            catch (Exception ignored) {
                continue;
            }
            Set<IDeviceID> devices = deviceTimeIndex.getDevices();
            boolean fileHasOverlap = false;
            for (IDeviceID device : devices) {
                long deviceEndTimeInPreviousFile;
                long deviceStartTimeInCurrentFile = deviceTimeIndex.getStartTime(device);
                if (deviceStartTimeInCurrentFile > deviceTimeIndex.getEndTime(device) || !deviceEndTimeMap.containsKey(device) || deviceStartTimeInCurrentFile > (deviceEndTimeInPreviousFile = ((Long)deviceEndTimeMap.get(device)).longValue())) continue;
                fileHasOverlap = true;
                overlapResources.add(resource);
                break;
            }
            if (fileHasOverlap) continue;
            for (IDeviceID device : devices) {
                deviceEndTimeMap.put(device, deviceTimeIndex.getEndTime(device));
            }
        }
        return overlapResources;
    }

    private static DeviceTimeIndex getDeviceTimeIndex(TsFileResource resource) throws IOException {
        ITimeIndex timeIndex = resource.getTimeIndex();
        if (timeIndex instanceof DeviceTimeIndex) {
            return (DeviceTimeIndex)timeIndex;
        }
        return resource.buildDeviceTimeIndex();
    }
}

