/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.readchunk.loader;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.executor.ModifiedStatus;
import org.apache.iotdb.tsfile.exception.write.PageException;
import org.apache.iotdb.tsfile.file.header.PageHeader;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.TimeRange;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;

public abstract class PageLoader {
    protected PageHeader pageHeader;
    protected CompressionType compressionType;
    protected TSDataType dataType;
    protected TSEncoding encoding;
    protected List<TimeRange> deleteIntervalList;
    protected ModifiedStatus modifiedStatus;

    protected PageLoader() {
    }

    protected PageLoader(PageHeader pageHeader, CompressionType compressionType, TSDataType dataType, TSEncoding encoding, List<TimeRange> deleteIntervalList, ModifiedStatus modifiedStatus) {
        this.pageHeader = pageHeader;
        this.compressionType = compressionType;
        this.dataType = dataType;
        this.encoding = encoding;
        this.deleteIntervalList = deleteIntervalList;
        this.modifiedStatus = modifiedStatus;
    }

    public PageHeader getHeader() {
        return this.pageHeader;
    }

    public TSDataType getDataType() {
        return this.dataType;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public TSEncoding getEncoding() {
        return this.encoding;
    }

    public abstract ByteBuffer getCompressedData() throws IOException;

    public abstract ByteBuffer getUnCompressedData() throws IOException;

    public ModifiedStatus getModifiedStatus() {
        return this.modifiedStatus;
    }

    public List<TimeRange> getDeleteIntervalList() {
        if (this.modifiedStatus == ModifiedStatus.PARTIAL_DELETED) {
            return this.deleteIntervalList;
        }
        if (this.modifiedStatus == ModifiedStatus.ALL_DELETED) {
            return Collections.singletonList(new TimeRange(this.pageHeader.getStartTime(), this.pageHeader.getEndTime()));
        }
        return null;
    }

    public abstract void flushToTimeChunkWriter(AlignedChunkWriterImpl var1) throws PageException;

    public abstract void flushToValueChunkWriter(AlignedChunkWriterImpl var1, int var2) throws IOException, PageException;

    public abstract boolean isEmpty();

    public abstract void clear();
}

