/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.DiskSpaceInsufficientException;
import org.apache.iotdb.db.service.metrics.CompactionMetrics;
import org.apache.iotdb.db.service.metrics.FileMetrics;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.exception.CompactionRecoverException;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.ICompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.FastCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.AbstractCompactionTask;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskPriorityType;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.CompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.task.subtask.FastCompactionTaskSummary;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.CompactionUtils;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.CompactionLogAnalyzer;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.SimpleCompactionLogger;
import org.apache.iotdb.db.storageengine.dataregion.compaction.execute.utils.log.TsFileIdentifier;
import org.apache.iotdb.db.storageengine.dataregion.compaction.schedule.CompactionTaskManager;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.AbstractInnerSpaceEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.FastCompactionInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.compaction.selector.estimator.ReadChunkInnerCompactionEstimator;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResourceStatus;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.generator.TsFileNameGenerator;
import org.apache.iotdb.tsfile.exception.StopReadTsFileByInterruptException;
import org.apache.iotdb.tsfile.exception.write.TsFileNotCompleteException;
import org.apache.iotdb.tsfile.utils.TsFileUtils;

public class InnerSpaceCompactionTask
extends AbstractCompactionTask {
    protected List<TsFileResource> selectedTsFileResourceList;
    protected TsFileResource targetTsFileResource;
    protected boolean isTargetTsFileEmpty;
    protected boolean sequence;
    protected long selectedFileSize;
    protected int sumOfCompactionCount;
    protected long maxFileVersion;
    protected int maxCompactionCount;
    protected File logFile;
    protected List<TsFileResource> targetTsFileList;
    protected boolean[] isHoldingWriteLock;
    protected long maxModsFileSize;
    protected AbstractInnerSpaceEstimator innerSpaceEstimator;
    protected boolean needRecoverTaskInfoFromLogFile;

    public InnerSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, ICompactionPerformer performer, long serialId) {
        this(timePartition, tsFileManager, selectedTsFileResourceList, sequence, performer, serialId, CompactionTaskPriorityType.NORMAL);
    }

    public InnerSpaceCompactionTask(String databaseName, String dataRegionId, TsFileManager tsFileManager, File logFile) {
        super(databaseName, dataRegionId, 0L, tsFileManager, 0L, CompactionTaskPriorityType.NORMAL);
        this.logFile = logFile;
        this.needRecoverTaskInfoFromLogFile = true;
    }

    private void recoverTaskInfoFromLogFile() throws IOException {
        CompactionLogAnalyzer logAnalyzer = new CompactionLogAnalyzer(this.logFile);
        logAnalyzer.analyze();
        List<TsFileIdentifier> sourceFileIdentifiers = logAnalyzer.getSourceFileInfos();
        this.selectedTsFileResourceList = new ArrayList<TsFileResource>();
        sourceFileIdentifiers.forEach(f -> this.selectedTsFileResourceList.add(new TsFileResource(f.getFileFromDataDirs())));
        List<TsFileIdentifier> targetFileIdentifiers = logAnalyzer.getTargetFileInfos();
        List<TsFileIdentifier> deletedTargetFileIdentifiers = logAnalyzer.getDeletedTargetFileInfos();
        if (!targetFileIdentifiers.isEmpty()) {
            File targetFileOnDisk = this.getRealTargetFile(targetFileIdentifiers.get(0), ".inner");
            this.targetTsFileResource = new TsFileResource(targetFileOnDisk);
        }
        this.isTargetTsFileEmpty = !deletedTargetFileIdentifiers.isEmpty();
        this.taskStage = logAnalyzer.getTaskStage();
    }

    public InnerSpaceCompactionTask(long timePartition, TsFileManager tsFileManager, List<TsFileResource> selectedTsFileResourceList, boolean sequence, ICompactionPerformer performer, long serialId, CompactionTaskPriorityType compactionTaskPriorityType) {
        super(tsFileManager.getStorageGroupName(), tsFileManager.getDataRegionId(), timePartition, tsFileManager, serialId, compactionTaskPriorityType);
        this.selectedTsFileResourceList = selectedTsFileResourceList;
        this.sequence = sequence;
        this.performer = performer;
        if (this.performer instanceof ReadChunkCompactionPerformer) {
            this.innerSpaceEstimator = new ReadChunkInnerCompactionEstimator();
        } else if (!sequence && this.performer instanceof FastCompactionPerformer) {
            this.innerSpaceEstimator = new FastCompactionInnerCompactionEstimator();
        }
        this.isHoldingWriteLock = new boolean[selectedTsFileResourceList.size()];
        for (int i = 0; i < selectedTsFileResourceList.size(); ++i) {
            this.isHoldingWriteLock[i] = false;
        }
        this.hashCode = this.toString().hashCode();
        this.innerSeqTask = sequence;
        this.crossTask = false;
        this.collectSelectedFilesInfo();
        this.createSummary();
    }

    protected void prepare() throws IOException, DiskSpaceInsufficientException {
        this.targetTsFileResource = TsFileNameGenerator.getInnerCompactionTargetFileResource(this.selectedTsFileResourceList, this.sequence);
        String dataDirectory = this.selectedTsFileResourceList.get(0).getTsFile().getParent();
        this.logFile = new File(dataDirectory + File.separator + this.targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doCompaction() {
        if (!this.tsFileManager.isAllowCompaction()) {
            return true;
        }
        if (this.sequence && !IoTDBDescriptor.getInstance().getConfig().isEnableSeqSpaceCompaction() || !this.sequence && !IoTDBDescriptor.getInstance().getConfig().isEnableUnseqSpaceCompaction()) {
            return true;
        }
        if (this.compactionConfigVersion < CompactionTaskManager.getInstance().getCurrentCompactionConfigVersion()) {
            return true;
        }
        long startTime = System.currentTimeMillis();
        this.recoverMemoryStatus = true;
        LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task starts with {} files, total file size is {} MB, estimated memory cost is {} MB", new Object[]{this.storageGroupName, this.dataRegionId, this.sequence ? "Sequence" : "Unsequence", this.selectedTsFileResourceList.size(), this.selectedFileSize / 1024L / 1024L, this.memoryCost == 0L ? 0.0 : (double)this.memoryCost / 1024.0 / 1024.0});
        boolean isSuccess = true;
        try {
            this.prepare();
            try (SimpleCompactionLogger compactionLogger = new SimpleCompactionLogger(this.logFile);){
                this.targetTsFileList = new ArrayList<TsFileResource>(Collections.singletonList(this.targetTsFileResource));
                compactionLogger.logSourceFiles(this.selectedTsFileResourceList);
                compactionLogger.logTargetFile(this.targetTsFileResource);
                compactionLogger.force();
                LOGGER.info("{}-{} [Compaction] compaction with {}", new Object[]{this.storageGroupName, this.dataRegionId, this.selectedTsFileResourceList});
                this.performer.setSourceFiles(this.selectedTsFileResourceList);
                this.performer.setTargetFiles(this.targetTsFileList);
                this.performer.setSummary(this.summary);
                this.performer.perform();
                this.prepareTargetFiles();
                if (Thread.currentThread().isInterrupted() || this.summary.isCancel()) {
                    throw new InterruptedException(String.format("%s-%s [Compaction] abort", this.storageGroupName, this.dataRegionId));
                }
                this.validateCompactionResult(this.sequence ? this.selectedTsFileResourceList : Collections.emptyList(), this.sequence ? Collections.emptyList() : this.selectedTsFileResourceList, this.targetTsFileList);
                this.tsFileManager.replace(this.sequence ? this.selectedTsFileResourceList : Collections.emptyList(), this.sequence ? Collections.emptyList() : this.selectedTsFileResourceList, this.targetTsFileList, this.timePartition);
                if (this.targetTsFileResource.isDeleted()) {
                    compactionLogger.logEmptyTargetFile(this.targetTsFileResource);
                    this.isTargetTsFileEmpty = true;
                    compactionLogger.force();
                }
                LOGGER.info("{}-{} [Compaction] Compacted target files, try to get the write lock of source files", (Object)this.storageGroupName, (Object)this.dataRegionId);
                for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
                    this.selectedTsFileResourceList.get(i).writeLock();
                    this.isHoldingWriteLock[i] = true;
                }
                if (this.targetTsFileResource.getTsFile().exists() && this.targetTsFileResource.getTsFile().length() < (long)"TsFile".getBytes().length * 2L + 1L) {
                    throw new TsFileNotCompleteException(String.format("target file %s is smaller than magic string and version number size", this.targetTsFileResource));
                }
                LOGGER.info("{}-{} [Compaction] compaction finish, start to delete old files", (Object)this.storageGroupName, (Object)this.dataRegionId);
                CompactionUtils.deleteSourceTsFileAndUpdateFileMetrics(this.selectedTsFileResourceList, this.sequence);
                CompactionUtils.deleteModificationForSourceFile(this.selectedTsFileResourceList, this.storageGroupName + "-" + this.dataRegionId);
                if (!this.targetTsFileResource.isDeleted()) {
                    FileMetrics.getInstance().addTsFile(this.targetTsFileResource.getDatabaseName(), this.targetTsFileResource.getDataRegionId(), this.targetTsFileResource.getTsFile().length(), this.targetTsFileResource.isSeq(), this.targetTsFileResource.getTsFile().getName());
                } else {
                    this.targetTsFileResource.remove();
                }
                CompactionMetrics.getInstance().recordSummaryInfo(this.summary);
                double costTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                LOGGER.info("{}-{} [Compaction] {} InnerSpaceCompaction task finishes successfully, target file is {},time cost is {} s, compaction speed is {} MB/s, {}", new Object[]{this.storageGroupName, this.dataRegionId, this.sequence ? "Sequence" : "Unsequence", this.targetTsFileResource.getTsFile().getName(), String.format("%.2f", costTime), String.format("%.2f", (double)this.selectedFileSize / 1024.0 / 1024.0 / costTime), this.summary});
            }
            finally {
                Files.deleteIfExists(this.logFile.toPath());
                this.targetTsFileResource.setStatus(TsFileResourceStatus.NORMAL);
            }
        }
        catch (Exception e) {
            isSuccess = false;
            this.handleException(LOGGER, e);
            this.recover();
        }
        finally {
            this.releaseAllLocks();
        }
        return isSuccess;
    }

    protected void prepareTargetFiles() throws IOException {
        CompactionUtils.updateProgressIndex(this.targetTsFileList, this.selectedTsFileResourceList, Collections.emptyList());
        CompactionUtils.moveTargetFile(this.targetTsFileList, true, this.storageGroupName + "-" + this.dataRegionId);
        LOGGER.info("{}-{} [InnerSpaceCompactionTask] start to rename mods file", (Object)this.storageGroupName, (Object)this.dataRegionId);
        CompactionUtils.combineModsInInnerCompaction(this.selectedTsFileResourceList, this.targetTsFileResource);
    }

    @Override
    public void recover() {
        try {
            if (this.needRecoverTaskInfoFromLogFile) {
                this.recoverTaskInfoFromLogFile();
            }
            if (this.shouldRollback()) {
                this.rollback();
            } else {
                this.finishTask();
            }
        }
        catch (Exception e) {
            this.handleRecoverException(e);
        }
    }

    private void rollback() throws IOException {
        if (this.recoverMemoryStatus) {
            this.replaceTsFileInMemory(Collections.singletonList(this.targetTsFileResource), this.selectedTsFileResourceList);
        }
        this.deleteCompactionModsFile(this.selectedTsFileResourceList);
        if (this.targetTsFileResource != null && !this.deleteTsFileOnDisk(this.targetTsFileResource)) {
            throw new CompactionRecoverException(String.format("failed to delete target file %s", this.targetTsFileResource));
        }
    }

    private void finishTask() throws IOException {
        if (this.targetTsFileResource.isDeleted() || this.isTargetTsFileEmpty) {
            if (this.targetTsFileResource.remove()) {
                throw new CompactionRecoverException(String.format("failed to delete empty target file %s", this.targetTsFileResource));
            }
        } else {
            File targetFile = this.targetTsFileResource.getTsFile();
            if (targetFile == null || !TsFileUtils.isTsFileComplete((File)this.targetTsFileResource.getTsFile())) {
                throw new CompactionRecoverException(String.format("Target file is not completed. %s", targetFile));
            }
            if (this.recoverMemoryStatus) {
                this.targetTsFileResource.setStatus(TsFileResourceStatus.NORMAL);
            }
        }
        if (!this.deleteTsFilesOnDisk(this.selectedTsFileResourceList)) {
            throw new CompactionRecoverException("source files cannot be deleted successfully");
        }
        if (this.recoverMemoryStatus) {
            FileMetrics.getInstance().deleteTsFile(true, this.selectedTsFileResourceList);
        }
        this.deleteCompactionModsFile(this.selectedTsFileResourceList);
    }

    private boolean shouldRollback() {
        return this.checkAllSourceFileExists(this.selectedTsFileResourceList);
    }

    @Override
    public boolean equalsOtherTask(AbstractCompactionTask otherTask) {
        if (!(otherTask instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        InnerSpaceCompactionTask task = (InnerSpaceCompactionTask)otherTask;
        return this.selectedTsFileResourceList.equals(task.selectedTsFileResourceList) && this.performer.getClass().isInstance(task.performer);
    }

    @Override
    public List<TsFileResource> getAllSourceTsFiles() {
        return this.selectedTsFileResourceList;
    }

    private void collectSelectedFilesInfo() {
        this.selectedFileSize = 0L;
        this.sumOfCompactionCount = 0;
        this.maxFileVersion = -1L;
        this.maxCompactionCount = -1;
        this.maxModsFileSize = 0L;
        if (this.selectedTsFileResourceList == null) {
            return;
        }
        for (TsFileResource resource : this.selectedTsFileResourceList) {
            try {
                this.selectedFileSize += resource.getTsFileSize();
                TsFileNameGenerator.TsFileName fileName = TsFileNameGenerator.getTsFileName(resource.getTsFile().getName());
                this.sumOfCompactionCount += fileName.getInnerCompactionCnt();
                if (fileName.getInnerCompactionCnt() > this.maxCompactionCount) {
                    this.maxCompactionCount = fileName.getInnerCompactionCnt();
                }
                if (fileName.getVersion() > this.maxFileVersion) {
                    this.maxFileVersion = fileName.getVersion();
                }
                if (Objects.isNull(resource.getModFile())) continue;
                long modsFileSize = resource.getModFile().getSize();
                this.maxModsFileSize = Math.max(this.maxModsFileSize, modsFileSize);
            }
            catch (IOException e) {
                LOGGER.warn("Fail to get the tsfile name of {}", (Object)resource.getTsFile(), (Object)e);
            }
        }
    }

    public List<TsFileResource> getSelectedTsFileResourceList() {
        return this.selectedTsFileResourceList;
    }

    public boolean isSequence() {
        return this.sequence;
    }

    public long getSelectedFileSize() {
        return this.selectedFileSize;
    }

    public int getSumOfCompactionCount() {
        return this.sumOfCompactionCount;
    }

    public long getMaxFileVersion() {
        return this.maxFileVersion;
    }

    public long getMaxModsFileSize() {
        return this.maxModsFileSize;
    }

    public String toString() {
        return this.storageGroupName + "-" + this.dataRegionId + "-" + this.timePartition + " task file num is " + this.selectedTsFileResourceList.size() + ", files is " + this.selectedTsFileResourceList + ", total compaction count is " + this.sumOfCompactionCount;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof InnerSpaceCompactionTask)) {
            return false;
        }
        return this.equalsOtherTask((InnerSpaceCompactionTask)other);
    }

    private void releaseAllLocks() {
        for (int i = 0; i < this.selectedTsFileResourceList.size(); ++i) {
            TsFileResource resource = this.selectedTsFileResourceList.get(i);
            if (!this.isHoldingWriteLock[i]) continue;
            resource.writeUnlock();
        }
    }

    @Override
    public long getEstimatedMemoryCost() {
        if (this.innerSpaceEstimator != null && this.memoryCost == 0L) {
            try {
                this.memoryCost = this.innerSpaceEstimator.estimateInnerCompactionMemory(this.selectedTsFileResourceList);
            }
            catch (Exception e) {
                if (e instanceof StopReadTsFileByInterruptException || Thread.interrupted()) {
                    Thread.currentThread().interrupt();
                    return -1L;
                }
                this.innerSpaceEstimator.cleanup();
                if (!this.tsFileManager.isAllowCompaction()) {
                    return -1L;
                }
                LOGGER.error("Meet error when estimate inner compaction memory", (Throwable)e);
                return -1L;
            }
        }
        return this.memoryCost;
    }

    @Override
    public int getProcessedFileNum() {
        return this.selectedTsFileResourceList.size();
    }

    @Override
    protected void createSummary() {
        this.summary = this.performer instanceof FastCompactionPerformer ? new FastCompactionTaskSummary() : new CompactionTaskSummary();
    }

    @Override
    public long getCompactionConfigVersion() {
        return this.compactionConfigVersion;
    }

    @Override
    public void setCompactionConfigVersion(long compactionConfigVersion) {
        this.compactionConfigVersion = Math.min(this.compactionConfigVersion, compactionConfigVersion);
    }
}

