/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.file;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class ModsFileMetrics
implements IMetricSet {
    private static final String MODS = "mods";
    private final AtomicInteger modFileNum = new AtomicInteger(0);
    private final AtomicLong modFileSize = new AtomicLong(0L);

    public void bindTo(AbstractMetricService metricService) {
        metricService.createAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.CORE, (Object)this, ModsFileMetrics::getModFileSize, new String[]{Tag.NAME.toString(), MODS});
        metricService.createAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.CORE, (Object)this, ModsFileMetrics::getModFileNum, new String[]{Tag.NAME.toString(), MODS});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_SIZE.toString(), new String[]{Tag.NAME.toString(), MODS});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.FILE_COUNT.toString(), new String[]{Tag.NAME.toString(), MODS});
    }

    private int getModFileNum() {
        return this.modFileNum.get();
    }

    private long getModFileSize() {
        return this.modFileSize.get();
    }

    public void increaseModFileNum(int num) {
        this.modFileNum.addAndGet(num);
    }

    public void decreaseModFileNum(int num) {
        this.modFileNum.addAndGet(-num);
    }

    public void increaseModFileSize(long size) {
        this.modFileSize.addAndGet(size);
    }

    public void decreaseModFileSize(long size) {
        this.modFileSize.addAndGet(-size);
    }
}

