/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile;

import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.db.exception.metadata.schemafile.ColossalRecordException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISegment;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.RecordUtils;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.SchemaFileConfig;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class WrappedSegment
implements ISegment<ByteBuffer, ICachedMNode> {
    protected final ByteBuffer buffer;
    protected short length;
    protected short freeAddr;
    protected short recordNum;
    protected short pairLength;
    protected boolean delFlag;
    protected boolean aliasFlag;
    protected long prevSegAddress;
    protected long nextSegAddress;
    protected String penuKey = null;
    protected String lastKey = null;

    public WrappedSegment(ByteBuffer buffer, boolean override) {
        this.buffer = buffer;
        this.buffer.clear();
        if (override) {
            this.length = (short)buffer.capacity();
            this.freeAddr = (short)buffer.capacity();
            this.recordNum = 0;
            this.pairLength = 0;
            this.prevSegAddress = -1L;
            this.nextSegAddress = -1L;
            this.delFlag = false;
            this.aliasFlag = false;
        } else {
            this.length = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.freeAddr = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.recordNum = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.pairLength = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
            this.prevSegAddress = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            this.nextSegAddress = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            byte flags = ReadWriteIOUtils.readByte((ByteBuffer)buffer);
            this.delFlag = (0x80 & flags) != 0;
            this.aliasFlag = (0x40 & flags) != 0;
        }
    }

    public WrappedSegment(ByteBuffer buffer) throws RecordDuplicatedException {
        this(buffer, true);
    }

    public WrappedSegment(int size) throws RecordDuplicatedException {
        this(ByteBuffer.allocate(size));
    }

    public static ISegment<ByteBuffer, ICachedMNode> initAsSegment(ByteBuffer buffer) throws RecordDuplicatedException {
        if (buffer == null) {
            return null;
        }
        return new WrappedSegment(buffer, true);
    }

    public static ISegment<ByteBuffer, ICachedMNode> loadAsSegment(ByteBuffer buffer) throws RecordDuplicatedException {
        if (buffer == null) {
            return null;
        }
        return new WrappedSegment(buffer, false);
    }

    @Override
    public boolean hasRecordKey(String key) {
        return this.binarySearchOnKeys(key) > -1;
    }

    @Override
    public boolean hasRecordAlias(String alias) {
        return this.getIndexByAlias(alias) > -1;
    }

    @Override
    public synchronized void syncBuffer() {
        ByteBuffer prefBuffer = ByteBuffer.allocate(25);
        ReadWriteIOUtils.write((short)this.length, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.freeAddr, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.recordNum, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((short)this.pairLength, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((long)this.prevSegAddress, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((long)this.nextSegAddress, (ByteBuffer)prefBuffer);
        ReadWriteIOUtils.write((byte)this.getFlag(), (ByteBuffer)prefBuffer);
        prefBuffer.clear();
        this.buffer.clear();
        this.buffer.put(prefBuffer);
    }

    private byte getFlag() {
        byte flags = this.delFlag ? (byte)-128 : 0;
        flags = (byte)(this.aliasFlag ? flags | 0x40 : flags | 0);
        return flags;
    }

    @Override
    public short size() {
        return this.length;
    }

    @Override
    public short getSpareSize() {
        return (short)(this.freeAddr - this.pairLength - 25);
    }

    @Override
    public void delete() {
        this.delFlag = true;
        this.buffer.clear();
        this.buffer.position(24);
        ReadWriteIOUtils.write((byte)this.getFlag(), (ByteBuffer)this.buffer);
    }

    @Override
    public long getNextSegAddress() {
        return this.nextSegAddress;
    }

    @Override
    public void setNextSegAddress(long nextSegAddress) {
        this.nextSegAddress = nextSegAddress;
    }

    @Override
    public synchronized int insertRecord(String key, ByteBuffer buf) throws RecordDuplicatedException {
        buf.clear();
        byte[] ikBytes = key.getBytes();
        int recordStartAddr = this.freeAddr - buf.capacity() - 4 - ikBytes.length;
        int newPairLength = this.pairLength + 2;
        if (recordStartAddr < 25 + newPairLength) {
            return -1;
        }
        this.pairLength = (short)newPairLength;
        int tarIdx = this.binaryInsertOnKeys(key);
        if (this.aliasFlag && this.getIndexByAlias(key) != -1) {
            throw new RecordDuplicatedException(String.format("Record [%s] has conflict name with alias of its siblings.", key));
        }
        String alias = RecordUtils.getRecordAlias(buf);
        if (alias != null && !alias.equals("")) {
            if (this.binarySearchOnKeys(alias) >= 0 || this.getIndexByAlias(alias) != -1) {
                throw new RecordDuplicatedException(String.format("Record [%s] has conflict alias [%s] with its siblings.", key, alias));
            }
            this.aliasFlag = true;
        }
        buf.clear();
        this.buffer.clear();
        this.buffer.position(recordStartAddr);
        ReadWriteIOUtils.write((String)key, (ByteBuffer)this.buffer);
        this.buffer.put(buf);
        this.buffer.clear().position(25 + tarIdx * 2);
        int shiftOffsets = this.recordNum - tarIdx;
        if (shiftOffsets > 0) {
            short[] shifts = new short[shiftOffsets];
            this.buffer.asShortBuffer().get(shifts);
            this.buffer.position(25 + tarIdx * 2);
            this.buffer.putShort((short)recordStartAddr);
            this.buffer.asShortBuffer().put(shifts);
        } else {
            this.buffer.putShort((short)recordStartAddr);
        }
        this.freeAddr = (short)recordStartAddr;
        this.recordNum = (short)(this.recordNum + 1);
        this.penuKey = this.lastKey;
        this.lastKey = key;
        return recordStartAddr - this.pairLength - 25;
    }

    private int getIndexByAlias(String target) {
        ByteBuffer checkBuffer = this.buffer.asReadOnlyBuffer();
        short[] offsets = new short[this.recordNum];
        checkBuffer.position(25).limit(25 + this.pairLength);
        checkBuffer.asShortBuffer().get(offsets);
        checkBuffer.clear();
        for (int i = 0; i < offsets.length; ++i) {
            checkBuffer.position(offsets[i]);
            int keySize = checkBuffer.getInt();
            checkBuffer.position(checkBuffer.position() + keySize);
            if (!target.equals(RecordUtils.getRecordAlias(checkBuffer))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void extendsTo(ByteBuffer newBuffer) throws MetadataException {
        short sizeGap = (short)(newBuffer.capacity() - this.length);
        if (sizeGap < 0) {
            throw new MetadataException("Leaf Segment cannot extend to a smaller buffer.");
        }
        this.buffer.clear();
        newBuffer.clear();
        if (sizeGap == 0) {
            this.syncBuffer();
            this.buffer.clear();
            newBuffer.put(this.buffer);
            this.buffer.clear();
            newBuffer.clear();
            return;
        }
        ReadWriteIOUtils.write((short)((short)newBuffer.capacity()), (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)((short)(this.freeAddr + sizeGap)), (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)this.recordNum, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((short)this.pairLength, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((long)this.prevSegAddress, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((long)this.nextSegAddress, (ByteBuffer)newBuffer);
        ReadWriteIOUtils.write((byte)this.getFlag(), (ByteBuffer)newBuffer);
        newBuffer.position(25);
        this.buffer.position(25);
        for (int i = 0; i < this.recordNum; ++i) {
            newBuffer.putShort((short)(this.buffer.getShort() + sizeGap));
        }
        this.buffer.clear();
        this.buffer.position(this.freeAddr);
        this.buffer.limit(this.length);
        newBuffer.position(this.freeAddr + sizeGap);
        newBuffer.put(this.buffer);
        newBuffer.clear();
        this.buffer.clear();
    }

    @Override
    public ByteBuffer resetBuffer(int ptr) {
        this.freeAddr = (short)this.buffer.capacity();
        this.recordNum = 0;
        this.pairLength = 0;
        this.prevSegAddress = -1L;
        this.nextSegAddress = -1L;
        this.delFlag = false;
        this.aliasFlag = false;
        this.syncBuffer();
        this.buffer.clear();
        return this.buffer.slice();
    }

    @Override
    public synchronized String splitByKey(String key, ByteBuffer recBuf, ByteBuffer dstBuffer, boolean inclineSplit) throws MetadataException {
        int pos;
        if (this.buffer.capacity() != dstBuffer.capacity()) {
            throw new MetadataException("Segments only splits with same capacity.");
        }
        if (this.recordNum == 0) {
            throw new MetadataException("Segment can not be split with no records.");
        }
        if (key == null && this.recordNum == 1) {
            throw new MetadataException("Segment can not be split with only one record.");
        }
        boolean monotonic = this.penuKey != null && key != null && this.lastKey != null && inclineSplit && key.compareTo(this.lastKey) * this.lastKey.compareTo(this.penuKey) > 0;
        int n = this.recordNum;
        int n2 = pos = key != null ? this.binaryInsertOnKeys(key) - 1 : -2;
        int sp = monotonic ? (key.compareTo(this.lastKey) > 0 ? Math.max(pos + 1, n / 2) : Math.min(pos + 2, n / 2)) : n / 2;
        sp = sp <= 0 ? 1 : sp;
        short recordLeft = this.recordNum;
        short length = this.length;
        short freeAddr = (short)dstBuffer.capacity();
        short recordNum = 0;
        short pairLength = 0;
        long prevSegAddress = this.prevSegAddress;
        long nextSegAddress = this.nextSegAddress;
        String sKey = null;
        n = key == null ? n - 1 : n;
        for (int ix = sp; ix <= n; ++ix) {
            int keySize;
            String mKey;
            int recSize;
            ByteBuffer srcBuf;
            if (ix == pos + 1) {
                srcBuf = recBuf;
                recSize = recBuf.capacity();
                mKey = key;
                keySize = 4 + mKey.getBytes().length;
                recBuf.clear();
            } else {
                srcBuf = this.buffer;
                int aix = ix > pos && pos != -2 ? ix - 1 : ix;
                mKey = this.getKeyByIndex(aix);
                keySize = 4 + mKey.getBytes().length;
                this.buffer.clear();
                this.buffer.position(this.getOffsetByIndex(aix) + keySize);
                recSize = this.getRecordLength();
                this.buffer.limit(this.buffer.position() + recSize);
                recordLeft = (short)(recordLeft - 1);
            }
            if (ix == sp) {
                sKey = mKey;
            }
            freeAddr = (short)(freeAddr - (recSize + keySize));
            dstBuffer.position(freeAddr);
            ReadWriteIOUtils.write((String)mKey, (ByteBuffer)dstBuffer);
            dstBuffer.put(srcBuf);
            dstBuffer.position(25 + pairLength);
            ReadWriteIOUtils.write((short)freeAddr, (ByteBuffer)dstBuffer);
            recordNum = (short)(recordNum + 1);
            pairLength = (short)(pairLength + 2);
        }
        this.recordNum = recordLeft;
        this.compactRecords();
        if (sp > pos + 1 && key != null && this.insertRecord(key, recBuf) < 0) {
            throw new ColossalRecordException(key, recBuf.capacity());
        }
        dstBuffer.clear();
        ReadWriteIOUtils.write((short)length, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)freeAddr, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)recordNum, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((short)pairLength, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((long)prevSegAddress, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((long)nextSegAddress, (ByteBuffer)dstBuffer);
        ReadWriteIOUtils.write((byte)this.getFlag(), (ByteBuffer)dstBuffer);
        this.penuKey = null;
        this.lastKey = null;
        return sKey;
    }

    protected void compactRecords() {
        ByteBuffer tempBuf = ByteBuffer.allocate(this.buffer.capacity() - this.freeAddr);
        int accSiz = 0;
        short[] newOffsets = new short[this.recordNum];
        for (int i = 0; i < this.recordNum; ++i) {
            short migOffset = this.getOffsetByIndex(i);
            String migKey = this.getKeyByOffset(migOffset);
            this.buffer.position(migOffset + 4 + migKey.getBytes().length);
            short recLen = this.getRecordLength();
            this.buffer.clear();
            this.buffer.position(migOffset);
            this.buffer.limit(migOffset + 4 + migKey.getBytes().length + recLen);
            newOffsets[i] = (short)(this.buffer.capacity() - (accSiz += this.buffer.remaining()));
            tempBuf.position(tempBuf.capacity() - accSiz);
            tempBuf.put(this.buffer);
        }
        tempBuf.clear();
        tempBuf.position(tempBuf.capacity() - accSiz);
        this.freeAddr = (short)(this.buffer.capacity() - accSiz);
        this.buffer.clear();
        this.buffer.position(25);
        this.buffer.asShortBuffer().put(newOffsets);
        this.buffer.position(this.freeAddr);
        this.buffer.put(tempBuf);
        this.syncBuffer();
    }

    private short getRecordLength() {
        return RecordUtils.getRecordLength(this.buffer);
    }

    @Override
    public ICachedMNode getRecordByKey(String key) throws MetadataException {
        int index = this.binarySearchOnKeys(key);
        if (index < 0) {
            return null;
        }
        ByteBuffer roBuffer = this.buffer.asReadOnlyBuffer();
        short offset = this.getOffsetByIndex(index);
        roBuffer.clear();
        roBuffer.position(offset + key.getBytes().length + 4);
        short len = RecordUtils.getRecordLength(roBuffer);
        roBuffer.limit(offset + key.getBytes().length + 4 + len);
        return RecordUtils.buffer2Node(key, roBuffer);
    }

    @Override
    public ICachedMNode getRecordByAlias(String alias) throws MetadataException {
        int ix = this.getIndexByAlias(alias);
        if (ix < 0) {
            return null;
        }
        ByteBuffer rBuffer = this.buffer.asReadOnlyBuffer();
        short offset = this.getOffsetByIndex(ix);
        rBuffer.position(offset);
        String key = ReadWriteIOUtils.readString((ByteBuffer)rBuffer);
        rBuffer.limit(rBuffer.position() + RecordUtils.getRecordLength(rBuffer));
        return RecordUtils.buffer2Node(key, rBuffer);
    }

    @Override
    public Queue<ICachedMNode> getAllRecords() throws MetadataException {
        ArrayDeque<ICachedMNode> res = new ArrayDeque<ICachedMNode>(this.recordNum);
        ByteBuffer roBuffer = this.buffer.asReadOnlyBuffer();
        short[] offsets = new short[this.recordNum];
        roBuffer.position(25);
        roBuffer.asShortBuffer().get(offsets);
        roBuffer.clear();
        for (short offset : offsets) {
            roBuffer.clear();
            roBuffer.position(offset);
            String key = ReadWriteIOUtils.readString((ByteBuffer)roBuffer);
            short len = RecordUtils.getRecordLength(roBuffer);
            roBuffer.limit(roBuffer.position() + len);
            res.add(RecordUtils.buffer2Node(key, roBuffer));
        }
        return res;
    }

    @Override
    public int updateRecord(String key, ByteBuffer uBuffer) throws MetadataException {
        int idx = this.binarySearchOnKeys(key);
        if (idx < 0) {
            throw new MetadataException(String.format("Record[key:%s] Not Existed.", key));
        }
        this.buffer.clear();
        uBuffer.clear();
        this.buffer.position(this.getOffsetByIndex(idx) + 4 + key.getBytes().length);
        short oriLen = RecordUtils.getRecordLength(this.buffer);
        short newLen = (short)uBuffer.capacity();
        if (oriLen >= newLen) {
            this.buffer.limit(this.buffer.position() + oriLen);
            this.buffer.put(uBuffer);
        } else {
            if (25 + this.pairLength + newLen + 4 + key.getBytes().length > this.freeAddr) {
                return -1;
            }
            this.freeAddr = (short)(this.freeAddr - newLen - 4 - key.getBytes().length);
            this.buffer.position(this.freeAddr);
            ReadWriteIOUtils.write((String)key, (ByteBuffer)this.buffer);
            this.buffer.put(uBuffer);
            this.buffer.position(25 + 2 * idx);
            this.buffer.putShort(this.freeAddr);
        }
        return idx;
    }

    @Override
    public int removeRecord(String key) {
        int idx = this.binarySearchOnKeys(key);
        if (idx < 0) {
            return -1;
        }
        short offset = this.getOffsetByIndex(idx);
        if (offset == this.freeAddr) {
            this.buffer.position(offset + 4 + key.getBytes().length);
            short len = RecordUtils.getRecordLength(this.buffer);
            this.freeAddr = (short)(this.freeAddr + (len + 4 + key.getBytes().length));
        }
        if (idx != this.recordNum) {
            this.buffer.position(25 + idx * 2);
            ShortBuffer lb = this.buffer.asReadOnlyBuffer().asShortBuffer();
            lb.get();
            for (int shift = this.recordNum - idx; shift != 0; --shift) {
                this.buffer.putShort(lb.get());
            }
        }
        this.recordNum = (short)(this.recordNum - 1);
        this.pairLength = (short)(this.pairLength - 2);
        return idx;
    }

    protected void updateRecordSegAddr(String key, long newSegAddr) {
        int index = this.binarySearchOnKeys(key);
        short offset = this.getOffsetByIndex(index);
        this.buffer.clear();
        this.buffer.position(offset + 4 + key.getBytes().length);
        RecordUtils.updateSegAddr(this.buffer, newSegAddr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected short getOffsetByIndex(int index) {
        if (index < 0 || index >= this.recordNum) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(25 + index * 2);
            return ReadWriteIOUtils.readShort((ByteBuffer)this.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getKeyByOffset(short offset) {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(offset);
            return ReadWriteIOUtils.readString((ByteBuffer)this.buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getKeyByIndex(int index) {
        if (index < 0 || index >= this.recordNum) {
            throw new IndexOutOfBoundsException();
        }
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.buffer.limit(this.buffer.capacity()).position(25 + index * 2);
            this.buffer.position(ReadWriteIOUtils.readShort((ByteBuffer)this.buffer));
            return ReadWriteIOUtils.readString((ByteBuffer)this.buffer);
        }
    }

    protected int binarySearchOnKeys(String key) {
        int head = 0;
        int tail = this.recordNum - 1;
        if (tail < 0 || key.compareTo(this.getKeyByIndex(head)) < 0 || key.compareTo(this.getKeyByIndex(tail)) > 0) {
            return -1;
        }
        if (key.compareTo(this.getKeyByIndex(head)) == 0) {
            return head;
        }
        if (key.compareTo(this.getKeyByIndex(tail)) == 0) {
            return tail;
        }
        int pivot = (head + tail) / 2;
        while (key.compareTo(this.getKeyByIndex(pivot)) != 0) {
            if (head == tail || pivot == head || pivot == tail) {
                return -1;
            }
            if (key.compareTo(this.getKeyByIndex(pivot)) < 0) {
                tail = pivot;
            } else if (key.compareTo(this.getKeyByIndex(pivot)) > 0) {
                head = pivot;
            }
            pivot = (head + tail) / 2;
        }
        return pivot;
    }

    protected int binaryInsertOnKeys(String key) throws RecordDuplicatedException {
        if (this.recordNum == 0) {
            return 0;
        }
        int tarIdx = 0;
        int head = 0;
        int tail = this.recordNum - 1;
        if (this.getKeyByIndex(head).compareTo(key) == 0 || this.getKeyByIndex(tail).compareTo(key) == 0) {
            throw new RecordDuplicatedException(key);
        }
        if (key.compareTo(this.getKeyByIndex(head)) < 0) {
            return 0;
        }
        if (key.compareTo(this.getKeyByIndex(tail)) > 0) {
            return this.recordNum;
        }
        while (head != tail) {
            int pivot = (head + tail) / 2;
            if (this.getKeyByIndex(pivot).compareTo(key) == 0 || this.getKeyByIndex(pivot + 1).compareTo(key) == 0) {
                throw new RecordDuplicatedException(key);
            }
            if (this.getKeyByIndex(pivot).compareTo(key) < 0 && this.getKeyByIndex(pivot + 1).compareTo(key) > 0) {
                return pivot + 1;
            }
            if (pivot == head || pivot == tail) {
                if (this.getKeyByIndex(head).compareTo(key) > 0) {
                    return head;
                }
                if (this.getKeyByIndex(tail).compareTo(key) < 0) {
                    return tail + 1;
                }
            }
            if (this.getKeyByIndex(pivot).compareTo(key) > 0) {
                tail = pivot;
            }
            if (this.getKeyByIndex(pivot + 1).compareTo(key) >= 0) continue;
            head = pivot;
        }
        return tarIdx;
    }

    @Override
    public String toString() {
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder("");
        List<Pair<String, Short>> keyAddressList = this.getKeyOffsetList();
        builder.append(String.format("[size: %d, K-AL size: %d, spare:%d,", this.length, keyAddressList.size(), this.freeAddr - this.pairLength - 25));
        bufferR.clear();
        for (Pair<String, Short> pair : keyAddressList) {
            bufferR.position((Short)pair.right + 4 + ((String)pair.left).getBytes().length);
            if (RecordUtils.getRecordType(bufferR) == 0 || RecordUtils.getRecordType(bufferR) == 1) {
                builder.append(String.format("(%s -> %s),", pair.left, RecordUtils.getRecordSegAddr(bufferR) == -1L ? Integer.valueOf(-1) : Long.toHexString(RecordUtils.getRecordSegAddr(bufferR))));
                continue;
            }
            if (RecordUtils.getRecordType(bufferR) == 4) {
                builder.append(String.format("(%s, %s),", pair.left, RecordUtils.getRecordAlias(bufferR)));
                continue;
            }
            throw new BufferUnderflowException();
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public String inspect() {
        if (!SchemaFileConfig.DETAIL_SKETCH) {
            return "";
        }
        List<Pair<String, Short>> keyAddressList = this.getKeyOffsetList();
        ByteBuffer bufferR = this.buffer.asReadOnlyBuffer();
        StringBuilder builder = new StringBuilder("");
        builder.append(String.format("[length: %d, total_records: %d, spare_size:%d,", this.length, keyAddressList.size(), this.freeAddr - this.pairLength - 25));
        bufferR.clear();
        for (Pair<String, Short> pair : keyAddressList) {
            bufferR.position((Short)pair.right + ((String)pair.left).getBytes().length + 4);
            if (RecordUtils.getRecordType(bufferR) == 0 || RecordUtils.getRecordType(bufferR) == 1) {
                Boolean isAligned = RecordUtils.getAlignment(bufferR);
                builder.append(String.format("(%s, %s, %s),", pair.left, isAligned == null ? "null" : (isAligned != false ? "aligned" : "not_aligned"), RecordUtils.getRecordSegAddr(bufferR) == -1L ? Integer.valueOf(-1) : Long.toHexString(RecordUtils.getRecordSegAddr(bufferR))));
                continue;
            }
            if (RecordUtils.getRecordType(bufferR) == 4) {
                byte[] schemaBytes = RecordUtils.getMeasStatsBytes(bufferR);
                builder.append(String.format("(%s, %s, %s, %s, %s),", pair.left, TSDataType.values()[schemaBytes[0]], TSEncoding.values()[schemaBytes[1]], CompressionType.deserialize((byte)schemaBytes[2]), RecordUtils.getRecordAlias(bufferR)));
                continue;
            }
            if (RecordUtils.getRecordType(bufferR) == 5) {
                int oriPos = bufferR.position();
                bufferR.position(oriPos + 3);
                long of = ReadWriteIOUtils.readLong((ByteBuffer)bufferR);
                boolean pred = ReadWriteIOUtils.readBool((ByteBuffer)bufferR);
                ViewExpression viewExpression = ViewExpression.deserialize((ByteBuffer)bufferR);
                builder.append(String.format("view(%s, %s, %s, %s),", pair.left, of, pred, viewExpression.toString()));
                continue;
            }
            throw new BufferUnderflowException();
        }
        builder.append("]");
        return builder.toString();
    }

    static short getSegBufLen(ByteBuffer buffer) {
        short res = ReadWriteIOUtils.readShort((ByteBuffer)buffer);
        buffer.position(buffer.position() - 2);
        return res;
    }

    public ByteBuffer getBufferCopy() {
        this.syncBuffer();
        ByteBuffer newBuffer = ByteBuffer.allocate(this.buffer.capacity());
        this.buffer.clear();
        newBuffer.put(this.buffer);
        newBuffer.clear();
        return newBuffer;
    }

    public ByteBuffer getRecord(String key) {
        int idx = this.binarySearchOnKeys(key);
        if (idx >= 0) {
            short targetAddr = this.getOffsetByIndex(idx);
            this.buffer.clear();
            this.buffer.position(targetAddr);
            this.buffer.position(targetAddr + 4 + this.buffer.getInt());
            short len = RecordUtils.getRecordLength(this.buffer);
            this.buffer.limit(this.buffer.position() + len);
            return this.buffer.slice();
        }
        return null;
    }

    public List<Pair<String, Short>> getKeyOffsetList() {
        short[] offsets = this.getOffsets();
        ArrayList<Pair<String, Short>> res = new ArrayList<Pair<String, Short>>();
        ByteBuffer buffer = this.buffer.asReadOnlyBuffer();
        buffer.clear();
        for (short offset : offsets) {
            buffer.position(offset);
            res.add((Pair<String, Short>)new Pair((Object)ReadWriteIOUtils.readString((ByteBuffer)buffer), (Object)offset));
        }
        return res;
    }

    public short[] getOffsets() {
        ByteBuffer buf = this.buffer.asReadOnlyBuffer();
        short[] ofs = new short[this.recordNum];
        buf.clear().position(25);
        buf.asShortBuffer().get(ofs);
        return ofs;
    }
}

