/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.iotdb.commons.schema.MergeSortIterator;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.IMNodeChildBuffer;

public abstract class MNodeChildBuffer
implements IMNodeChildBuffer {
    protected Map<String, ICachedMNode> flushingBuffer;
    protected Map<String, ICachedMNode> receivingBuffer;
    protected int totalSize = 0;
    private static final IMNodeChildBuffer EMPTY_BUFFER = new EmptyBuffer();

    public static IMNodeChildBuffer emptyMNodeChildBuffer() {
        return EMPTY_BUFFER;
    }

    @Override
    public Iterator<ICachedMNode> getMNodeChildBufferIterator() {
        return new MNodeChildBufferIterator();
    }

    @Override
    public Map<String, ICachedMNode> getFlushingBuffer() {
        return this.flushingBuffer == null ? Collections.emptyMap() : this.flushingBuffer;
    }

    @Override
    public Map<String, ICachedMNode> getReceivingBuffer() {
        return this.receivingBuffer == null ? Collections.emptyMap() : this.receivingBuffer;
    }

    @Override
    public void transferReceivingBufferToFlushingBuffer() {
        if (this.flushingBuffer == null) {
            this.flushingBuffer = new ConcurrentHashMap<String, ICachedMNode>();
        }
        if (this.receivingBuffer != null) {
            this.flushingBuffer.putAll(this.receivingBuffer);
            this.receivingBuffer.clear();
        }
    }

    public int size() {
        return this.totalSize;
    }

    public boolean isEmpty() {
        return this.totalSize == 0;
    }

    private boolean containKey(Map<String, ICachedMNode> map, Object key) {
        return map != null && map.containsKey(key);
    }

    public boolean containsKey(Object key) {
        return this.containKey(this.flushingBuffer, key) || this.containKey(this.receivingBuffer, key);
    }

    private boolean containValue(Map<String, ICachedMNode> map, Object value) {
        return map != null && map.containsValue(value);
    }

    public boolean containsValue(Object value) {
        return this.containValue(this.flushingBuffer, value) || this.containValue(this.receivingBuffer, value);
    }

    protected ICachedMNode get(Map<String, ICachedMNode> map, Object key) {
        return map != null ? map.get(key) : null;
    }

    public synchronized ICachedMNode get(Object key) {
        ICachedMNode result = this.get(this.receivingBuffer, key);
        if (result != null) {
            return result;
        }
        return this.get(this.flushingBuffer, key);
    }

    private ICachedMNode remove(Map<String, ICachedMNode> map, Object key) {
        return map == null ? null : map.remove(key);
    }

    public synchronized ICachedMNode remove(Object key) {
        ICachedMNode result;
        ICachedMNode result1 = this.remove(this.flushingBuffer, key);
        ICachedMNode result2 = this.remove(this.receivingBuffer, key);
        ICachedMNode iCachedMNode = result = result1 != null ? result1 : result2;
        if (result != null) {
            --this.totalSize;
        }
        return result;
    }

    public void clear() {
        if (this.receivingBuffer != null) {
            this.receivingBuffer.clear();
        }
        if (this.flushingBuffer != null) {
            this.flushingBuffer.clear();
        }
        this.totalSize = 0;
    }

    private Set<String> keySet(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Nonnull
    public Set<String> keySet() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.keySet(this.receivingBuffer));
        result.addAll(this.keySet(this.flushingBuffer));
        return result;
    }

    private Collection<ICachedMNode> values(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptyList() : map.values();
    }

    @Nonnull
    public Collection<ICachedMNode> values() {
        HashSet<ICachedMNode> result = new HashSet<ICachedMNode>();
        result.addAll(this.values(this.flushingBuffer));
        result.addAll(this.values(this.receivingBuffer));
        return result;
    }

    private Set<Map.Entry<String, ICachedMNode>> entrySet(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptySet() : map.entrySet();
    }

    @Nonnull
    public Set<Map.Entry<String, ICachedMNode>> entrySet() {
        HashSet<Map.Entry<String, ICachedMNode>> result = new HashSet<Map.Entry<String, ICachedMNode>>();
        result.addAll(this.entrySet(this.receivingBuffer));
        result.addAll(this.entrySet(this.flushingBuffer));
        return result;
    }

    @Nullable
    public synchronized ICachedMNode replace(String key, ICachedMNode value) {
        throw new UnsupportedOperationException();
    }

    private Iterator<ICachedMNode> getSortedReceivingBuffer() {
        ArrayList<ICachedMNode> receivingBufferList = new ArrayList<ICachedMNode>(this.getReceivingBuffer().values());
        receivingBufferList.sort(Comparator.comparing(IMNode::getName));
        return receivingBufferList.iterator();
    }

    private Iterator<ICachedMNode> getSortedFlushingBuffer() {
        ArrayList<ICachedMNode> flushingBufferList = new ArrayList<ICachedMNode>(this.getFlushingBuffer().values());
        flushingBufferList.sort(Comparator.comparing(IMNode::getName));
        return flushingBufferList.iterator();
    }

    private static class EmptyBuffer
    extends AbstractMap<String, ICachedMNode>
    implements IMNodeChildBuffer {
        private EmptyBuffer() {
        }

        @Override
        public Iterator<ICachedMNode> getMNodeChildBufferIterator() {
            return Collections.emptyIterator();
        }

        @Override
        public Map<String, ICachedMNode> getFlushingBuffer() {
            return Collections.emptyMap();
        }

        @Override
        public Map<String, ICachedMNode> getReceivingBuffer() {
            return Collections.emptyMap();
        }

        @Override
        public void transferReceivingBufferToFlushingBuffer() {
        }

        @Override
        public ICachedMNode removeFromFlushingBuffer(Object key) {
            return null;
        }

        @Override
        @Nonnull
        public Set<Map.Entry<String, ICachedMNode>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public ICachedMNode get(Object key) {
            return null;
        }

        @Override
        @Nonnull
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        @Nonnull
        public Collection<ICachedMNode> values() {
            return Collections.emptySet();
        }
    }

    private class MNodeChildBufferIterator
    extends MergeSortIterator<ICachedMNode> {
        MNodeChildBufferIterator() {
            super(MNodeChildBuffer.this.getSortedReceivingBuffer(), MNodeChildBuffer.this.getSortedFlushingBuffer());
        }

        protected int decide() {
            return -1;
        }

        protected int compare(ICachedMNode left, ICachedMNode right) {
            return left.getName().compareTo(right.getName());
        }
    }
}

