/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.schema.MergeSortIterator;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.IMNodeChildBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.MNodeChildBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.MNodeNewChildBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.MNodeUpdateChildBuffer;

public class CachedMNodeContainer
implements ICachedMNodeContainer {
    private long segmentAddress = -1L;
    private Map<String, ICachedMNode> childCache = null;
    private MNodeNewChildBuffer newChildBuffer = null;
    private MNodeUpdateChildBuffer updatedChildBuffer = null;
    private static final IMNodeContainer<ICachedMNode> EMPTY_CONTAINER = new EmptyContainer();

    public static IMNodeContainer<ICachedMNode> emptyMNodeContainer() {
        return EMPTY_CONTAINER;
    }

    public int size() {
        return this.getSize(this.childCache) + this.getSize((Map<String, ICachedMNode>)((Object)this.newChildBuffer)) + this.getSize((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer));
    }

    private int getSize(Map<String, ICachedMNode> map) {
        return map == null ? 0 : map.size();
    }

    public boolean isEmpty() {
        return this.isEmpty(this.childCache) && this.isEmpty((Map<String, ICachedMNode>)((Object)this.newChildBuffer)) && this.isEmpty((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer));
    }

    private boolean isEmpty(Map<String, ICachedMNode> map) {
        return map == null || map.isEmpty();
    }

    public boolean containsKey(Object key) {
        return this.containsKey(this.childCache, key) || this.containsKey((Map<String, ICachedMNode>)((Object)this.newChildBuffer), key) || this.containsKey((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer), key);
    }

    private boolean containsKey(Map<String, ICachedMNode> map, Object key) {
        return map != null && map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.containsValue(this.childCache, value) || this.containsValue((Map<String, ICachedMNode>)((Object)this.newChildBuffer), value) || this.containsValue((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer), value);
    }

    private boolean containsValue(Map<String, ICachedMNode> map, Object value) {
        return map != null && map.containsValue(value);
    }

    public synchronized ICachedMNode get(Object key) {
        return this.internalGet(key);
    }

    private ICachedMNode internalGet(Object key) {
        ICachedMNode result = this.get(this.childCache, key);
        if (result != null) {
            return result;
        }
        result = this.get((Map<String, ICachedMNode>)((Object)this.newChildBuffer), key);
        if (result != null) {
            return result;
        }
        return this.get((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer), key);
    }

    private ICachedMNode get(Map<String, ICachedMNode> map, Object key) {
        return map == null ? null : map.get(key);
    }

    @Nullable
    public synchronized ICachedMNode put(String key, ICachedMNode value) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new MNodeNewChildBuffer();
        }
        return this.newChildBuffer.put(key, value);
    }

    @Nullable
    public synchronized ICachedMNode putIfAbsent(String key, ICachedMNode value) {
        ICachedMNode node = this.internalGet(key);
        if (node == null) {
            if (this.newChildBuffer == null) {
                this.newChildBuffer = new MNodeNewChildBuffer();
            }
            node = this.newChildBuffer.put(key, value);
        }
        return node;
    }

    public synchronized ICachedMNode remove(Object key) {
        ICachedMNode result = this.removeFromMap(this.childCache, key);
        if (result == null) {
            result = this.removeFromMap((Map<String, ICachedMNode>)((Object)this.newChildBuffer), key);
        }
        if (result == null) {
            result = this.removeFromMap((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer), key);
        }
        return result;
    }

    private ICachedMNode removeFromMap(Map<String, ICachedMNode> map, Object key) {
        return map == null ? null : map.remove(key);
    }

    public synchronized void putAll(@Nonnull Map<? extends String, ? extends ICachedMNode> m) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new MNodeNewChildBuffer();
        }
        this.newChildBuffer.putAll(m);
    }

    public synchronized void clear() {
        this.childCache = null;
        this.newChildBuffer = null;
        this.updatedChildBuffer = null;
    }

    @Nonnull
    public Set<String> keySet() {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(this.keySet(this.childCache));
        result.addAll(this.keySet((Map<String, ICachedMNode>)((Object)this.newChildBuffer)));
        result.addAll(this.keySet((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer)));
        return result;
    }

    private Set<String> keySet(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptySet() : map.keySet();
    }

    @Nonnull
    public Collection<ICachedMNode> values() {
        ArrayList<ICachedMNode> result = new ArrayList<ICachedMNode>();
        result.addAll(this.getValues(this.childCache));
        result.addAll(this.getValues((Map<String, ICachedMNode>)((Object)this.newChildBuffer)));
        result.addAll(this.getValues((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer)));
        return result;
    }

    private Collection<ICachedMNode> getValues(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptyList() : map.values();
    }

    @Nonnull
    public Set<Map.Entry<String, ICachedMNode>> entrySet() {
        HashSet<Map.Entry<String, ICachedMNode>> result = new HashSet<Map.Entry<String, ICachedMNode>>();
        result.addAll(this.entrySet(this.childCache));
        result.addAll(this.entrySet((Map<String, ICachedMNode>)((Object)this.newChildBuffer)));
        result.addAll(this.entrySet((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer)));
        return result;
    }

    private Set<Map.Entry<String, ICachedMNode>> entrySet(Map<String, ICachedMNode> map) {
        return map == null ? Collections.emptySet() : map.entrySet();
    }

    @Nullable
    public synchronized ICachedMNode replace(String key, ICachedMNode value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getSegmentAddress() {
        return this.segmentAddress;
    }

    @Override
    public void setSegmentAddress(long segmentAddress) {
        this.segmentAddress = segmentAddress;
    }

    @Override
    public boolean isVolatile() {
        return this.segmentAddress == -1L;
    }

    @Override
    public boolean hasChildInNewChildBuffer(String name) {
        return this.containsKey((Map<String, ICachedMNode>)((Object)this.newChildBuffer), name);
    }

    @Override
    public boolean hasChildInBuffer(String name) {
        return this.containsKey((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer), name) || this.containsKey((Map<String, ICachedMNode>)((Object)this.newChildBuffer), name);
    }

    @Override
    public boolean hasChildrenInBuffer() {
        return !this.isEmpty((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer)) || !this.isEmpty((Map<String, ICachedMNode>)((Object)this.newChildBuffer));
    }

    @Override
    public Iterator<ICachedMNode> getChildrenIterator() {
        return new CachedMNodeContainerIterator(0);
    }

    @Override
    public Iterator<ICachedMNode> getChildrenBufferIterator() {
        return new BufferIterator();
    }

    @Override
    public Map<String, ICachedMNode> getChildCache() {
        return this.childCache == null ? Collections.emptyMap() : this.childCache;
    }

    public IMNodeChildBuffer getNewChildBuffer() {
        return this.newChildBuffer == null ? MNodeChildBuffer.emptyMNodeChildBuffer() : this.newChildBuffer;
    }

    public IMNodeChildBuffer getUpdatedChildBuffer() {
        return this.updatedChildBuffer == null ? MNodeChildBuffer.emptyMNodeChildBuffer() : this.updatedChildBuffer;
    }

    @Override
    public Map<String, ICachedMNode> getNewChildFlushingBuffer() {
        return this.getNewChildBuffer().getFlushingBuffer();
    }

    @Override
    public Map<String, ICachedMNode> getUpdatedChildFlushingBuffer() {
        return this.getUpdatedChildBuffer().getFlushingBuffer();
    }

    @Override
    public Map<String, ICachedMNode> getUpdatedChildReceivingBuffer() {
        return this.getUpdatedChildBuffer().getReceivingBuffer();
    }

    @Override
    public void transferAllBufferReceivingToFlushing() {
        this.getNewChildBuffer().transferReceivingBufferToFlushingBuffer();
        this.getUpdatedChildBuffer().transferReceivingBufferToFlushingBuffer();
    }

    @Override
    public synchronized void loadChildrenFromDisk(Map<String, ICachedMNode> children) {
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.putAll(children);
    }

    @Override
    public synchronized void addChildToCache(ICachedMNode node) {
        String name = node.getName();
        if (this.containsKey(name)) {
            return;
        }
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void appendMNode(ICachedMNode node) {
        if (this.newChildBuffer == null) {
            this.newChildBuffer = new MNodeNewChildBuffer();
        }
        this.newChildBuffer.put(node.getName(), node);
    }

    @Override
    public synchronized void updateMNode(String name) {
        ICachedMNode node = this.removeFromMap(this.childCache, name);
        if (node != null) {
            if (this.updatedChildBuffer == null) {
                this.updatedChildBuffer = new MNodeUpdateChildBuffer();
            }
            this.updatedChildBuffer.put(name, node);
        }
    }

    @Override
    public synchronized void moveMNodeFromNewChildBufferToCache(String name) {
        ICachedMNode node = this.getNewChildBuffer().removeFromFlushingBuffer(name);
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void moveMNodeFromUpdateChildBufferToCache(String name) {
        ICachedMNode node = this.getUpdatedChildBuffer().removeFromFlushingBuffer(name);
        if (this.childCache == null) {
            this.childCache = new ConcurrentHashMap<String, ICachedMNode>();
        }
        this.childCache.put(name, node);
    }

    @Override
    public synchronized void evictMNode(String name) {
        this.removeFromMap(this.childCache, name);
    }

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CachedMNodeContainer:{");
        builder.append("childCache:[");
        for (ICachedMNode node : this.getValues(this.childCache)) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("newChildBuffer:[");
        for (ICachedMNode node : this.getValues((Map<String, ICachedMNode>)((Object)this.newChildBuffer))) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("updateChildBuffer:[");
        for (ICachedMNode node : this.getValues((Map<String, ICachedMNode>)((Object)this.updatedChildBuffer))) {
            builder.append(node.getName()).append(",");
        }
        builder.append("];");
        builder.append("}");
        return builder.toString();
    }

    private static class EmptyContainer
    extends AbstractMap<String, ICachedMNode>
    implements IMNodeContainer<ICachedMNode> {
        private EmptyContainer() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public ICachedMNode get(Object key) {
            return null;
        }

        @Override
        @NotNull
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Collection<ICachedMNode> values() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<Map.Entry<String, ICachedMNode>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }

    private class BufferIterator
    extends MergeSortIterator<ICachedMNode> {
        BufferIterator() {
            super(CachedMNodeContainer.this.getNewChildBuffer().getMNodeChildBufferIterator(), CachedMNodeContainer.this.getUpdatedChildBuffer().getMNodeChildBufferIterator());
        }

        protected int decide() {
            throw new IllegalStateException("There shall not exist two node with the same name separately in newChildBuffer and updateChildBuffer");
        }

        protected int compare(ICachedMNode left, ICachedMNode right) {
            return left.getName().compareTo(right.getName());
        }
    }

    private class CachedMNodeContainerIterator
    implements Iterator<ICachedMNode> {
        Iterator<ICachedMNode> iterator;
        byte status;

        CachedMNodeContainerIterator(byte status) {
            this.status = status;
            this.changeStatus();
        }

        @Override
        public boolean hasNext() {
            if (this.iterator.hasNext()) {
                return true;
            }
            while (!this.iterator.hasNext()) {
                if (this.changeStatus()) continue;
                return false;
            }
            return true;
        }

        @Override
        public ICachedMNode next() {
            return this.iterator.next();
        }

        private boolean changeStatus() {
            switch (this.status) {
                case 0: {
                    this.iterator = CachedMNodeContainer.this.getChildCache().values().iterator();
                    this.status = 1;
                    return true;
                }
                case 1: {
                    this.iterator = CachedMNodeContainer.this.getNewChildBuffer().getMNodeChildBufferIterator();
                    this.status = (byte)2;
                    return true;
                }
                case 2: {
                    this.iterator = CachedMNodeContainer.this.getUpdatedChildBuffer().getMNodeChildBufferIterator();
                    this.status = (byte)3;
                    return true;
                }
            }
            return false;
        }
    }
}

