/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.MergeSortIterator;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeFactory;
import org.apache.iotdb.commons.schema.node.utils.IMNodeIterator;
import org.apache.iotdb.db.exception.metadata.cache.MNodeNotCachedException;
import org.apache.iotdb.db.schemaengine.metric.SchemaRegionCachedMetric;
import org.apache.iotdb.db.schemaengine.rescon.CachedSchemaRegionStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.IMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.estimator.MNodeSizeEstimator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.ReentrantReadOnlyCachedMTreeStore;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.flush.PBTreeFlushExecutor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.lock.LockManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memcontrol.MemoryStatistics;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.IMemoryManager;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.ReleaseFlushMonitor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.container.ICachedMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.iterator.CachedTraverserIterator;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.schemafile.ISchemaFile;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.loader.MNodeFactoryLoader;
import org.apache.iotdb.db.schemaengine.schemaregion.utils.MNodeUtils;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachedMTreeStore
implements IMTreeStore<ICachedMNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachedMTreeStore.class);
    private final int schemaRegionId;
    private final MemoryStatistics memoryStatistics;
    private final IMemoryManager memoryManager;
    private ISchemaFile file;
    private ICachedMNode root;
    private final Runnable flushCallback;
    private final IMNodeFactory<ICachedMNode> nodeFactory = MNodeFactoryLoader.getInstance().getCachedMNodeIMNodeFactory();
    private final CachedSchemaRegionStatistics regionStatistics;
    private final SchemaRegionCachedMetric metric;
    private final ReleaseFlushMonitor releaseFlushMonitor = ReleaseFlushMonitor.getInstance();
    private final LockManager lockManager;

    public CachedMTreeStore(int schemaRegionId, CachedSchemaRegionStatistics regionStatistics, SchemaRegionCachedMetric metric, Runnable flushCallback, ISchemaFile schemaFile, IMemoryManager memoryManager, MemoryStatistics memoryStatistics, LockManager lockManager) throws MetadataException {
        this.schemaRegionId = schemaRegionId;
        this.regionStatistics = regionStatistics;
        this.flushCallback = flushCallback;
        this.lockManager = lockManager;
        this.file = schemaFile;
        this.root = this.file.init();
        this.memoryStatistics = memoryStatistics;
        this.memoryManager = memoryManager;
        this.metric = metric;
        memoryManager.initRootStatus(this.root);
        this.ensureMemoryStatus();
    }

    @Override
    public ICachedMNode generatePrefix(PartialPath storageGroupPath) {
        ICachedMNode res;
        String[] nodes = storageGroupPath.getNodes();
        ICachedMNode cur = res = (ICachedMNode)this.nodeFactory.createAboveDatabaseMNode(null, nodes[0]);
        for (int i = 1; i < nodes.length - 1; ++i) {
            ICachedMNode child = (ICachedMNode)this.nodeFactory.createAboveDatabaseMNode((IMNode)cur, nodes[i]);
            cur.addChild(nodes[i], child);
            cur = child;
        }
        this.root.setParent(cur);
        cur.addChild(this.root);
        return res;
    }

    public IMemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    public ISchemaFile getSchemaFile() {
        return this.file;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public ICachedMNode getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChild(ICachedMNode parent, String name) throws MetadataException {
        return this.hasChild(parent, name, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean hasChild(ICachedMNode parent, String name, boolean needGlobalLock, boolean needNodeLock) throws MetadataException {
        if (needGlobalLock) {
            this.lockManager.globalReadLock();
        }
        if (needNodeLock) {
            this.lockManager.threadReadLock(parent);
        }
        try {
            ICachedMNode child = this.getChild(parent, name, false, false);
            if (child == null) {
                boolean bl = false;
                return bl;
            }
            this.unPin(child, false);
            boolean bl = true;
            return bl;
        }
        finally {
            if (needNodeLock) {
                this.lockManager.threadReadUnlock(parent);
            }
            if (needGlobalLock) {
                this.lockManager.globalReadUnlock();
            }
        }
    }

    @Override
    public ICachedMNode getChild(ICachedMNode parent, String name) throws MetadataException {
        return this.getChild(parent, name, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ICachedMNode getChild(ICachedMNode parent, String name, boolean needGlobalLock, boolean needNodeLock) throws MetadataException {
        if (needGlobalLock) {
            this.lockManager.globalReadLock();
        }
        if (needNodeLock) {
            this.lockManager.threadReadLock(parent);
        }
        try {
            ICachedMNode node = (ICachedMNode)parent.getChild(name);
            if (node == null) {
                node = this.loadChildFromDisk(parent, name);
            } else {
                try {
                    this.memoryManager.updateCacheStatusAfterMemoryRead(node);
                }
                catch (MNodeNotCachedException e) {
                    node = this.loadChildFromDisk(parent, name);
                }
            }
            if (node != null && node.isMeasurement()) {
                this.processAlias((IDeviceMNode<ICachedMNode>)parent.getAsDeviceMNode(), (IMeasurementMNode<ICachedMNode>)node.getAsMeasurementMNode());
            }
            ICachedMNode iCachedMNode = node;
            return iCachedMNode;
        }
        finally {
            if (needNodeLock) {
                this.lockManager.threadReadUnlock(parent);
            }
            if (needGlobalLock) {
                this.lockManager.globalReadUnlock();
            }
        }
    }

    private ICachedMNode loadChildFromDisk(ICachedMNode parent, String name) throws MetadataException {
        ICachedMNode node = null;
        if (!ICachedMNodeContainer.getCachedMNodeContainer(parent).isVolatile()) {
            try {
                node = this.file.getChildNode(parent, name);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
            if (node != null) {
                node = this.loadChildFromDiskToParent(parent, node);
            }
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICachedMNode loadChildFromDiskToParent(ICachedMNode parent, ICachedMNode node) {
        ICachedMNode iCachedMNode = parent;
        synchronized (iCachedMNode) {
            ICachedMNode nodeAlreadyLoaded = (ICachedMNode)parent.getChild(node.getName());
            if (nodeAlreadyLoaded != null) {
                try {
                    this.memoryManager.updateCacheStatusAfterMemoryRead(nodeAlreadyLoaded);
                    return nodeAlreadyLoaded;
                }
                catch (MNodeNotCachedException mNodeNotCachedException) {
                    // empty catch block
                }
            }
            node.setParent(parent);
            this.metric.recordLoadFromDisk(node.estimateSize(), 1L);
            this.memoryManager.updateCacheStatusAfterDiskRead(node);
            this.ensureMemoryStatus();
            return node;
        }
    }

    private void processAlias(IDeviceMNode<ICachedMNode> parent, IMeasurementMNode<ICachedMNode> node) {
        String alias = node.getAlias();
        if (alias != null) {
            parent.addAlias(alias, node);
        }
    }

    @Override
    public IMNodeIterator<ICachedMNode> getChildrenIterator(ICachedMNode parent) throws MetadataException {
        return this.getChildrenIterator(parent, true);
    }

    final IMNodeIterator<ICachedMNode> getChildrenIterator(ICachedMNode parent, boolean needLock) throws MetadataException {
        try {
            return new CachedMNodeIterator(parent, needLock);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public IMNodeIterator<ICachedMNode> getTraverserIterator(ICachedMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        return this.getTraverserIterator(this, parent, templateMap, skipPreDeletedSchema);
    }

    final IMNodeIterator<ICachedMNode> getTraverserIterator(IMTreeStore<ICachedMNode> store, ICachedMNode parent, Map<Integer, Template> templateMap, boolean skipPreDeletedSchema) throws MetadataException {
        if (parent.isDevice()) {
            CachedTraverserIterator iterator = new CachedTraverserIterator(store, (IDeviceMNode<ICachedMNode>)parent.getAsDeviceMNode(), templateMap, this.nodeFactory);
            iterator.setSkipPreDeletedSchema(skipPreDeletedSchema);
            return iterator;
        }
        return store.getChildrenIterator(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICachedMNode addChild(ICachedMNode parent, String childName, ICachedMNode child) {
        this.lockManager.globalReadLock();
        this.lockManager.threadReadLock(parent);
        try {
            child.setParent(parent);
            this.memoryManager.updateCacheStatusAfterAppend(child);
            this.ensureMemoryStatus();
            ICachedMNode iCachedMNode = (ICachedMNode)parent.getChild(childName);
            return iCachedMNode;
        }
        finally {
            this.lockManager.threadReadUnlock(parent);
            this.lockManager.globalReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteChild(ICachedMNode parent, String childName) throws MetadataException {
        this.lockManager.globalWriteLock();
        try {
            ICachedMNode deletedMNode = this.getChild(parent, childName, false, false);
            ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
            if (!container.isVolatile() && !container.hasChildInNewChildBuffer(childName)) {
                try {
                    this.file.delete(deletedMNode);
                }
                catch (IOException e) {
                    throw new MetadataException((Throwable)e);
                }
            }
            parent.deleteChild(childName);
            this.memoryManager.remove(deletedMNode);
        }
        finally {
            this.lockManager.globalWriteUnlock();
        }
    }

    @Override
    public void updateMNode(ICachedMNode node, Consumer<ICachedMNode> operation) {
        this.updateMNode(node, operation, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void updateMNode(ICachedMNode node, Consumer<ICachedMNode> operation, boolean needLock) {
        if (needLock) {
            this.lockManager.globalReadLock();
        }
        if (!node.isDatabase()) {
            this.lockManager.threadReadLock((ICachedMNode)node.getParent(), true);
        }
        try {
            operation.accept(node);
            this.memoryManager.updateCacheStatusAfterUpdate(node);
        }
        finally {
            if (!node.isDatabase()) {
                this.lockManager.threadReadUnlock((ICachedMNode)node.getParent());
            }
            if (needLock) {
                this.lockManager.globalReadUnlock();
            }
        }
    }

    @Override
    public IDeviceMNode<ICachedMNode> setToEntity(ICachedMNode node) {
        int rawSize = node.estimateSize();
        AtomicReference<Boolean> resultReference = new AtomicReference<Boolean>(false);
        this.updateMNode(node, (ICachedMNode o) -> resultReference.getAndSet(MNodeUtils.setToEntity(node)));
        boolean isSuccess = resultReference.get();
        if (isSuccess) {
            this.regionStatistics.addDevice();
            this.memoryStatistics.updatePinnedSize(node.estimateSize() - rawSize);
        }
        return node.getAsDeviceMNode();
    }

    @Override
    public ICachedMNode setToInternal(IDeviceMNode<ICachedMNode> entityMNode) {
        int rawSize = entityMNode.estimateSize();
        AtomicReference<Boolean> resultReference = new AtomicReference<Boolean>(false);
        ICachedMNode internalMNode = (ICachedMNode)entityMNode.getAsMNode();
        this.updateMNode(internalMNode, (ICachedMNode o) -> resultReference.getAndSet(MNodeUtils.setToInternal(entityMNode)));
        boolean isSuccess = resultReference.get();
        if (isSuccess) {
            this.regionStatistics.deleteDevice();
            this.memoryStatistics.updatePinnedSize(internalMNode.estimateSize() - rawSize);
        }
        return internalMNode;
    }

    @Override
    public void setAlias(IMeasurementMNode<ICachedMNode> measurementMNode, String alias) throws MetadataException {
        String existingAlias = measurementMNode.getAlias();
        if (existingAlias == null && alias == null) {
            return;
        }
        this.updateMNode((ICachedMNode)measurementMNode.getAsMNode(), (ICachedMNode o) -> o.getAsMeasurementMNode().setAlias(alias));
        if (existingAlias != null && alias != null) {
            this.memoryStatistics.updatePinnedSize(alias.length() - existingAlias.length());
        } else if (alias == null) {
            this.memoryStatistics.updatePinnedSize(-(MNodeSizeEstimator.getAliasBaseSize() + existingAlias.length()));
        } else {
            this.memoryStatistics.updatePinnedSize(MNodeSizeEstimator.getAliasBaseSize() + alias.length());
        }
    }

    @Override
    public void pin(ICachedMNode node) throws MetadataException {
        this.pin(node, true);
    }

    final void pin(ICachedMNode node, boolean needLock) throws MetadataException {
        if (node.getParent() == null) {
            return;
        }
        if (needLock) {
            this.lockManager.globalReadLock();
        }
        if (!node.isDatabase()) {
            this.lockManager.threadReadLock((ICachedMNode)node.getParent());
        }
        try {
            this.memoryManager.pinMNode(node);
        }
        finally {
            if (!node.isDatabase()) {
                this.lockManager.threadReadUnlock((ICachedMNode)node.getParent());
            }
            if (needLock) {
                this.lockManager.globalReadUnlock();
            }
        }
    }

    @Override
    public void unPin(ICachedMNode node) {
        this.unPin(node, true);
    }

    final void unPin(ICachedMNode node, boolean needLock) {
        if (node.getParent() == null) {
            return;
        }
        if (needLock) {
            this.lockManager.globalReadLock();
        }
        if (!node.isDatabase()) {
            this.lockManager.threadReadLock((ICachedMNode)node.getParent(), true);
        }
        try {
            if (this.memoryManager.unPinMNode(node)) {
                this.ensureMemoryStatus();
            }
        }
        finally {
            if (!node.isDatabase()) {
                this.lockManager.threadReadUnlock((ICachedMNode)node.getParent());
            }
            if (needLock) {
                this.lockManager.globalReadUnlock();
            }
        }
    }

    @Override
    public void unPinPath(ICachedMNode node) {
        this.unPinPath(node, true);
    }

    public void unPinPath(ICachedMNode node, boolean needLock) {
        while (!node.isDatabase()) {
            this.unPin(node, needLock);
            node = (ICachedMNode)node.getParent();
        }
    }

    final long stampedReadLock() {
        return this.lockManager.globalStampedReadLock();
    }

    final void stampedReadUnlock(long stamp) {
        this.lockManager.globalStampedReadUnlock(stamp);
    }

    @Override
    public IMTreeStore<ICachedMNode> getWithReentrantReadLock() {
        return new ReentrantReadOnlyCachedMTreeStore(this);
    }

    @Override
    public void clear() {
        this.lockManager.globalWriteLock();
        try {
            this.releaseFlushMonitor.clearCachedMTreeStore(this);
            this.regionStatistics.setMemoryManager(null);
            this.memoryManager.clear(this.root);
            this.root = null;
            if (this.file != null) {
                try {
                    this.file.clear();
                    this.file.close();
                }
                catch (IOException | MetadataException e) {
                    LOGGER.error("Error occurred during PBTree clear, {}", (Object)e.getMessage(), (Object)e);
                }
            }
            this.file = null;
        }
        finally {
            this.lockManager.globalWriteUnlock();
        }
    }

    @Override
    public boolean createSnapshot(File snapshotDir) {
        this.lockManager.globalWriteLock();
        try {
            this.flushVolatileNodes(false);
            boolean bl = this.file.createSnapshot(snapshotDir);
            return bl;
        }
        finally {
            this.lockManager.globalWriteUnlock();
        }
    }

    @Override
    public ReleaseFlushMonitor.RecordNode recordTraverserStatistics() {
        return this.releaseFlushMonitor.recordTraverserTime(this.schemaRegionId);
    }

    @Override
    public void recordTraverserMetric(long costTime) {
        this.metric.recordTraverser(costTime);
    }

    public void recordReleaseMetrics(long costTime, long releaseNodeNum, long releaseMemorySize) {
        this.metric.recordRelease(costTime, releaseNodeNum, releaseMemorySize);
    }

    public void recordFlushMetrics(long costTime, long releaseNodeNum, long releaseMemorySize) {
        this.metric.recordFlush(costTime, releaseNodeNum, releaseMemorySize);
    }

    private void ensureMemoryStatus() {
        this.releaseFlushMonitor.ensureMemoryStatus();
    }

    public CachedSchemaRegionStatistics getRegionStatistics() {
        return this.regionStatistics;
    }

    public boolean executeMemoryRelease(AtomicLong releaseNodeNum, AtomicLong releaseMemorySize) {
        if (this.regionStatistics.getUnpinnedMemorySize() != 0L) {
            return !this.memoryManager.evict(releaseNodeNum, releaseMemorySize);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushVolatileNodes(boolean needLock) {
        if (needLock) {
            this.lockManager.globalReadLock();
        }
        long startTime = System.currentTimeMillis();
        AtomicLong flushNodeNum = new AtomicLong(0L);
        AtomicLong flushMemSize = new AtomicLong(0L);
        try {
            PBTreeFlushExecutor flushExecutor = new PBTreeFlushExecutor(this.memoryManager, this.file, this.lockManager);
            flushExecutor.flushVolatileNodes(flushNodeNum, flushMemSize);
        }
        catch (Throwable e) {
            LOGGER.error("Error occurred during MTree flush, current SchemaRegionId is {}", (Object)this.schemaRegionId, (Object)e);
        }
        finally {
            long time = System.currentTimeMillis() - startTime;
            if (time > 10000L) {
                LOGGER.info("It takes {}ms to flush MTree in SchemaRegion {}", (Object)time, (Object)this.schemaRegionId);
            } else {
                LOGGER.debug("It takes {}ms to flush MTree in SchemaRegion {}", (Object)time, (Object)this.schemaRegionId);
            }
            this.recordFlushMetrics(time, flushNodeNum.get(), flushMemSize.get());
            if (needLock) {
                this.lockManager.globalReadUnlock();
            }
        }
    }

    private class CachedMNodeIterator
    implements IMNodeIterator<ICachedMNode> {
        ICachedMNode parent;
        CachedMNodeMergeIterator mergeIterator;
        Iterator<ICachedMNode> bufferIterator;
        Iterator<ICachedMNode> diskIterator;
        boolean needLock;
        boolean isLocked;
        long readLockStamp;

        CachedMNodeIterator(ICachedMNode parent, boolean needLock) throws MetadataException, IOException {
            this.needLock = needLock;
            if (needLock) {
                CachedMTreeStore.this.lockManager.globalReadLock();
            }
            this.readLockStamp = CachedMTreeStore.this.lockManager.stampedReadLock(parent);
            this.isLocked = true;
            try {
                this.parent = parent;
                ICachedMNodeContainer container = ICachedMNodeContainer.getCachedMNodeContainer(parent);
                this.bufferIterator = container.getChildrenBufferIterator();
                this.diskIterator = !container.isVolatile() ? CachedMTreeStore.this.file.getChildren(parent) : Collections.emptyIterator();
                this.mergeIterator = new CachedMNodeMergeIterator(this.diskIterator, this.bufferIterator);
            }
            catch (Throwable e) {
                CachedMTreeStore.this.lockManager.stampedReadUnlock(parent, this.readLockStamp);
                if (needLock) {
                    CachedMTreeStore.this.lockManager.globalReadUnlock();
                }
                this.isLocked = false;
                throw e;
            }
        }

        public boolean hasNext() {
            return this.mergeIterator.hasNext();
        }

        public ICachedMNode next() {
            return (ICachedMNode)this.mergeIterator.next();
        }

        public void skipTemplateChildren() {
        }

        public void close() {
            if (this.isLocked) {
                CachedMTreeStore.this.lockManager.stampedReadUnlock(this.parent, this.readLockStamp);
                if (this.needLock) {
                    CachedMTreeStore.this.lockManager.globalReadUnlock();
                }
                this.isLocked = false;
            }
        }

        private class CachedMNodeMergeIterator
        extends MergeSortIterator<ICachedMNode> {
            public CachedMNodeMergeIterator(Iterator<ICachedMNode> diskIterator, Iterator<ICachedMNode> bufferIterator) {
                super(diskIterator, bufferIterator);
            }

            protected ICachedMNode onReturnLeft(ICachedMNode ansMNode) {
                ICachedMNode nodeInMem = (ICachedMNode)CachedMNodeIterator.this.parent.getChild(ansMNode.getName());
                if (nodeInMem != null) {
                    try {
                        CachedMTreeStore.this.memoryManager.updateCacheStatusAfterMemoryRead(nodeInMem);
                        ansMNode = nodeInMem;
                    }
                    catch (MNodeNotCachedException e) {
                        ansMNode = CachedMTreeStore.this.loadChildFromDiskToParent(CachedMNodeIterator.this.parent, ansMNode);
                    }
                } else {
                    ansMNode = CachedMTreeStore.this.loadChildFromDiskToParent(CachedMNodeIterator.this.parent, ansMNode);
                }
                return ansMNode;
            }

            protected ICachedMNode onReturnRight(ICachedMNode ansMNode) {
                try {
                    CachedMTreeStore.this.memoryManager.updateCacheStatusAfterMemoryRead(ansMNode);
                }
                catch (MNodeNotCachedException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
                return ansMNode;
            }

            protected int decide() {
                return 1;
            }

            protected int compare(ICachedMNode left, ICachedMNode right) {
                return left.getName().compareTo(right.getName());
            }
        }
    }
}

