/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternTree;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeader;
import org.apache.iotdb.db.queryengine.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.metedata.read.SchemaQueryScanNode;
import org.apache.iotdb.db.schemaengine.template.Template;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class LevelTimeSeriesCountNode
extends SchemaQueryScanNode {
    private final int level;
    private final SchemaFilter schemaFilter;
    private final Map<Integer, Template> templateMap;

    public LevelTimeSeriesCountNode(PlanNodeId id, PartialPath partialPath, boolean isPrefixPath, int level, SchemaFilter schemaFilter, @NotNull Map<Integer, Template> templateMap, @NotNull PathPatternTree scope) {
        super(id, partialPath, isPrefixPath, scope);
        this.level = level;
        this.schemaFilter = schemaFilter;
        this.templateMap = templateMap;
    }

    public SchemaFilter getSchemaFilter() {
        return this.schemaFilter;
    }

    public int getLevel() {
        return this.level;
    }

    public Map<Integer, Template> getTemplateMap() {
        return this.templateMap;
    }

    @Override
    public PlanNodeType getType() {
        return PlanNodeType.LEVEL_TIME_SERIES_COUNT;
    }

    @Override
    public PlanNode clone() {
        return new LevelTimeSeriesCountNode(this.getPlanNodeId(), this.path, this.isPrefixPath, this.level, this.schemaFilter, this.templateMap, this.scope);
    }

    @Override
    public List<String> getOutputColumnNames() {
        return ColumnHeaderConstant.countLevelTimeSeriesColumnHeaders.stream().map(ColumnHeader::getColumnName).collect(Collectors.toList());
    }

    @Override
    protected void serializeAttributes(ByteBuffer byteBuffer) {
        PlanNodeType.LEVEL_TIME_SERIES_COUNT.serialize(byteBuffer);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (ByteBuffer)byteBuffer);
        this.scope.serialize(byteBuffer);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.level, (ByteBuffer)byteBuffer);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (ByteBuffer)byteBuffer);
        for (Template template : this.templateMap.values()) {
            template.serialize(byteBuffer);
        }
    }

    @Override
    protected void serializeAttributes(DataOutputStream stream) throws IOException {
        PlanNodeType.LEVEL_TIME_SERIES_COUNT.serialize(stream);
        ReadWriteIOUtils.write((String)this.path.getFullPath(), (OutputStream)stream);
        this.scope.serialize(stream);
        ReadWriteIOUtils.write((Boolean)this.isPrefixPath, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.level, (OutputStream)stream);
        SchemaFilter.serialize((SchemaFilter)this.schemaFilter, (DataOutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateMap.size(), (OutputStream)stream);
        for (Template template : this.templateMap.values()) {
            template.serialize(stream);
        }
    }

    public static PlanNode deserialize(ByteBuffer buffer) {
        PartialPath path;
        String fullPath = ReadWriteIOUtils.readString((ByteBuffer)buffer);
        try {
            path = new PartialPath(fullPath);
        }
        catch (IllegalPathException e) {
            throw new IllegalArgumentException("Cannot deserialize DevicesSchemaScanNode", e);
        }
        PathPatternTree scope = PathPatternTree.deserialize((ByteBuffer)buffer);
        boolean isPrefixPath = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        int level = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        SchemaFilter schemaFilter = SchemaFilter.deserialize((ByteBuffer)buffer);
        int templateNum = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        HashMap<Integer, Template> templateMap = new HashMap<Integer, Template>();
        for (int i = 0; i < templateNum; ++i) {
            Template template = new Template();
            template.deserialize(buffer);
            templateMap.put(template.getId(), template);
        }
        PlanNodeId planNodeId = PlanNodeId.deserialize(buffer);
        return new LevelTimeSeriesCountNode(planNodeId, path, isPrefixPath, level, schemaFilter, templateMap, scope);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LevelTimeSeriesCountNode that = (LevelTimeSeriesCountNode)o;
        return this.level == that.level;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level);
    }

    @Override
    public String toString() {
        return String.format("LevelTimeSeriesCountNode-%s:[DataRegion: %s]", this.getPlanNodeId(), this.getRegionReplicaSet());
    }
}

