/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.planner.plan.node;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.runtime.SerializationRunTimeException;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.db.queryengine.plan.analyze.TypeProvider;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PlanNode
implements IConsensusRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlanNode.class);
    protected static final int NO_CHILD_ALLOWED = 0;
    protected static final int ONE_CHILD = 1;
    protected static final int TWO_CHILDREN = 2;
    protected static final int CHILD_COUNT_NO_LIMIT = -1;
    protected PlanNodeId id;
    protected boolean isGeneratedByPipe = false;

    protected PlanNode(PlanNodeId id) {
        Objects.requireNonNull(id, "id is null");
        this.id = id;
    }

    public PlanNodeId getPlanNodeId() {
        return this.id;
    }

    public void setPlanNodeId(PlanNodeId id) {
        this.id = id;
    }

    public boolean isGeneratedByPipe() {
        return this.isGeneratedByPipe;
    }

    public void markAsGeneratedByPipe() {
        this.isGeneratedByPipe = true;
    }

    public abstract List<PlanNode> getChildren();

    public abstract void addChild(PlanNode var1);

    public PlanNodeType getType() {
        throw new UnsupportedOperationException("This planNode does not support getType().");
    }

    public abstract PlanNode clone();

    public PlanNode createSubNode(int subNodeId, int startIndex, int endIndex) {
        throw new UnsupportedOperationException(String.format("Can't create subNode for %s", this.getClass()));
    }

    public PlanNode cloneWithChildren(List<PlanNode> children) {
        if (children != null && this.allowedChildCount() != -1 && children.size() != this.allowedChildCount()) {
            throw new IllegalArgumentException(String.format("Child count is not correct for PlanNode. Expected: %d, Value: %d", this.allowedChildCount(), this.getChildrenCount(children)));
        }
        PlanNode node = this.clone();
        if (children != null) {
            children.forEach(node::addChild);
        }
        return node;
    }

    private int getChildrenCount(List<PlanNode> children) {
        return children == null ? 0 : children.size();
    }

    public abstract int allowedChildCount();

    public abstract List<String> getOutputColumnNames();

    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPlan(this, context);
    }

    public void serialize(ByteBuffer byteBuffer) {
        this.serializeAttributes(byteBuffer);
        this.id.serialize(byteBuffer);
        List<PlanNode> planNodes = this.getChildren();
        if (planNodes == null) {
            ReadWriteIOUtils.write((int)0, (ByteBuffer)byteBuffer);
        } else {
            ReadWriteIOUtils.write((int)planNodes.size(), (ByteBuffer)byteBuffer);
            for (PlanNode planNode : planNodes) {
                planNode.serialize(byteBuffer);
            }
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        this.serializeAttributes(stream);
        this.id.serialize(stream);
        List<PlanNode> planNodes = this.getChildren();
        if (planNodes == null) {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((int)planNodes.size(), (OutputStream)stream);
            for (PlanNode planNode : planNodes) {
                planNode.serialize(stream);
            }
        }
    }

    public void serializeUseTemplate(DataOutputStream stream, TypeProvider typeProvider) throws IOException {
        this.serializeAttributes(stream);
        this.id.serialize(stream);
        List<PlanNode> planNodes = this.getChildren();
        if (planNodes == null) {
            ReadWriteIOUtils.write((int)0, (OutputStream)stream);
        } else {
            ReadWriteIOUtils.write((int)planNodes.size(), (OutputStream)stream);
            for (PlanNode planNode : planNodes) {
                planNode.serializeUseTemplate(stream, typeProvider);
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer serializeToByteBuffer() {
        try (PublicBAOS byteArrayOutputStream = new PublicBAOS();){
            ByteBuffer byteBuffer;
            try (DataOutputStream outputStream = new DataOutputStream((OutputStream)byteArrayOutputStream);){
                this.serialize(outputStream);
                byteBuffer = ByteBuffer.wrap(byteArrayOutputStream.getBuf(), 0, byteArrayOutputStream.size());
            }
            return byteBuffer;
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error occurs when serializing writePlanNode.", (Throwable)e);
            throw new SerializationRunTimeException((Throwable)e);
        }
    }

    protected abstract void serializeAttributes(ByteBuffer var1);

    protected abstract void serializeAttributes(DataOutputStream var1) throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNode planNode = (PlanNode)o;
        return Objects.equals(this.id, planNode.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }
}

