/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear;

import java.util.Optional;
import org.apache.iotdb.db.queryengine.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumn;
import org.apache.iotdb.tsfile.read.common.block.column.DoubleColumnBuilder;

public class DoubleLinearFill
extends LinearFill {
    private double previousValue;
    private double nextValue;
    private double nextValueInCurrentColumn;

    @Override
    void fillValue(Column column, int index, Object array) {
        ((double[])array)[index] = column.getDouble(index);
    }

    @Override
    void fillValue(Object array, int index, double factor) {
        ((double[])array)[index] = this.getFilledValue(factor);
    }

    @Override
    Object createValueArray(int size) {
        return new double[size];
    }

    @Override
    Column createNullValueColumn() {
        return DoubleColumnBuilder.NULL_VALUE_BLOCK;
    }

    @Override
    Column createFilledValueColumn(double[] factors) {
        int size = factors.length;
        double[] filledValue = new double[size];
        for (int i = 0; i < size; ++i) {
            filledValue[i] = this.getFilledValue(factors[i]);
        }
        return new DoubleColumn(size, Optional.empty(), filledValue);
    }

    @Override
    Column createFilledValueColumn(Object array, boolean[] isNull, boolean hasNullValue, int size) {
        if (hasNullValue) {
            return new DoubleColumn(size, Optional.of(isNull), (double[])array);
        }
        return new DoubleColumn(size, Optional.empty(), (double[])array);
    }

    @Override
    void updatePreviousValue(Column column, int index) {
        this.previousValue = column.getDouble(index);
    }

    @Override
    void updateNextValue(Column nextValueColumn, int index) {
        this.nextValue = nextValueColumn.getDouble(index);
    }

    @Override
    void updateNextValueInCurrentColumn(Column nextValueColumn, int index) {
        this.nextValueInCurrentColumn = nextValueColumn.getDouble(index);
    }

    @Override
    void updateNextValueInCurrentColumn() {
        this.nextValueInCurrentColumn = this.nextValue;
    }

    private double getFilledValue(double factor) {
        return this.previousValue + (this.nextValueInCurrentColumn - this.previousValue) * factor;
    }
}

