/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.resource.memory;

import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.utils.MemUtils;
import org.apache.iotdb.tsfile.file.metadata.IDeviceID;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class PipeMemoryWeighUtil {
    public static long memoryOfIDeviceId2Bool(Map<IDeviceID, Boolean> map) {
        long usageInBytes = 0L;
        for (Map.Entry<IDeviceID, Boolean> entry : map.entrySet()) {
            usageInBytes = usageInBytes + entry.getKey().ramBytesUsed() + 1L;
        }
        return usageInBytes + 16L;
    }

    public static long memoryOfStr2TSDataType(Map<String, TSDataType> map) {
        long usageInBytes = 0L;
        for (Map.Entry<String, TSDataType> entry : map.entrySet()) {
            usageInBytes = usageInBytes + MemUtils.getStringMem(entry.getKey()) + 4L;
        }
        return usageInBytes + 16L;
    }

    public static long memoryOfIDeviceID2StrList(Map<IDeviceID, List<String>> map) {
        long usageInBytes = 0L;
        for (Map.Entry<IDeviceID, List<String>> entry : map.entrySet()) {
            usageInBytes += entry.getKey().ramBytesUsed();
            for (String str : entry.getValue()) {
                usageInBytes += MemUtils.getStringMem(str);
            }
        }
        return usageInBytes + 16L;
    }
}

