/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult;

import java.util.Map;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

public class CustomizedReadableIntermediateResults {
    private final Map<String, Pair<TSDataType, Object>> intermediateResults;

    public CustomizedReadableIntermediateResults(Map<String, Pair<TSDataType, Object>> intermediateResults) {
        this.intermediateResults = intermediateResults;
    }

    public boolean getBoolean(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        if (typeResultPair.getLeft() == TSDataType.BOOLEAN) {
            return (Boolean)typeResultPair.getRight();
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to boolean.", typeResultPair.getLeft()));
    }

    public int getInt(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return (Integer)value;
            }
            case INT64: {
                return (int)((Long)value).longValue();
            }
            case FLOAT: {
                return (int)((Float)value).floatValue();
            }
            case DOUBLE: {
                return (int)((Double)value).doubleValue();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to int.", typeResultPair.getLeft()));
    }

    public long getLong(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return ((Integer)value).intValue();
            }
            case INT64: {
                return (Long)value;
            }
            case FLOAT: {
                return (long)((Float)value).floatValue();
            }
            case DOUBLE: {
                return (long)((Double)value).doubleValue();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to long.", typeResultPair.getLeft()));
    }

    public float getFloat(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return ((Integer)value).intValue();
            }
            case INT64: {
                return ((Long)value).longValue();
            }
            case FLOAT: {
                return ((Float)value).floatValue();
            }
            case DOUBLE: {
                return (float)((Double)value).doubleValue();
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to float.", typeResultPair.getLeft()));
    }

    public double getDouble(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case INT32: {
                return ((Integer)value).intValue();
            }
            case INT64: {
                return ((Long)value).longValue();
            }
            case FLOAT: {
                return ((Float)value).floatValue();
            }
            case DOUBLE: {
                return (Double)value;
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to double.", typeResultPair.getLeft()));
    }

    public String getString(String key) {
        Pair<TSDataType, Object> typeResultPair = this.intermediateResults.get(key);
        TSDataType type = (TSDataType)typeResultPair.getLeft();
        Object value = typeResultPair.getRight();
        switch (type) {
            case BOOLEAN: {
                return Boolean.toString((Boolean)value);
            }
            case INT32: {
                return Integer.toString((Integer)value);
            }
            case INT64: {
                return Long.toString((Long)value);
            }
            case FLOAT: {
                return Float.toString(((Float)value).floatValue());
            }
            case DOUBLE: {
                return Double.toString((Double)value);
            }
            case TEXT: {
                return (String)value;
            }
        }
        throw new UnsupportedOperationException(String.format("The type %s cannot be casted to string.", typeResultPair.getLeft()));
    }

    public Object getObject(String key) {
        return this.intermediateResults.get(key).getRight();
    }

    public TSDataType getType(String key) {
        return (TSDataType)this.intermediateResults.get(key).getLeft();
    }
}

