/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.processor.aggregate.operator.aggregatedresult.standardstatistics;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.aggregatedresult.AggregatedResultOperator;
import org.apache.iotdb.db.pipe.processor.aggregate.operator.intermediateresult.CustomizedReadableIntermediateResults;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;

public class SkewnessOperator
implements AggregatedResultOperator {
    @Override
    public String getName() {
        return "skew";
    }

    @Override
    public void configureSystemParameters(Map<String, String> systemParams) {
    }

    @Override
    public Set<String> getDeclaredIntermediateValueNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("sum_x3", "sum_x2", "sum_x1", "count")));
    }

    @Override
    public Pair<TSDataType, Object> terminateWindow(TSDataType measurementDataType, CustomizedReadableIntermediateResults intermediateResults) {
        double sumX3 = intermediateResults.getDouble("sum_x3");
        double sumX2 = intermediateResults.getDouble("sum_x2");
        double sumX1 = intermediateResults.getDouble("sum_x1");
        int count = intermediateResults.getInt("count");
        return new Pair((Object)TSDataType.DOUBLE, (Object)((sumX3 / (double)count - 3.0 * sumX1 / (double)count * sumX2 / (double)count + 2.0 * Math.pow(sumX1 / (double)count, 3.0)) / Math.pow(sumX2 / (double)count - Math.pow(sumX1 / (double)count, 2.0), 1.5)));
    }
}

