/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.event.common.tablet;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.iotdb.commons.consensus.index.ProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.pattern.PipePattern;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.db.pipe.event.common.tablet.TabletInsertionDataContainer;
import org.apache.iotdb.db.pipe.resource.PipeResourceManager;
import org.apache.iotdb.db.pipe.resource.memory.PipeTabletMemoryBlock;
import org.apache.iotdb.pipe.api.access.Row;
import org.apache.iotdb.pipe.api.collector.RowCollector;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.tsfile.write.record.Tablet;

public class PipeRawTabletInsertionEvent
extends EnrichedEvent
implements TabletInsertionEvent {
    private Tablet tablet;
    private final boolean isAligned;
    private final EnrichedEvent sourceEvent;
    private boolean needToReport;
    private PipeTabletMemoryBlock allocatedMemoryBlock;
    private TabletInsertionDataContainer dataContainer;
    private ProgressIndex overridingProgressIndex;

    private PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, EnrichedEvent sourceEvent, boolean needToReport, String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        super(pipeName, pipeTaskMeta, pattern, startTime, endTime);
        this.tablet = Objects.requireNonNull(tablet);
        this.isAligned = isAligned;
        this.sourceEvent = sourceEvent;
        this.needToReport = needToReport;
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, String pipeName, PipeTaskMeta pipeTaskMeta, EnrichedEvent sourceEvent, boolean needToReport) {
        this(tablet, isAligned, sourceEvent, needToReport, pipeName, pipeTaskMeta, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned) {
        this(tablet, isAligned, null, false, null, null, null, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, boolean isAligned, PipePattern pattern) {
        this(tablet, isAligned, null, false, null, null, pattern, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public PipeRawTabletInsertionEvent(Tablet tablet, long startTime, long endTime) {
        this(tablet, false, null, false, null, null, null, startTime, endTime);
    }

    public boolean internallyIncreaseResourceReferenceCount(String holderMessage) {
        this.allocatedMemoryBlock = PipeResourceManager.memory().forceAllocateWithRetry(this.tablet);
        return true;
    }

    public boolean internallyDecreaseResourceReferenceCount(String holderMessage) {
        this.allocatedMemoryBlock.close();
        this.tablet = null;
        this.dataContainer = null;
        return true;
    }

    protected void reportProgress() {
        if (this.needToReport) {
            super.reportProgress();
        }
    }

    public void bindProgressIndex(ProgressIndex overridingProgressIndex) {
        if (Objects.nonNull(overridingProgressIndex)) {
            this.markAsNeedToReport();
        }
        this.overridingProgressIndex = overridingProgressIndex;
    }

    public ProgressIndex getProgressIndex() {
        if (Objects.nonNull(this.overridingProgressIndex)) {
            return this.overridingProgressIndex;
        }
        return this.sourceEvent != null ? this.sourceEvent.getProgressIndex() : MinimumProgressIndex.INSTANCE;
    }

    public EnrichedEvent shallowCopySelfAndBindPipeTaskMetaForProgressReport(String pipeName, PipeTaskMeta pipeTaskMeta, PipePattern pattern, long startTime, long endTime) {
        return new PipeRawTabletInsertionEvent(this.tablet, this.isAligned, this.sourceEvent, this.needToReport, pipeName, pipeTaskMeta, pattern, startTime, endTime);
    }

    public boolean isGeneratedByPipe() {
        throw new UnsupportedOperationException("isGeneratedByPipe() is not supported!");
    }

    public boolean mayEventTimeOverlappedWithTimeRange() {
        long[] timestamps = this.tablet.timestamps;
        if (Objects.isNull(timestamps) || timestamps.length == 0) {
            return false;
        }
        return this.startTime <= timestamps[timestamps.length - 1] && timestamps[0] <= this.endTime;
    }

    public void markAsNeedToReport() {
        this.needToReport = true;
    }

    public String getDeviceId() {
        return this.tablet.deviceId;
    }

    public Iterable<TabletInsertionEvent> processRowByRow(BiConsumer<Row, RowCollector> consumer) {
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.pipePattern);
        }
        return this.dataContainer.processRowByRow(consumer);
    }

    public Iterable<TabletInsertionEvent> processTablet(BiConsumer<Tablet, RowCollector> consumer) {
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.pipePattern);
        }
        return this.dataContainer.processTablet(consumer);
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public Tablet convertToTablet() {
        if (!this.shouldParseTimeOrPattern()) {
            return this.tablet;
        }
        if (this.dataContainer == null) {
            this.dataContainer = new TabletInsertionDataContainer(this.pipeTaskMeta, this, this.tablet, this.isAligned, this.pipePattern);
        }
        return this.dataContainer.convertToTablet();
    }

    public long count() {
        Tablet covertedTablet = this.shouldParseTimeOrPattern() ? this.convertToTablet() : this.tablet;
        return (long)covertedTablet.rowSize * (long)covertedTablet.getSchemas().size();
    }

    public PipeRawTabletInsertionEvent parseEventWithPatternOrTime() {
        return new PipeRawTabletInsertionEvent(this.convertToTablet(), this.isAligned, this.pipeName, this.pipeTaskMeta, this, this.needToReport);
    }

    public boolean hasNoNeedParsingAndIsEmpty() {
        return !this.shouldParseTimeOrPattern() && this.tablet.rowSize == 0;
    }

    public String toString() {
        return String.format("PipeRawTabletInsertionEvent{tablet=%s, isAligned=%s, sourceEvent=%s, needToReport=%s, allocatedMemoryBlock=%s, dataContainer=%s}", this.tablet, this.isAligned, this.sourceEvent, this.needToReport, this.allocatedMemoryBlock, this.dataContainer) + " - " + super.toString();
    }

    public String coreReportMessage() {
        return String.format("PipeRawTabletInsertionEvent{tablet=%s, isAligned=%s, sourceEvent=%s, needToReport=%s, allocatedMemoryBlock=%s}", this.tablet, this.isAligned, this.sourceEvent == null ? "null" : this.sourceEvent.coreReportMessage(), this.needToReport, this.allocatedMemoryBlock) + " - " + super.coreReportMessage();
    }
}

