/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.connector.protocol.thrift.async;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.client.async.AsyncPipeDataTransferServiceClient;
import org.apache.iotdb.commons.pipe.connector.protocol.IoTDBConnector;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.db.pipe.connector.client.IoTDBDataNodeAsyncClientManager;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.builder.IoTDBThriftAsyncPipeTransferBatchReqBuilder;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletBinaryReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletInsertNodeReq;
import org.apache.iotdb.db.pipe.connector.payload.evolvable.request.PipeTransferTabletRawReq;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletBatchEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletInsertNodeEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTabletRawEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.async.handler.PipeTransferTsFileInsertionEventHandler;
import org.apache.iotdb.db.pipe.connector.protocol.thrift.sync.IoTDBDataRegionSyncConnector;
import org.apache.iotdb.db.pipe.event.common.heartbeat.PipeHeartbeatEvent;
import org.apache.iotdb.db.pipe.event.common.schema.PipeSchemaRegionWritePlanEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeInsertNodeTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tablet.PipeRawTabletInsertionEvent;
import org.apache.iotdb.db.pipe.event.common.tsfile.PipeTsFileInsertionEvent;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.pipe.api.event.dml.insertion.TabletInsertionEvent;
import org.apache.iotdb.pipe.api.event.dml.insertion.TsFileInsertionEvent;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBDataRegionAsyncConnector
extends IoTDBConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBDataRegionAsyncConnector.class);
    private static final String THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver.";
    private static final String THRIFT_ERROR_FORMATTER_WITH_ENDPOINT = "Failed to borrow client from client pool or exception occurred when sending to receiver %s:%s.";
    private IoTDBDataNodeAsyncClientManager clientManager;
    private final IoTDBDataRegionSyncConnector retryConnector = new IoTDBDataRegionSyncConnector();
    private final BlockingQueue<Event> retryEventQueue = new LinkedBlockingQueue<Event>();
    private IoTDBThriftAsyncPipeTransferBatchReqBuilder tabletBatchBuilder;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);

    public void validate(PipeParameterValidator validator) throws Exception {
        super.validate(validator);
        this.retryConnector.validate(validator);
        PipeParameters parameters = validator.getParameters();
        validator.validate(args -> (Boolean)args[0] == false && (Boolean)args[1] == false && (Boolean)args[2] == false, "Only 'iotdb-thrift-ssl-sink' supports SSL transmission currently.", new Object[]{parameters.getBooleanOrDefault("sink.ssl.enable", false), parameters.hasAttribute("sink.ssl.trust-store-path"), parameters.hasAttribute("sink.ssl.trust-store-pwd")});
    }

    public void customize(PipeParameters parameters, PipeConnectorRuntimeConfiguration configuration) throws Exception {
        super.customize(parameters, configuration);
        PipeParameters retryParameters = new PipeParameters(new HashMap(parameters.getAttribute()));
        retryParameters.getAttribute().put("sink.batch.enable", "false");
        retryParameters.getAttribute().put("connector.batch.enable", "false");
        this.retryConnector.customize(retryParameters, configuration);
        this.clientManager = new IoTDBDataNodeAsyncClientManager(this.nodeUrls, parameters.getBooleanOrDefault(Arrays.asList("sink.leader-cache.enable", "connector.leader-cache.enable"), true), this.loadBalanceStrategy);
        if (this.isTabletBatchModeEnabled) {
            this.tabletBatchBuilder = new IoTDBThriftAsyncPipeTransferBatchReqBuilder(parameters);
        }
    }

    public synchronized void handshake() throws Exception {
        this.retryConnector.handshake();
    }

    public void heartbeat() {
        this.retryConnector.heartbeat();
    }

    public void transfer(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        if (!(tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) && !(tabletInsertionEvent instanceof PipeRawTabletInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeInsertNodeTabletInsertionEvent and PipeRawTabletInsertionEvent. Current event: {}.", (Object)tabletInsertionEvent);
            return;
        }
        this.transferWithoutCheck(tabletInsertionEvent);
    }

    private void transferWithoutCheck(TabletInsertionEvent tabletInsertionEvent) throws Exception {
        if (this.isTabletBatchModeEnabled) {
            if (this.tabletBatchBuilder.onEvent(tabletInsertionEvent)) {
                PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler = new PipeTransferTabletBatchEventHandler(this.tabletBatchBuilder, this);
                this.transfer(pipeTransferTabletBatchEventHandler);
                this.tabletBatchBuilder.onSuccess();
            }
        } else if (tabletInsertionEvent instanceof PipeInsertNodeTabletInsertionEvent) {
            PipeInsertNodeTabletInsertionEvent pipeInsertNodeTabletInsertionEvent = (PipeInsertNodeTabletInsertionEvent)tabletInsertionEvent;
            if (!pipeInsertNodeTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName())) {
                pipeInsertNodeTabletInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
                return;
            }
            InsertNode insertNode = pipeInsertNodeTabletInsertionEvent.getInsertNodeViaCacheIfPossible();
            TPipeTransferReq pipeTransferReq = Objects.isNull(insertNode) ? PipeTransferTabletBinaryReq.toTPipeTransferReq(pipeInsertNodeTabletInsertionEvent.getByteBuffer()) : PipeTransferTabletInsertNodeReq.toTPipeTransferReq(insertNode);
            PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler = new PipeTransferTabletInsertNodeEventHandler(pipeInsertNodeTabletInsertionEvent, pipeTransferReq, this);
            this.transfer(pipeTransferInsertNodeReqHandler);
        } else {
            PipeRawTabletInsertionEvent pipeRawTabletInsertionEvent = (PipeRawTabletInsertionEvent)tabletInsertionEvent;
            if (!pipeRawTabletInsertionEvent.increaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName())) {
                pipeRawTabletInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
                return;
            }
            PipeTransferTabletRawReq pipeTransferTabletRawReq = PipeTransferTabletRawReq.toTPipeTransferReq(pipeRawTabletInsertionEvent.convertToTablet(), pipeRawTabletInsertionEvent.isAligned());
            PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler = new PipeTransferTabletRawEventHandler(pipeRawTabletInsertionEvent, (TPipeTransferReq)pipeTransferTabletRawReq, this);
            this.transfer(pipeTransferTabletReqHandler);
        }
    }

    private void transfer(PipeTransferTabletBatchEventHandler pipeTransferTabletBatchEventHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTabletBatchEventHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTabletBatchEventHandler.onError(ex);
        }
    }

    private void transfer(PipeTransferTabletInsertNodeEventHandler pipeTransferInsertNodeReqHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferInsertNodeReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferInsertNodeReqHandler.onError(ex);
        }
    }

    private void transfer(PipeTransferTabletRawEventHandler pipeTransferTabletReqHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTabletReqHandler.transfer(client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTabletReqHandler.onError(ex);
        }
    }

    public void transfer(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        this.transferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(tsFileInsertionEvent instanceof PipeTsFileInsertionEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector only support PipeTsFileInsertionEvent. Current event: {}.", (Object)tsFileInsertionEvent);
            return;
        }
        this.transferWithoutCheck(tsFileInsertionEvent);
    }

    private void transferWithoutCheck(TsFileInsertionEvent tsFileInsertionEvent) throws Exception {
        PipeTsFileInsertionEvent pipeTsFileInsertionEvent = (PipeTsFileInsertionEvent)tsFileInsertionEvent;
        if (!pipeTsFileInsertionEvent.increaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName())) {
            pipeTsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
            return;
        }
        try {
            if (!pipeTsFileInsertionEvent.getTsFile().exists()) {
                throw new FileNotFoundException(pipeTsFileInsertionEvent.getTsFile().getAbsolutePath());
            }
            PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler = new PipeTransferTsFileInsertionEventHandler(pipeTsFileInsertionEvent, this);
            this.transfer(pipeTransferTsFileInsertionEventHandler);
        }
        catch (Exception e) {
            pipeTsFileInsertionEvent.decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), false);
            throw e;
        }
    }

    private void transfer(PipeTransferTsFileInsertionEventHandler pipeTransferTsFileInsertionEventHandler) {
        AsyncPipeDataTransferServiceClient client = null;
        try {
            client = this.clientManager.borrowClient();
            pipeTransferTsFileInsertionEventHandler.transfer(this.clientManager, client);
        }
        catch (Exception ex) {
            this.logOnClientException(client, ex);
            pipeTransferTsFileInsertionEventHandler.onError(ex);
        }
    }

    public void transfer(Event event) throws Exception {
        this.transferQueuedEventsIfNecessary();
        this.transferBatchedEventsIfNecessary();
        if (!(event instanceof PipeHeartbeatEvent) && !(event instanceof PipeSchemaRegionWritePlanEvent)) {
            LOGGER.warn("IoTDBThriftAsyncConnector does not support transferring generic event: {}.", (Object)event);
            return;
        }
        this.retryConnector.transfer(event);
    }

    public void updateLeaderCache(String deviceId, TEndPoint endPoint) {
        this.clientManager.updateLeaderCache(deviceId, endPoint);
    }

    private void logOnClientException(AsyncPipeDataTransferServiceClient client, Exception e) {
        if (client == null) {
            LOGGER.warn(THRIFT_ERROR_FORMATTER_WITHOUT_ENDPOINT, (Throwable)e);
        } else {
            LOGGER.warn(String.format(THRIFT_ERROR_FORMATTER_WITH_ENDPOINT, client.getIp(), client.getPort()), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transferQueuedEventsIfNecessary() throws Exception {
        while (!this.retryEventQueue.isEmpty()) {
            IoTDBDataRegionAsyncConnector ioTDBDataRegionAsyncConnector = this;
            synchronized (ioTDBDataRegionAsyncConnector) {
                Event polledEvent;
                if (this.isClosed.get() || this.retryEventQueue.isEmpty()) {
                    return;
                }
                Event peekedEvent = (Event)this.retryEventQueue.peek();
                if (peekedEvent instanceof PipeInsertNodeTabletInsertionEvent) {
                    this.retryConnector.transfer((PipeInsertNodeTabletInsertionEvent)peekedEvent);
                } else if (peekedEvent instanceof PipeRawTabletInsertionEvent) {
                    this.retryConnector.transfer((PipeRawTabletInsertionEvent)peekedEvent);
                } else if (peekedEvent instanceof PipeTsFileInsertionEvent) {
                    this.retryConnector.transfer((PipeTsFileInsertionEvent)peekedEvent);
                } else {
                    LOGGER.warn("IoTDBThriftAsyncConnector does not support transfer generic event: {}.", (Object)peekedEvent);
                }
                if (peekedEvent instanceof EnrichedEvent) {
                    ((EnrichedEvent)peekedEvent).decreaseReferenceCount(IoTDBDataRegionAsyncConnector.class.getName(), true);
                }
                if ((polledEvent = (Event)this.retryEventQueue.poll()) != peekedEvent) {
                    LOGGER.error("The event polled from the queue is not the same as the event peeked from the queue. Peeked event: {}, polled event: {}.", (Object)peekedEvent, (Object)polledEvent);
                }
                if (polledEvent != null && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Polled event {} from retry queue.", (Object)polledEvent);
                }
            }
        }
    }

    private void transferBatchedEventsIfNecessary() throws IOException {
        if (!this.isTabletBatchModeEnabled || this.tabletBatchBuilder.isEmpty()) {
            return;
        }
        this.transfer(new PipeTransferTabletBatchEventHandler(this.tabletBatchBuilder, this));
        this.tabletBatchBuilder.onSuccess();
    }

    public void addFailureEventToRetryQueue(Event event) {
        if (this.isClosed.get()) {
            if (event instanceof EnrichedEvent) {
                ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
            }
            return;
        }
        this.retryEventQueue.offer(event);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Added event {} to retry queue.", (Object)event);
        }
        if (this.isClosed.get() && event instanceof EnrichedEvent) {
            ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
        }
    }

    public void addFailureEventsToRetryQueue(Iterable<Event> events) {
        for (Event event : events) {
            this.addFailureEventToRetryQueue(event);
        }
    }

    public synchronized void clearRetryEventsReferenceCount() {
        while (!this.retryEventQueue.isEmpty()) {
            Event event = (Event)this.retryEventQueue.poll();
            if (!(event instanceof EnrichedEvent)) continue;
            ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
        }
    }

    public boolean supportModsIfIsDataNodeReceiver() {
        return this.clientManager.supportModsIfIsDataNodeReceiver();
    }

    public synchronized void discardEventsOfPipe(String pipeNameToDrop) {
        this.retryEventQueue.removeIf(event -> {
            if (event instanceof EnrichedEvent && pipeNameToDrop.equals(((EnrichedEvent)event).getPipeName())) {
                ((EnrichedEvent)event).clearReferenceCount(IoTDBDataRegionAsyncConnector.class.getName());
                return true;
            }
            return false;
        });
    }

    public synchronized void close() throws Exception {
        this.isClosed.set(true);
        this.retryConnector.close();
        this.clearRetryEventsReferenceCount();
        if (this.tabletBatchBuilder != null) {
            this.tabletBatchBuilder.close();
        }
    }

    public int getRetryEventQueueSize() {
        return this.retryEventQueue.size();
    }
}

