/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.consensus.statemachine.dataregion;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.consensus.common.request.IConsensusRequest;
import org.apache.iotdb.consensus.common.request.IndexedConsensusRequest;
import org.apache.iotdb.consensus.iot.log.GetConsensusReqReaderPlan;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.BaseStateMachine;
import org.apache.iotdb.db.consensus.statemachine.dataregion.DataExecutionVisitor;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.FragmentInstance;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertMultiTabletsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertRowsNode;
import org.apache.iotdb.db.queryengine.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.buffer.BloomFilterCache;
import org.apache.iotdb.db.storageengine.buffer.ChunkCache;
import org.apache.iotdb.db.storageengine.buffer.TimeSeriesMetadataCache;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotLoader;
import org.apache.iotdb.db.storageengine.dataregion.snapshot.SnapshotTaker;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionStateMachine
extends BaseStateMachine {
    private static final Logger logger = LoggerFactory.getLogger(DataRegionStateMachine.class);
    private static final FragmentInstanceManager QUERY_INSTANCE_MANAGER = FragmentInstanceManager.getInstance();
    protected DataRegion region;
    private static final int MAX_WRITE_RETRY_TIMES = 5;
    private static final long WRITE_RETRY_WAIT_TIME_IN_MS = 1000L;

    public DataRegionStateMachine(DataRegion region) {
        this.region = region;
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isReadOnly() {
        return CommonDescriptor.getInstance().getConfig().isReadOnly();
    }

    public boolean takeSnapshot(File snapshotDir) {
        try {
            return new SnapshotTaker(this.region).takeFullSnapshot(snapshotDir.getAbsolutePath(), true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionId(), snapshotDir, e});
            return false;
        }
    }

    public boolean takeSnapshot(File snapshotDir, String snapshotTmpId, String snapshotId) {
        try {
            return new SnapshotTaker(this.region).takeFullSnapshot(snapshotDir.getAbsolutePath(), snapshotTmpId, snapshotId, true);
        }
        catch (Exception e) {
            logger.error("Exception occurs when taking snapshot for {}-{} in {}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionId(), snapshotDir, e});
            return false;
        }
    }

    public void loadSnapshot(File latestSnapshotRootDir) {
        DataRegion newRegion = new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getDatabaseName(), this.region.getDataRegionId()).loadSnapshotForStateMachine();
        if (newRegion == null) {
            logger.error("Fail to load snapshot from {}", (Object)latestSnapshotRootDir);
            return;
        }
        this.region = newRegion;
        try {
            StorageEngine.getInstance().setDataRegion(new DataRegionId(Integer.parseInt(this.region.getDataRegionId())), this.region);
            ChunkCache.getInstance().clear();
            TimeSeriesMetadataCache.getInstance().clear();
            BloomFilterCache.getInstance().clear();
        }
        catch (Exception e) {
            logger.error("Exception occurs when replacing data region in storage engine.", (Throwable)e);
        }
    }

    protected PlanNode grabInsertNode(IndexedConsensusRequest indexedRequest) {
        ArrayList<InsertNode> insertNodes = new ArrayList<InsertNode>(indexedRequest.getRequests().size());
        for (IConsensusRequest req : indexedRequest.getRequests()) {
            PlanNode planNode = this.getPlanNode(req);
            if (planNode instanceof InsertNode) {
                InsertNode innerNode = (InsertNode)planNode;
                innerNode.setSearchIndex(indexedRequest.getSearchIndex());
                insertNodes.add(innerNode);
                continue;
            }
            if (indexedRequest.getRequests().size() == 1) {
                return planNode;
            }
            throw new IllegalArgumentException("PlanNodes in IndexedConsensusRequest are not InsertNode and the size of requests are larger than 1");
        }
        return this.mergeInsertNodes(insertNodes);
    }

    protected InsertNode mergeInsertNodes(List<InsertNode> insertNodes) {
        InsertNode result;
        int size = insertNodes.size();
        if (size == 0) {
            throw new RuntimeException();
        }
        if (size == 1) {
            return insertNodes.get(0);
        }
        ArrayList<Integer> index = new ArrayList<Integer>();
        int i = 0;
        switch (insertNodes.get(0).getType()) {
            case INSERT_TABLET: {
                ArrayList<InsertTabletNode> insertTabletNodes = new ArrayList<InsertTabletNode>(size);
                for (InsertNode insertNode : insertNodes) {
                    insertTabletNodes.add((InsertTabletNode)insertNode);
                    index.add(i);
                    ++i;
                }
                result = new InsertMultiTabletsNode(insertNodes.get(0).getPlanNodeId(), index, insertTabletNodes);
                break;
            }
            case INSERT_ROW: {
                ArrayList<InsertRowNode> insertRowNodes = new ArrayList<InsertRowNode>(size);
                for (InsertNode insertNode : insertNodes) {
                    insertRowNodes.add((InsertRowNode)insertNode);
                    index.add(i);
                    ++i;
                }
                result = new InsertRowsNode(insertNodes.get(0).getPlanNodeId(), index, insertRowNodes);
                break;
            }
            case INSERT_ROWS: {
                ArrayList<InsertRowNode> list = new ArrayList<InsertRowNode>();
                for (InsertNode insertNode : insertNodes) {
                    for (InsertRowNode insertRowNode : ((InsertRowsNode)insertNode).getInsertRowNodeList()) {
                        list.add(insertRowNode);
                        index.add(i);
                        ++i;
                    }
                }
                result = new InsertRowsNode(insertNodes.get(0).getPlanNodeId(), index, list);
                break;
            }
            default: {
                throw new UnSupportedDataTypeException("Unsupported node type " + (Object)((Object)insertNodes.get(0).getType()));
            }
        }
        result.setSearchIndex(insertNodes.get(0).getSearchIndex());
        result.setDevicePath(insertNodes.get(0).getDevicePath());
        return result;
    }

    public List<Path> getSnapshotFiles(File latestSnapshotRootDir) {
        try {
            return new SnapshotLoader(latestSnapshotRootDir.getAbsolutePath(), this.region.getDatabaseName(), this.region.getDataRegionId()).getSnapshotFileInfo().stream().map(File::toPath).collect(Collectors.toList());
        }
        catch (IOException e) {
            logger.error("Meets error when getting snapshot files for {}-{}", new Object[]{this.region.getDatabaseName(), this.region.getDataRegionId(), e});
            return null;
        }
    }

    public TSStatus write(IConsensusRequest request) {
        try {
            return this.write((PlanNode)request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new TSStatus(TSStatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        }
    }

    protected TSStatus write(PlanNode planNode) {
        TSStatus result = null;
        int retryTime = 0;
        while (retryTime < 5 && DataRegionStateMachine.needRetry((result = planNode.accept(new DataExecutionVisitor(), this.region)).getCode())) {
            logger.debug("write operation failed because {}, retryTime: {}.", (Object)result.getCode(), (Object)(++retryTime));
            if (retryTime == 5) {
                logger.error("write operation still failed after {} retry times, because {}.", (Object)5, (Object)result.getCode());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return result;
    }

    public DataSet read(IConsensusRequest request) {
        FragmentInstance fragmentInstance;
        if (request instanceof GetConsensusReqReaderPlan) {
            return this.region.getWALNode();
        }
        try {
            fragmentInstance = this.getFragmentInstance(request);
        }
        catch (IllegalArgumentException e) {
            logger.error(e.getMessage());
            return null;
        }
        return QUERY_INSTANCE_MANAGER.execDataQueryFragmentInstance(fragmentInstance, this.region);
    }

    public File getSnapshotRoot() {
        String snapshotDir = "";
        try {
            snapshotDir = IoTDBDescriptor.getInstance().getConfig().getRatisDataRegionSnapshotDir() + File.separator + this.region.getDatabaseName() + "-" + this.region.getDataRegionId();
            return new File(snapshotDir).getCanonicalFile();
        }
        catch (IOException | NullPointerException e) {
            logger.warn("{}: cannot get the canonical file of {} due to {}", new Object[]{this, snapshotDir, e});
            return null;
        }
    }

    public static boolean needRetry(int statusCode) {
        return statusCode == TSStatusCode.WRITE_PROCESS_REJECT.getStatusCode();
    }
}

