/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.metrics.metricsets.system;

import com.sun.management.OperatingSystemMXBean;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.nio.file.FileStore;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.config.MetricConfig;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.FileStoreUtils;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.apache.iotdb.metrics.utils.SystemMetric;
import org.apache.iotdb.metrics.utils.SystemTag;
import org.apache.iotdb.metrics.utils.SystemType;
import org.apache.iotdb.tsfile.utils.FSUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(SystemMetrics.class);
    private static final MetricConfig CONFIG = MetricConfigDescriptor.getInstance().getMetricConfig();
    private final Runtime runtime = Runtime.getRuntime();
    private final String[] getSystemMemoryCommand = new String[]{"/bin/sh", "-c", "free"};
    private final String[] linuxMemoryTitles = new String[]{"Total", "Used", "Free", "Shared", "Buff/Cache", "Available"};
    private long lastUpdateTime = 0L;
    private volatile long usedMemory = 0L;
    private volatile long sharedMemory = 0L;
    private volatile long buffCacheMemory = 0L;
    private volatile long availableMemory = 0L;
    static final String SYSTEM = "system";
    private final OperatingSystemMXBean osMxBean;
    private Set<FileStore> fileStores = new HashSet<FileStore>();
    private static final String FAILED_TO_STATISTIC = "Failed to statistic the size of {}, because";

    public SystemMetrics() {
        this.osMxBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    }

    public void setDiskDirs(List<String> diskDirs) {
        if (!MetricConfigDescriptor.getInstance().getMetricConfig().getMetricLevel().equals((Object)MetricLevel.OFF)) {
            this.fileStores = SystemMetrics.getFileStores(diskDirs);
        }
    }

    public static Set<FileStore> getFileStores(List<String> dirs) {
        HashSet<FileStore> fileStoreSet = new HashSet<FileStore>();
        for (String diskDir : dirs) {
            FileStore fileStore;
            if (!FSUtils.isLocal((String)diskDir) || (fileStore = FileStoreUtils.getFileStore(diskDir)) == null) continue;
            fileStoreSet.add(fileStore);
        }
        return fileStoreSet;
    }

    @Override
    public void bindTo(AbstractMetricService metricService) {
        this.collectSystemCpuInfo(metricService);
        this.collectSystemMemInfo(metricService);
        this.collectSystemDiskInfo(metricService);
    }

    @Override
    public void unbindFrom(AbstractMetricService metricService) {
        this.removeSystemCpuInfo(metricService);
        this.removeSystemDiskInfo(metricService);
        this.removeSystemMemInfo(metricService);
    }

    private void collectSystemCpuInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.SYS_CPU_LOAD.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getSystemCpuLoad() * 100.0, SystemTag.NAME.toString(), SYSTEM);
        metricService.getOrCreateGauge(SystemMetric.SYS_CPU_CORES.toString(), MetricLevel.CORE, SystemTag.NAME.toString(), SYSTEM).set(this.osMxBean.getAvailableProcessors());
    }

    private void removeSystemCpuInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_CPU_LOAD.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.GAUGE, SystemMetric.SYS_CPU_CORES.toString(), SystemTag.NAME.toString(), SYSTEM);
    }

    private void collectSystemMemInfo(AbstractMetricService metricService) {
        metricService.getOrCreateGauge(SystemMetric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, SystemTag.NAME.toString(), SYSTEM).set(this.osMxBean.getTotalPhysicalMemorySize());
        metricService.createAutoGauge(SystemMetric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getFreePhysicalMemorySize(), SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getTotalSwapSpaceSize(), SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_FREE_SWAP_SPACE_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getFreeSwapSpaceSize(), SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_COMMITTED_VM_SIZE.toString(), MetricLevel.CORE, this.osMxBean, a -> this.osMxBean.getCommittedVirtualMemorySize(), SystemTag.NAME.toString(), SYSTEM);
        if (CONFIG.getSystemType() == SystemType.LINUX) {
            metricService.createAutoGauge(SystemMetric.LINUX_MEMORY_SIZE.toString(), MetricLevel.CORE, this, a -> {
                this.updateLinuxSystemMemInfo();
                return this.usedMemory;
            }, SystemTag.NAME.toString(), this.linuxMemoryTitles[1]);
            metricService.createAutoGauge(SystemMetric.LINUX_MEMORY_SIZE.toString(), MetricLevel.CORE, this, a -> {
                this.updateLinuxSystemMemInfo();
                return this.sharedMemory;
            }, SystemTag.NAME.toString(), this.linuxMemoryTitles[3]);
            metricService.createAutoGauge(SystemMetric.LINUX_MEMORY_SIZE.toString(), MetricLevel.CORE, this, a -> {
                this.updateLinuxSystemMemInfo();
                return this.buffCacheMemory;
            }, SystemTag.NAME.toString(), this.linuxMemoryTitles[4]);
            metricService.createAutoGauge(SystemMetric.LINUX_MEMORY_SIZE.toString(), MetricLevel.CORE, this, a -> {
                this.updateLinuxSystemMemInfo();
                return this.availableMemory;
            }, SystemTag.NAME.toString(), this.linuxMemoryTitles[5]);
        }
    }

    private void updateLinuxSystemMemInfo() {
        long time = System.currentTimeMillis();
        if (time - this.lastUpdateTime > 10000L) {
            this.lastUpdateTime = time;
            try {
                String[] memParts;
                Process process = this.runtime.exec(this.getSystemMemoryCommand);
                StringBuilder result = new StringBuilder();
                try (BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line).append("\n");
                    }
                }
                String[] lines = result.toString().trim().split("\n");
                if (lines.length >= 2 && (memParts = lines[1].trim().split("\\s+")).length >= this.linuxMemoryTitles.length) {
                    this.usedMemory = Long.parseLong(memParts[2]) * 1024L;
                    this.sharedMemory = Long.parseLong(memParts[4]) * 1024L;
                    this.buffCacheMemory = Long.parseLong(memParts[5]) * 1024L;
                    this.availableMemory = Long.parseLong(memParts[6]) * 1024L;
                }
            }
            catch (IOException e) {
                logger.debug("Failed to get memory, because ", (Throwable)e);
            }
        }
    }

    private void removeSystemMemInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.GAUGE, SystemMetric.SYS_TOTAL_PHYSICAL_MEMORY_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_FREE_PHYSICAL_MEMORY_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_TOTAL_SWAP_SPACE_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_FREE_SWAP_SPACE_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_COMMITTED_VM_SIZE.toString(), SystemTag.NAME.toString(), SYSTEM);
        if (CONFIG.getSystemType() == SystemType.LINUX) {
            for (String title : this.linuxMemoryTitles) {
                metricService.remove(MetricType.GAUGE, SystemMetric.LINUX_MEMORY_SIZE.toString(), SystemTag.NAME.toString(), title);
            }
        }
    }

    private void collectSystemDiskInfo(AbstractMetricService metricService) {
        metricService.createAutoGauge(SystemMetric.SYS_DISK_TOTAL_SPACE.toString(), MetricLevel.CORE, this, SystemMetrics::getSystemDiskTotalSpace, SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_DISK_FREE_SPACE.toString(), MetricLevel.CORE, this, SystemMetrics::getSystemDiskFreeSpace, SystemTag.NAME.toString(), SYSTEM);
        metricService.createAutoGauge(SystemMetric.SYS_DISK_AVAILABLE_SPACE.toString(), MetricLevel.CORE, this, SystemMetrics::getSystemDiskAvailableSpace, SystemTag.NAME.toString(), SYSTEM);
    }

    private void removeSystemDiskInfo(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_DISK_TOTAL_SPACE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_DISK_FREE_SPACE.toString(), SystemTag.NAME.toString(), SYSTEM);
        metricService.remove(MetricType.AUTO_GAUGE, SystemMetric.SYS_DISK_AVAILABLE_SPACE.toString(), SystemTag.NAME.toString(), SYSTEM);
        this.fileStores.clear();
    }

    public long getSystemDiskTotalSpace() {
        long sysTotalSpace = 0L;
        for (FileStore fileStore : this.fileStores) {
            try {
                sysTotalSpace += fileStore.getTotalSpace();
            }
            catch (IOException e) {
                logger.error(FAILED_TO_STATISTIC, (Object)fileStore, (Object)e);
            }
        }
        return sysTotalSpace;
    }

    public long getSystemDiskFreeSpace() {
        long sysFreeSpace = 0L;
        for (FileStore fileStore : this.fileStores) {
            try {
                sysFreeSpace += fileStore.getUnallocatedSpace();
            }
            catch (IOException e) {
                logger.error(FAILED_TO_STATISTIC, (Object)fileStore, (Object)e);
            }
        }
        return sysFreeSpace;
    }

    public long getSystemDiskAvailableSpace() {
        long sysAvailableSpace = 0L;
        for (FileStore fileStore : this.fileStores) {
            try {
                sysAvailableSpace += fileStore.getUsableSpace();
            }
            catch (IOException e) {
                logger.error(FAILED_TO_STATISTIC, (Object)fileStore, (Object)e);
            }
        }
        return sysAvailableSpace;
    }

    public static SystemMetrics getInstance() {
        return SystemMetricsHolder.INSTANCE;
    }

    private static class SystemMetricsHolder {
        private static final SystemMetrics INSTANCE = new SystemMetrics();

        private SystemMetricsHolder() {
        }
    }
}

