/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.trigger;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.commons.trigger.exception.TriggerManagementException;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.DeleteTriggerInTablePlan;
import org.apache.iotdb.confignode.consensus.request.write.trigger.UpdateTriggerStateInTablePlan;
import org.apache.iotdb.confignode.persistence.TriggerInfo;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.DropTriggerState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TTriggerState;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropTriggerProcedure
extends AbstractNodeProcedure<DropTriggerState> {
    private static final Logger LOG = LoggerFactory.getLogger(DropTriggerProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private String triggerName;

    public DropTriggerProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public DropTriggerProcedure(String triggerName, boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
        this.triggerName = triggerName;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, DropTriggerState state) {
        block11: {
            if (this.triggerName == null) {
                return StateMachineProcedure.Flow.NO_MORE_STATE;
            }
            try {
                switch (state) {
                    case INIT: {
                        LOG.info("Start to drop trigger [{}]", (Object)this.triggerName);
                        TriggerInfo triggerInfo = env.getConfigManager().getTriggerManager().getTriggerInfo();
                        triggerInfo.acquireTriggerTableLock();
                        triggerInfo.validate(this.triggerName);
                        env.getConfigManager().getConsensusManager().write(new UpdateTriggerStateInTablePlan(this.triggerName, TTriggerState.DROPPING));
                        this.setNextState(DropTriggerState.CONFIG_NODE_DROPPING);
                        break;
                    }
                    case CONFIG_NODE_DROPPING: {
                        LOG.info("Start to drop trigger [{}] on Data Nodes", (Object)this.triggerName);
                        if (RpcUtils.squashResponseStatusList(env.dropTriggerOnDataNodes(this.triggerName, false)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                            this.setNextState(DropTriggerState.DATA_NODE_DROPPED);
                            break;
                        }
                        throw new TriggerManagementException(String.format("Fail to drop trigger [%s] on Data Nodes", this.triggerName));
                    }
                    case DATA_NODE_DROPPED: {
                        LOG.info("Start to drop trigger [{}] on Config Nodes", (Object)this.triggerName);
                        env.getConfigManager().getConsensusManager().write(this.isGeneratedByPipe ? new PipeEnrichedPlan(new DeleteTriggerInTablePlan(this.triggerName)) : new DeleteTriggerInTablePlan(this.triggerName));
                        this.setNextState(DropTriggerState.CONFIG_NODE_DROPPED);
                        break;
                    }
                    case CONFIG_NODE_DROPPED: {
                        env.getConfigManager().getTriggerManager().getTriggerInfo().releaseTriggerTableLock();
                        return StateMachineProcedure.Flow.NO_MORE_STATE;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown DropTriggerState: " + (Object)((Object)state));
                    }
                }
            }
            catch (Exception e) {
                if (this.isRollbackSupported(state)) {
                    LOG.warn("Drop trigger {} failed.", (Object)this.triggerName, (Object)e);
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
                LOG.error("Retrievable error trying to drop trigger [{}], state [{}]", new Object[]{this.triggerName, state, e});
                if (this.getCycles() <= 5) break block11;
                this.setFailure(new ProcedureException(String.format("Fail to drop trigger [%s] at STATE [%s]", new Object[]{this.triggerName, state})));
            }
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, DropTriggerState state) throws IOException, InterruptedException, ProcedureException {
        if (state == DropTriggerState.INIT) {
            LOG.info("Start [INIT] rollback of trigger [{}]", (Object)this.triggerName);
            env.getConfigManager().getTriggerManager().getTriggerInfo().releaseTriggerTableLock();
        }
    }

    @Override
    protected boolean isRollbackSupported(DropTriggerState state) {
        return true;
    }

    @Override
    protected DropTriggerState getState(int stateId) {
        return DropTriggerState.values()[stateId];
    }

    @Override
    protected int getStateId(DropTriggerState dropTriggerState) {
        return dropTriggerState.ordinal();
    }

    @Override
    protected DropTriggerState getInitialState() {
        return DropTriggerState.INIT;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_DROP_TRIGGER_PROCEDURE.getTypeCode() : ProcedureType.DROP_TRIGGER_PROCEDURE.getTypeCode());
        super.serialize(stream);
        ReadWriteIOUtils.write((String)this.triggerName, (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.triggerName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
    }

    public boolean equals(Object that) {
        if (that instanceof DropTriggerProcedure) {
            DropTriggerProcedure thatProc = (DropTriggerProcedure)that;
            return thatProc.getProcId() == this.getProcId() && ((DropTriggerState)((Object)thatProc.getCurrentState())).equals(this.getCurrentState()) && thatProc.getCycles() == this.getCycles() && thatProc.isGeneratedByPipe == this.isGeneratedByPipe && thatProc.triggerName.equals(this.triggerName);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.isGeneratedByPipe, this.triggerName);
    }
}

