/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.pipe.plugin;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.pipe.plugin.meta.PipePluginMeta;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.CreatePipePluginPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.plugin.DropPipePluginPlan;
import org.apache.iotdb.confignode.manager.ConfigManager;
import org.apache.iotdb.confignode.manager.pipe.coordinator.plugin.PipePluginCoordinator;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureSuspendedException;
import org.apache.iotdb.confignode.procedure.exception.ProcedureYieldException;
import org.apache.iotdb.confignode.procedure.impl.StateMachineProcedure;
import org.apache.iotdb.confignode.procedure.impl.node.AbstractNodeProcedure;
import org.apache.iotdb.confignode.procedure.state.pipe.plugin.CreatePipePluginState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.consensus.exception.ConsensusException;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePipePluginProcedure
extends AbstractNodeProcedure<CreatePipePluginState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePipePluginProcedure.class);
    private static final int RETRY_THRESHOLD = 5;
    private PipePluginMeta pipePluginMeta;
    private byte[] jarFile;

    public CreatePipePluginProcedure() {
    }

    public CreatePipePluginProcedure(PipePluginMeta pipePluginMeta, byte[] jarFile) {
        this.pipePluginMeta = pipePluginMeta;
        this.jarFile = jarFile;
    }

    @Override
    protected StateMachineProcedure.Flow executeFromState(ConfigNodeProcedureEnv env, CreatePipePluginState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (this.pipePluginMeta == null) {
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        try {
            switch (state) {
                case LOCK: {
                    return this.executeFromLock(env);
                }
                case CREATE_ON_CONFIG_NODES: {
                    return this.executeFromCreateOnConfigNodes(env);
                }
                case CREATE_ON_DATA_NODES: {
                    return this.executeFromCreateOnDataNodes(env);
                }
                case UNLOCK: {
                    return this.executeFromUnlock(env);
                }
            }
            throw new UnsupportedOperationException(String.format("Unknown state during executing createPipePluginProcedure, %s", new Object[]{state}));
        }
        catch (Exception e) {
            if (this.isRollbackSupported(state)) {
                LOGGER.error("CreatePipePluginProcedure failed in state {}, will rollback", (Object)state, (Object)e);
                this.setFailure(new ProcedureException(e.getMessage()));
            } else {
                LOGGER.error("Retrievable error trying to create pipe plugin [{}], state: {}", new Object[]{this.pipePluginMeta.getPluginName(), state, e});
                if (this.getCycles() > 5) {
                    LOGGER.error("Fail to create pipe plugin [{}] after {} retries", (Object)this.pipePluginMeta.getPluginName(), (Object)this.getCycles());
                    this.setFailure(new ProcedureException(e.getMessage()));
                }
            }
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
    }

    private StateMachineProcedure.Flow executeFromLock(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipePluginProcedure: executeFromLock({})", (Object)this.pipePluginMeta.getPluginName());
        PipePluginCoordinator pipePluginCoordinator = env.getConfigManager().getPipeManager().getPipePluginCoordinator();
        pipePluginCoordinator.lock();
        try {
            pipePluginCoordinator.getPipePluginInfo().validateBeforeCreatingPipePlugin(this.pipePluginMeta.getPluginName(), this.pipePluginMeta.getJarName(), this.pipePluginMeta.getJarMD5());
        }
        catch (PipeException e) {
            LOGGER.warn("Pipe plugin {} is already created, end the CreatePipePluginProcedure({})", (Object)this.pipePluginMeta.getPluginName(), (Object)this.pipePluginMeta.getPluginName());
            this.setFailure(new ProcedureException(e.getMessage()));
            pipePluginCoordinator.unlock();
            return StateMachineProcedure.Flow.NO_MORE_STATE;
        }
        this.setNextState(CreatePipePluginState.CREATE_ON_CONFIG_NODES);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow executeFromCreateOnConfigNodes(ConfigNodeProcedureEnv env) {
        TSStatus response;
        LOGGER.info("CreatePipePluginProcedure: executeFromCreateOnConfigNodes({})", (Object)this.pipePluginMeta.getPluginName());
        ConfigManager configNodeManager = env.getConfigManager();
        boolean needToSaveJar = configNodeManager.getPipeManager().getPipePluginCoordinator().getPipePluginInfo().isJarNeededToBeSavedWhenCreatingPipePlugin(this.pipePluginMeta.getJarName());
        CreatePipePluginPlan createPluginPlan = new CreatePipePluginPlan(this.pipePluginMeta, needToSaveJar ? new Binary(this.jarFile) : null);
        try {
            response = configNodeManager.getConsensusManager().write(createPluginPlan);
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
            response = new TSStatus(TSStatusCode.EXECUTE_STATEMENT_ERROR.getStatusCode());
            response.setMessage(e.getMessage());
        }
        if (response.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new PipeException(response.getMessage());
        }
        this.setNextState(CreatePipePluginState.CREATE_ON_DATA_NODES);
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    private StateMachineProcedure.Flow executeFromCreateOnDataNodes(ConfigNodeProcedureEnv env) throws IOException {
        LOGGER.info("CreatePipePluginProcedure: executeFromCreateOnDataNodes({})", (Object)this.pipePluginMeta.getPluginName());
        if (RpcUtils.squashResponseStatusList(env.createPipePluginOnDataNodes(this.pipePluginMeta, this.jarFile)).getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(CreatePipePluginState.UNLOCK);
            return StateMachineProcedure.Flow.HAS_MORE_STATE;
        }
        throw new PipeException(String.format("Failed to create pipe plugin instance [%s] on data nodes", this.pipePluginMeta.getPluginName()));
    }

    private StateMachineProcedure.Flow executeFromUnlock(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipePluginProcedure: executeFromUnlock({})", (Object)this.pipePluginMeta.getPluginName());
        env.getConfigManager().getPipeManager().getPipePluginCoordinator().unlock();
        return StateMachineProcedure.Flow.NO_MORE_STATE;
    }

    @Override
    protected void rollbackState(ConfigNodeProcedureEnv env, CreatePipePluginState state) throws IOException, InterruptedException, ProcedureException {
        switch (state) {
            case LOCK: {
                this.rollbackFromLock(env);
                break;
            }
            case CREATE_ON_CONFIG_NODES: {
                this.rollbackFromCreateOnConfigNodes(env);
                break;
            }
            case CREATE_ON_DATA_NODES: {
                this.rollbackFromCreateOnDataNodes(env);
            }
        }
    }

    private void rollbackFromLock(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipePluginProcedure: rollbackFromLock({})", (Object)this.pipePluginMeta.getPluginName());
        env.getConfigManager().getPipeManager().getPipePluginCoordinator().unlock();
    }

    private void rollbackFromCreateOnConfigNodes(ConfigNodeProcedureEnv env) {
        LOGGER.info("CreatePipePluginProcedure: rollbackFromCreateOnConfigNodes({})", (Object)this.pipePluginMeta.getPluginName());
        try {
            env.getConfigManager().getConsensusManager().write(new DropPipePluginPlan(this.pipePluginMeta.getPluginName()));
        }
        catch (ConsensusException e) {
            LOGGER.warn("Failed in the write API executing the consensus layer due to: ", (Throwable)e);
        }
    }

    private void rollbackFromCreateOnDataNodes(ConfigNodeProcedureEnv env) throws ProcedureException {
        LOGGER.info("CreatePipePluginProcedure: rollbackFromCreateOnDataNodes({})", (Object)this.pipePluginMeta.getPluginName());
        if (RpcUtils.squashResponseStatusList(env.dropPipePluginOnDataNodes(this.pipePluginMeta.getPluginName(), false)).getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            throw new ProcedureException(String.format("Failed to rollback pipe plugin [%s] on data nodes", this.pipePluginMeta.getPluginName()));
        }
    }

    @Override
    protected boolean isRollbackSupported(CreatePipePluginState state) {
        switch (state) {
            case LOCK: 
            case CREATE_ON_CONFIG_NODES: 
            case CREATE_ON_DATA_NODES: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected CreatePipePluginState getState(int stateId) {
        return CreatePipePluginState.values()[stateId];
    }

    @Override
    protected int getStateId(CreatePipePluginState createPipePluginState) {
        return createPipePluginState.ordinal();
    }

    @Override
    protected CreatePipePluginState getInitialState() {
        return CreatePipePluginState.LOCK;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(ProcedureType.CREATE_PIPE_PLUGIN_PROCEDURE.getTypeCode());
        super.serialize(stream);
        this.pipePluginMeta.serialize(stream);
        ReadWriteIOUtils.write((ByteBuffer)ByteBuffer.wrap(this.jarFile), (OutputStream)stream);
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.pipePluginMeta = PipePluginMeta.deserialize((ByteBuffer)byteBuffer);
        this.jarFile = ReadWriteIOUtils.readBinary((ByteBuffer)byteBuffer).getValues();
    }

    public boolean equals(Object that) {
        if (that instanceof CreatePipePluginProcedure) {
            CreatePipePluginProcedure thatProcedure = (CreatePipePluginProcedure)that;
            return thatProcedure.getProcId() == this.getProcId() && ((CreatePipePluginState)((Object)thatProcedure.getCurrentState())).equals(this.getCurrentState()) && thatProcedure.getCycles() == this.getCycles() && thatProcedure.pipePluginMeta.equals((Object)this.pipePluginMeta);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getProcId(), this.getCurrentState(), this.getCycles(), this.pipePluginMeta);
    }

    public byte[] getJarFile() {
        return this.jarFile;
    }
}

