/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.persistence.schema;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.confignode.conf.ConfigNodeConfig;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.persistence.schema.CNPhysicalPlanGenerator;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfignodeSnapshotParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfignodeSnapshotParser.class);
    private static final ConfigNodeConfig CONF = ConfigNodeDescriptor.getInstance().getConf();
    private static final String SNAPSHOT_CLUSTER_SCHEMA_FILENAME = "cluster_schema.bin";
    private static final String SNAPSHOT_TEMPLATE_FILENAME = "template_info.bin";

    private ConfignodeSnapshotParser() {
    }

    private static Path getLatestSnapshotPath(List<Path> snapshotPathList) {
        if (snapshotPathList.isEmpty()) {
            return null;
        }
        Path[] pathArray = snapshotPathList.toArray(new Path[0]);
        Arrays.sort(pathArray, (o1, o2) -> {
            String index1 = o1.toFile().getName().split("_")[1];
            String index2 = o2.toFile().getName().split("_")[1];
            return Long.compare(Long.parseLong(index2), Long.parseLong(index1));
        });
        return pathArray[0];
    }

    public static List<Pair<Pair<Path, Path>, CNSnapshotFileType>> getSnapshots() throws IOException {
        ArrayList<Pair<Pair<Path, Path>, CNSnapshotFileType>> snapshotPairList = new ArrayList<Pair<Pair<Path, Path>, CNSnapshotFileType>>();
        String snapshotPath = CONF.getConsensusDir();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(snapshotPath, new String[0]), "[0-9]*-[0-9]*-[0-9]*-[0-9]*-[0-9]*");){
            for (Path path : stream) {
                DirectoryStream<Path> filestream = Files.newDirectoryStream(Paths.get(path.toString() + File.separator + "sm", new String[0]));
                try {
                    ArrayList<Path> snapshotList = new ArrayList<Path>();
                    for (Path snapshotFolder : filestream) {
                        if (!snapshotFolder.toFile().isDirectory()) continue;
                        snapshotList.add(snapshotFolder);
                    }
                    Path latestSnapshotPath = ConfignodeSnapshotParser.getLatestSnapshotPath(snapshotList);
                    if (latestSnapshotPath == null) continue;
                    String rolePath = latestSnapshotPath + File.separator + "system" + File.separator + "roles";
                    try (DirectoryStream<Path> roleStream = Files.newDirectoryStream(Paths.get(rolePath, new String[0]));){
                        for (Path role : roleStream) {
                            Pair roleFile = new Pair((Object)role, null);
                            snapshotPairList.add((Pair<Pair<Path, Path>, CNSnapshotFileType>)new Pair((Object)roleFile, (Object)CNSnapshotFileType.ROLE));
                        }
                    }
                    String userPath = latestSnapshotPath + File.separator + "system" + File.separator + "users";
                    try (DirectoryStream<Path> userStream = Files.newDirectoryStream(Paths.get(userPath, new String[0]));){
                        ArrayList<Path> userFilePath = new ArrayList<Path>();
                        ArrayList<Path> userRoleFilePath = new ArrayList<Path>();
                        for (Path user : userStream) {
                            if (user.getFileName().toString().contains("_role.profile")) {
                                userRoleFilePath.add(user);
                                continue;
                            }
                            userFilePath.add(user);
                        }
                        for (Path user : userFilePath) {
                            snapshotPairList.add((Pair<Pair<Path, Path>, CNSnapshotFileType>)new Pair((Object)new Pair((Object)user, null), (Object)CNSnapshotFileType.USER));
                        }
                        for (Path roleList : userRoleFilePath) {
                            snapshotPairList.add((Pair<Pair<Path, Path>, CNSnapshotFileType>)new Pair((Object)new Pair((Object)roleList, null), (Object)CNSnapshotFileType.USER_ROLE));
                        }
                    }
                    File schemaInfoFile = SystemFileFactory.INSTANCE.getFile(latestSnapshotPath + File.separator + SNAPSHOT_CLUSTER_SCHEMA_FILENAME);
                    File templateInfoFile = SystemFileFactory.INSTANCE.getFile(latestSnapshotPath + File.separator + SNAPSHOT_TEMPLATE_FILENAME);
                    if (!schemaInfoFile.exists() || !templateInfoFile.exists()) continue;
                    snapshotPairList.add((Pair<Pair<Path, Path>, CNSnapshotFileType>)new Pair((Object)new Pair((Object)schemaInfoFile.toPath(), (Object)templateInfoFile.toPath()), (Object)CNSnapshotFileType.SCHEMA));
                }
                finally {
                    if (filestream == null) continue;
                    filestream.close();
                }
            }
        }
        return snapshotPairList;
    }

    public static CNPhysicalPlanGenerator translate2PhysicalPlan(Path path1, Path path2, CNSnapshotFileType type) throws IOException {
        if (type == CNSnapshotFileType.SCHEMA && (path1 == null || path2 == null)) {
            LOGGER.warn("Schema_template require schema info file and template file");
            return null;
        }
        if (path1 == null) {
            LOGGER.warn("Path1 should not be null");
            return null;
        }
        if (!path1.toFile().exists()) {
            LOGGER.warn("File {} not exists", (Object)path1.toFile().getName());
            return null;
        }
        if (type == CNSnapshotFileType.SCHEMA) {
            return new CNPhysicalPlanGenerator(path1, path2);
        }
        return new CNPhysicalPlanGenerator(path1, type);
    }
}

