/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.task;

import java.util.Map;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.task.stage.PipeTaskStage;
import org.apache.iotdb.commons.pipe.task.subtask.PipeSubtask;
import org.apache.iotdb.confignode.manager.pipe.execution.PipeConfigNodeSubtask;
import org.apache.iotdb.confignode.manager.pipe.execution.PipeConfigNodeSubtaskExecutor;
import org.apache.iotdb.pipe.api.exception.PipeException;

public class PipeConfigNodeTaskStage
extends PipeTaskStage {
    private final PipeConfigNodeSubtask subtask;

    public PipeConfigNodeTaskStage(String pipeName, long creationTime, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes, PipeTaskMeta pipeTaskMeta) {
        try {
            this.subtask = new PipeConfigNodeSubtask(pipeName, creationTime, extractorAttributes, processorAttributes, connectorAttributes, pipeTaskMeta);
        }
        catch (Exception e) {
            throw new PipeException(String.format("Failed to create subtask for pipe %s, creation time %d", pipeName, creationTime), (Throwable)e);
        }
    }

    public void createSubtask() throws PipeException {
        PipeConfigNodeSubtaskExecutor.getInstance().register((PipeSubtask)this.subtask);
    }

    public void startSubtask() throws PipeException {
        PipeConfigNodeSubtaskExecutor.getInstance().start(this.subtask.getTaskID());
    }

    public void stopSubtask() throws PipeException {
        PipeConfigNodeSubtaskExecutor.getInstance().stop(this.subtask.getTaskID());
    }

    public void dropSubtask() throws PipeException {
        PipeConfigNodeSubtaskExecutor.getInstance().deregister(this.subtask.getTaskID());
    }
}

