/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.receiver.visitor;

import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanVisitor;
import org.apache.iotdb.confignode.consensus.request.auth.AuthorPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DatabaseSchemaPlan;
import org.apache.iotdb.confignode.consensus.request.write.database.DeleteDatabasePlan;
import org.apache.iotdb.confignode.consensus.request.write.database.SetTTLPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeactivateTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteLogicalViewPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeDeleteTimeSeriesPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CommitSetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.CreateSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.DropSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.ExtendSchemaTemplatePlan;
import org.apache.iotdb.rpc.TSStatusCode;

public class PipeConfigPhysicalPlanTSStatusVisitor
extends ConfigPhysicalPlanVisitor<TSStatus, TSStatus> {
    @Override
    public TSStatus visitPlan(ConfigPhysicalPlan plan, TSStatus context) {
        return context;
    }

    @Override
    public TSStatus visitCreateDatabase(DatabaseSchemaPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_ALREADY_EXISTS.getStatusCode()) {
            if (context.getMessage().contains(String.format("%s has already been created as database", plan.getSchema().getName()))) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.SCHEMA_QUOTA_EXCEEDED.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_TEMPORARY_UNAVAILABLE_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateDatabase(plan, context);
    }

    @Override
    public TSStatus visitAlterDatabase(DatabaseSchemaPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_CONFIG_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitAlterDatabase(plan, context);
    }

    @Override
    public TSStatus visitDeleteDatabase(DeleteDatabasePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDeleteDatabase(plan, context);
    }

    @Override
    public TSStatus visitCreateSchemaTemplate(CreateSchemaTemplatePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateSchemaTemplate(plan, context);
    }

    @Override
    public TSStatus visitExtendSchemaTemplate(ExtendSchemaTemplatePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.MEASUREMENT_ALREADY_EXISTS_IN_TEMPLATE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitExtendSchemaTemplate(plan, context);
    }

    @Override
    public TSStatus visitCommitSetSchemaTemplate(CommitSetSchemaTemplatePlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.METADATA_ERROR.getStatusCode()) {
            if (context.getMessage().contains("Template already exists")) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
            if (context.getMessage().contains("Template t1 does not exist")) {
                return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
            }
        } else if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCommitSetSchemaTemplate(plan, context);
    }

    @Override
    public TSStatus visitPipeUnsetSchemaTemplate(PipeUnsetSchemaTemplatePlan pipeUnsetSchemaTemplatePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.TEMPLATE_NOT_SET.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode() || context.getCode() == TSStatusCode.TEMPLATE_IS_IN_USE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeUnsetSchemaTemplate(pipeUnsetSchemaTemplatePlan, context);
    }

    @Override
    public TSStatus visitDropSchemaTemplate(DropSchemaTemplatePlan dropSchemaTemplatePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.UNDEFINED_TEMPLATE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDropSchemaTemplate(dropSchemaTemplatePlan, context);
    }

    @Override
    public TSStatus visitPipeDeleteTimeSeries(PipeDeleteTimeSeriesPlan pipeDeleteTimeSeriesPlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeDeleteTimeSeries(pipeDeleteTimeSeriesPlan, context);
    }

    @Override
    public TSStatus visitPipeDeleteLogicalView(PipeDeleteLogicalViewPlan pipeDeleteLogicalViewPlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.PATH_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeDeleteLogicalView(pipeDeleteLogicalViewPlan, context);
    }

    @Override
    public TSStatus visitPipeDeactivateTemplate(PipeDeactivateTemplatePlan pipeDeactivateTemplatePlan, TSStatus context) {
        if (context.getCode() == TSStatusCode.TEMPLATE_NOT_ACTIVATED.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitPipeDeactivateTemplate(pipeDeactivateTemplatePlan, context);
    }

    @Override
    public TSStatus visitCreateUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateUser(plan, context);
    }

    @Override
    public TSStatus visitCreateRawUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateRawUser(plan, context);
    }

    @Override
    public TSStatus visitUpdateUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitUpdateUser(plan, context);
    }

    @Override
    public TSStatus visitDropUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDropUser(plan, context);
    }

    @Override
    public TSStatus visitGrantUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.NO_PERMISSION.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitGrantUser(plan, context);
    }

    @Override
    public TSStatus visitRevokeUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.NOT_HAS_PRIVILEGE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.USER_NOT_EXIST.getStatusCode() || context.getCode() == TSStatusCode.NO_PERMISSION.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitRevokeUser(plan, context);
    }

    @Override
    public TSStatus visitCreateRole(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.ROLE_ALREADY_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitCreateRole(plan, context);
    }

    @Override
    public TSStatus visitDropRole(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitDropRole(plan, context);
    }

    @Override
    public TSStatus visitGrantRole(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitGrantRole(plan, context);
    }

    @Override
    public TSStatus visitRevokeRole(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.NOT_HAS_PRIVILEGE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitRevokeRole(plan, context);
    }

    @Override
    public TSStatus visitGrantRoleToUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_ALREADY_HAS_ROLE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitGrantRoleToUser(plan, context);
    }

    @Override
    public TSStatus visitRevokeRoleFromUser(AuthorPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.USER_NOT_HAS_ROLE.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        if (context.getCode() == TSStatusCode.ROLE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitRevokeRoleFromUser(plan, context);
    }

    @Override
    public TSStatus visitTTL(SetTTLPlan plan, TSStatus context) {
        if (context.getCode() == TSStatusCode.DATABASE_NOT_EXIST.getStatusCode()) {
            return new TSStatus(TSStatusCode.PIPE_RECEIVER_USER_CONFLICT_EXCEPTION.getStatusCode()).setMessage(context.getMessage());
        }
        return (TSStatus)super.visitTTL(plan, context);
    }
}

