/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.pipe.extractor;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.pipe.datastructure.queue.listening.AbstractPipeListeningQueue;
import org.apache.iotdb.commons.pipe.event.EnrichedEvent;
import org.apache.iotdb.commons.pipe.event.SerializableEvent;
import org.apache.iotdb.commons.snapshot.SnapshotProcessor;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeEnrichedPlan;
import org.apache.iotdb.confignode.consensus.request.write.pipe.payload.PipeUnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.consensus.request.write.template.UnsetSchemaTemplatePlan;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionSnapshotEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigRegionWritePlanEvent;
import org.apache.iotdb.confignode.manager.pipe.event.PipeConfigSerializableEventType;
import org.apache.iotdb.confignode.manager.pipe.extractor.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.persistence.schema.CNSnapshotFileType;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.pipe.api.event.Event;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigRegionListeningQueue
extends AbstractPipeListeningQueue
implements SnapshotProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigRegionListeningQueue.class);
    private static final String SNAPSHOT_FILE_NAME = "pipe_config_region_listening_queue.bin";

    public synchronized void tryListenToPlan(ConfigPhysicalPlan plan, boolean isGeneratedByPipe) {
        if (ConfigRegionListeningFilter.shouldPlanBeListened(plan)) {
            PipeConfigRegionWritePlanEvent event;
            switch (plan.getType()) {
                case PipeEnriched: {
                    this.tryListenToPlan(((PipeEnrichedPlan)plan).getInnerPlan(), true);
                    return;
                }
                case UnsetTemplate: {
                    try {
                        event = new PipeConfigRegionWritePlanEvent(new PipeUnsetSchemaTemplatePlan(ConfigNode.getInstance().getConfigManager().getClusterSchemaManager().getTemplate(((UnsetSchemaTemplatePlan)plan).getTemplateId()).getName(), ((UnsetSchemaTemplatePlan)plan).getPath().getFullPath()), isGeneratedByPipe);
                        break;
                    }
                    catch (MetadataException e) {
                        LOGGER.warn("Failed to collect UnsetTemplatePlan", (Throwable)e);
                        return;
                    }
                }
                default: {
                    event = new PipeConfigRegionWritePlanEvent(plan, isGeneratedByPipe);
                }
            }
            this.tryListen((EnrichedEvent)event);
        }
    }

    public synchronized void tryListenToSnapshots(List<Pair<Pair<Path, Path>, CNSnapshotFileType>> snapshotPathInfoList) {
        ArrayList<PipeConfigRegionSnapshotEvent> events = new ArrayList<PipeConfigRegionSnapshotEvent>();
        for (Pair<Pair<Path, Path>, CNSnapshotFileType> snapshotPathInfo : snapshotPathInfoList) {
            Path snapshotPath = (Path)((Pair)snapshotPathInfo.getLeft()).getLeft();
            CNSnapshotFileType type = (CNSnapshotFileType)((Object)snapshotPathInfo.getRight());
            if (snapshotPath.toFile().length() == 0L || type == CNSnapshotFileType.USER && snapshotPath.toFile().getName().equals(AuthorityChecker.SUPER_USER + ".profile") || type == CNSnapshotFileType.USER_ROLE && snapshotPath.toFile().getName().equals(AuthorityChecker.SUPER_USER + "_role" + ".profile")) continue;
            Path templateFilePath = (Path)((Pair)snapshotPathInfo.getLeft()).getRight();
            events.add(new PipeConfigRegionSnapshotEvent(snapshotPath.toString(), Objects.nonNull(templateFilePath) && templateFilePath.toFile().length() > 0L ? templateFilePath.toString() : null, (CNSnapshotFileType)((Object)snapshotPathInfo.getRight())));
        }
        this.tryListen(events);
    }

    protected ByteBuffer serializeToByteBuffer(Event event) {
        return ((SerializableEvent)event).serializeToByteBuffer();
    }

    protected Event deserializeFromByteBuffer(ByteBuffer byteBuffer) {
        try {
            SerializableEvent result = PipeConfigSerializableEventType.deserialize(byteBuffer);
            ((EnrichedEvent)result).increaseReferenceCount(ConfigRegionListeningQueue.class.getName());
            return result;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load snapshot from byteBuffer {}.", (Object)byteBuffer);
            return null;
        }
    }

    public synchronized boolean processTakeSnapshot(File snapshotDir) throws TException, IOException {
        return super.serializeToFile(new File(snapshotDir, SNAPSHOT_FILE_NAME));
    }

    public synchronized void processLoadSnapshot(File snapshotDir) throws TException, IOException {
        super.deserializeFromFile(new File(snapshotDir, SNAPSHOT_FILE_NAME));
    }
}

