/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.load.balancer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.cluster.NodeStatus;
import org.apache.iotdb.confignode.conf.ConfigNodeDescriptor;
import org.apache.iotdb.confignode.consensus.request.write.region.CreateRegionGroupsPlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.exception.NotEnoughDataNodeException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyCopySetRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.GreedyRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.load.balancer.region.IRegionGroupAllocator;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;

public class RegionBalancer {
    private final IManager configManager;
    private final IRegionGroupAllocator regionGroupAllocator;

    public RegionBalancer(IManager configManager) {
        this.configManager = configManager;
        switch (ConfigNodeDescriptor.getInstance().getConf().getRegionGroupAllocatePolicy()) {
            case GREEDY: {
                this.regionGroupAllocator = new GreedyRegionGroupAllocator();
                break;
            }
            default: {
                this.regionGroupAllocator = new GreedyCopySetRegionGroupAllocator();
            }
        }
    }

    public CreateRegionGroupsPlan genRegionGroupsAllocationPlan(Map<String, Integer> allotmentMap, TConsensusGroupType consensusGroupType) throws NotEnoughDataNodeException, DatabaseNotExistsException {
        List<TDataNodeConfiguration> availableDataNodes = this.getNodeManager().filterDataNodeThroughStatus(NodeStatus.Running, NodeStatus.Unknown);
        for (String database : allotmentMap.keySet()) {
            int replicationFactor = this.getClusterSchemaManager().getReplicationFactor(database, consensusGroupType);
            if (availableDataNodes.size() >= replicationFactor) continue;
            throw new NotEnoughDataNodeException(availableDataNodes, replicationFactor);
        }
        CreateRegionGroupsPlan createRegionGroupsPlan = new CreateRegionGroupsPlan();
        List<TRegionReplicaSet> allocatedRegionGroups = this.getPartitionManager().getAllReplicaSets(consensusGroupType);
        for (Map.Entry<String, Integer> entry : allotmentMap.entrySet()) {
            String database = entry.getKey();
            int allotment = entry.getValue();
            int replicationFactor = this.getClusterSchemaManager().getReplicationFactor(database, consensusGroupType);
            List<TRegionReplicaSet> databaseAllocatedRegionGroups = this.getPartitionManager().getAllReplicaSets(database, consensusGroupType);
            for (int i = 0; i < allotment; ++i) {
                HashMap<Integer, TDataNodeConfiguration> availableDataNodeMap = new HashMap<Integer, TDataNodeConfiguration>(availableDataNodes.size());
                HashMap<Integer, Double> freeDiskSpaceMap = new HashMap<Integer, Double>(availableDataNodes.size());
                availableDataNodes.forEach(dataNodeConfiguration -> {
                    int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
                    availableDataNodeMap.put(dataNodeId, (TDataNodeConfiguration)dataNodeConfiguration);
                    freeDiskSpaceMap.put(dataNodeId, this.getLoadManager().getFreeDiskSpace(dataNodeId));
                });
                TRegionReplicaSet newRegionGroup = this.regionGroupAllocator.generateOptimalRegionReplicasDistribution(availableDataNodeMap, freeDiskSpaceMap, allocatedRegionGroups, databaseAllocatedRegionGroups, replicationFactor, new TConsensusGroupId(consensusGroupType, this.getPartitionManager().generateNextRegionGroupId()));
                createRegionGroupsPlan.addRegionGroup(database, newRegionGroup);
                allocatedRegionGroups.add(newRegionGroup);
                databaseAllocatedRegionGroups.add(newRegionGroup);
            }
        }
        return createRegionGroupsPlan;
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private PartitionManager getPartitionManager() {
        return this.configManager.getPartitionManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    public static enum RegionGroupAllocatePolicy {
        GREEDY,
        GCR;

    }
}

