/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.pipe.task;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.task.meta.PipeTaskMeta;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.utils.DateTimeUtils;

public class PipeTableResp
implements DataSet {
    private final TSStatus status;
    private final List<PipeMeta> allPipeMeta;

    public PipeTableResp(TSStatus status, List<PipeMeta> allPipeMeta) {
        this.status = status;
        this.allPipeMeta = allPipeMeta;
    }

    public List<PipeMeta> getAllPipeMeta() {
        return this.allPipeMeta;
    }

    public PipeTableResp filter(Boolean whereClause, String pipeName) {
        if (whereClause == null || !whereClause.booleanValue()) {
            if (pipeName == null) {
                return this;
            }
            ArrayList<PipeMeta> filteredPipeMeta = new ArrayList<PipeMeta>();
            for (PipeMeta pipeMeta : this.allPipeMeta) {
                if (!pipeMeta.getStaticMeta().getPipeName().equals(pipeName)) continue;
                filteredPipeMeta.add(pipeMeta);
                break;
            }
            return new PipeTableResp(this.status, filteredPipeMeta);
        }
        if (pipeName == null) {
            return this;
        }
        String sortedConnectorParametersString = null;
        for (PipeMeta pipeMeta : this.allPipeMeta) {
            if (!pipeMeta.getStaticMeta().getPipeName().equals(pipeName)) continue;
            sortedConnectorParametersString = pipeMeta.getStaticMeta().getConnectorParameters().toString();
            break;
        }
        ArrayList<PipeMeta> filteredPipeMeta = new ArrayList<PipeMeta>();
        for (PipeMeta pipeMeta : this.allPipeMeta) {
            if (!pipeMeta.getStaticMeta().getConnectorParameters().toString().equals(sortedConnectorParametersString)) continue;
            filteredPipeMeta.add(pipeMeta);
        }
        return new PipeTableResp(this.status, filteredPipeMeta);
    }

    public TGetAllPipeInfoResp convertToTGetAllPipeInfoResp() throws IOException {
        ArrayList<ByteBuffer> pipeInformationByteBuffers = new ArrayList<ByteBuffer>();
        for (PipeMeta pipeMeta : this.allPipeMeta) {
            pipeInformationByteBuffers.add(pipeMeta.serialize());
        }
        return new TGetAllPipeInfoResp(this.status, pipeInformationByteBuffers);
    }

    public TShowPipeResp convertToTShowPipeResp() {
        ArrayList<TShowPipeInfo> showPipeInfoList = new ArrayList<TShowPipeInfo>();
        for (PipeMeta pipeMeta : this.allPipeMeta) {
            PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
            PipeRuntimeMeta runtimeMeta = pipeMeta.getRuntimeMeta();
            StringBuilder exceptionMessageBuilder = new StringBuilder();
            for (PipeRuntimeException e : runtimeMeta.getNodeId2PipeRuntimeExceptionMap().values()) {
                exceptionMessageBuilder.append(DateTimeUtils.convertLongToDate((long)e.getTimeStamp(), (String)"ms")).append(", ").append(e.getMessage()).append("\n");
            }
            for (PipeTaskMeta pipeTaskMeta : runtimeMeta.getConsensusGroupId2TaskMetaMap().values()) {
                for (PipeRuntimeException e : pipeTaskMeta.getExceptionMessages()) {
                    exceptionMessageBuilder.append(DateTimeUtils.convertLongToDate((long)e.getTimeStamp(), (String)"ms")).append(", ").append(e.getMessage()).append("\n");
                }
            }
            showPipeInfoList.add(new TShowPipeInfo(staticMeta.getPipeName(), staticMeta.getCreationTime(), ((PipeStatus)runtimeMeta.getStatus().get()).name(), staticMeta.getExtractorParameters().toString(), staticMeta.getProcessorParameters().toString(), staticMeta.getConnectorParameters().toString(), exceptionMessageBuilder.toString()));
        }
        showPipeInfoList.sort(Comparator.comparing(pipeInfo -> pipeInfo.id));
        return new TShowPipeResp().setStatus(this.status).setPipeInfoList(showPipeInfoList);
    }
}

