/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.request.write.subscription.topic;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlan;
import org.apache.iotdb.confignode.consensus.request.ConfigPhysicalPlanType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class DropTopicPlan
extends ConfigPhysicalPlan {
    private String topicName;

    public DropTopicPlan() {
        super(ConfigPhysicalPlanType.DropTopic);
    }

    public DropTopicPlan(String topicName) {
        super(ConfigPhysicalPlanType.DropTopic);
        this.topicName = topicName;
    }

    public String getTopicName() {
        return this.topicName;
    }

    @Override
    protected void serializeImpl(DataOutputStream stream) throws IOException {
        stream.writeShort(this.getType().getPlanType());
        ReadWriteIOUtils.write((String)this.topicName, (OutputStream)stream);
    }

    @Override
    protected void deserializeImpl(ByteBuffer buffer) throws IOException {
        this.topicName = ReadWriteIOUtils.readString((ByteBuffer)buffer);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropTopicPlan that = (DropTopicPlan)obj;
        return Objects.equals(this.topicName, that.topicName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topicName);
    }

    public String toString() {
        return "DropTopicPlan{topicName='" + this.topicName + "'}";
    }
}

